/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file spi.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __SPI_H__
#define __SPI_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f731xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **SPI ʱӷƵ
/*---------------------------------------------------------------------------*/
#define		SPI_CLK_DIV_4		(0x00)
#define		SPI_CLK_DIV_8		(0x1<< SPI_SPCR_SPRn_Pos)
#define		SPI_CLK_DIV_16		(0x2<< SPI_SPCR_SPRn_Pos)
#define		SPI_CLK_DIV_32		(0x3<< SPI_SPCR_SPRn_Pos)
#define		SPI_CLK_DIV_64		(0x1<< SPI_SPCR_SPR2_Pos)
#define		SPI_CLK_DIV_128		((0x1<< SPI_SPCR_SPR2_Pos) | (0x1<< SPI_SPCR_SPRn_Pos))
#define		SPI_CLK_DIV_256		((0x1<< SPI_SPCR_SPR2_Pos) | (0x2<< SPI_SPCR_SPRn_Pos))
#define		SPI_CLK_DIV_512		((0x1<< SPI_SPCR_SPR2_Pos) | (0x3<< SPI_SPCR_SPRn_Pos))

/*----------------------------------------------------------------------------
 **SPI ʱӼ
/*---------------------------------------------------------------------------*/
#define		SPI_CLK_CPOL_LOW	(0x00) 						/*SPIʱӿʱΪ*/
#define		SPI_CLK_CPOL_HIGH	(0x01<< SPI_SPCR_CPOL_Pos)	/*SPIʱӿʱΪ*/

/*----------------------------------------------------------------------------
 **SPI ʱλ
/*---------------------------------------------------------------------------*/
#define		SPI_CLK_CPHA_0		(0x00)						/*SPIȷٷʱӣʱżز*/
#define		SPI_CLK_CPHA_1		(0x01<< SPI_SPCR_CPHA_Pos)	/*SPIȷʱٷݣʱز*/
/*----------------------------------------------------------------------------
 **SPI ģʽNSSxƬѡź
 ** עSPI_NSS_AUTO_CONTROLԶģʽУдSPIBufferͻԶƬѡ(SSCRе)+ݣ1ByteݺSPIԶNSSx
/*---------------------------------------------------------------------------*/
#define		SPI_NSS_SSCR_CONTROL		(0x0)			/*NSSxһֱĴSSCR*/
#define		SPI_NSS_AUTO_CONTROL		(0x01)			/*SPIʱNSSxߵƽSPIʱSSCR*/

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	SPI_Start
 **			SPIģ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_Start(void);
/*****************************************************************************
 ** \brief	SPI_Stop
 **			رSPIģ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_Stop(void);
/*****************************************************************************
 ** \brief	SPI_ConfigClk
 **			SPIʱ
 ** \param [in] SPIClkDiv (1)SPI_CLK_DIV_4 ~ SPI_CLK_DIV_512
 ** \return  none
 ** \note	 Fspi = Fsys / SPIClkDiv;
*****************************************************************************/
void SPI_ConfigClk(uint8_t SPIClkDiv);
/*****************************************************************************
 ** \brief	SPI_ConfigRunMode
 **			SPIģʽ
 ** \param [in] ClkPositive: ʱӼ
 **							 (1)SPI_CLK_CPOL_LOW      SPIʱӿʱΪ
 **							 (2)SPI_CLK_CPOL_HIGH	  SPIʱӿʱΪ
 **				ClkPhash: ʱλ
 **							  (1)SPI_CLK_CPHA_0 SPIȷٷʱӣʱżز
 **							  (2)SPI_CLK_CPHA_1:SSPIȷʱٷݣʱز
 **				NSSMode: NSSſѡ(ֻģʽ)
 **							  (1)SPI_NSS_SSCR_CONTROL:NSSxһֱĴSSCR
 **							  (2)SPI_NSS_AUTO_CONTROL:SPIʱNSSxߵƽSPIʱSSCR
 ** \return  none
 ** \note	
*****************************************************************************/
void SPI_ConfigRunMode(uint8_t ClkPositive, uint8_t ClkPhash, uint8_t NSSMode);

/*****************************************************************************
 ** \brief	SPI_EnableMasterMode
 **			ʹģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_EnableMasterMode(void);
/*****************************************************************************
 ** \brief	SPI_DisableMasterMode
 **			رģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_DisableMasterMode(void);
/*****************************************************************************
 ** \brief	SPI_EnableSlaveMode
 **			ʹܴӻģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_EnableSlaveMode(void);
/*****************************************************************************
 ** \brief	SPI_DisableSlaveMode
 **			رմӻģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_DisableSlaveMode(void);

/*****************************************************************************
 ** \brief	SPI_GetTransferIntFlag
 **			ȡжϱ־λ
 ** \param [in] none
 ** \return  1:SPI  0:SPIδ
 ** \note	 
*****************************************************************************/
uint8_t SPI_GetTransferIntFlag(void);
/*****************************************************************************
 ** \brief	SPI_ClearTransferIntFlag
 **			жϱ־λ
 ** \param [in] none
 ** \return  note
 ** \note	 
*****************************************************************************/
void SPI_ClearTransferIntFlag(void);
/*****************************************************************************
 ** \brief	SPI_GetWriteErrorIntFlag
 **			ȡдͻжϱ־λ
 ** \param [in] none
 ** \return  1:SPIдͻ  0:SPIдͻ
 ** \note	 
*****************************************************************************/
uint8_t SPI_GetWriteErrorIntFlag(void);
/*****************************************************************************
 ** \brief	SPI_ClearWriteErrorIntFlag
 **			дͻжϱ־λ
 ** \param [in] none
 ** \return none
 ** \note	 
*****************************************************************************/
void SPI_ClearWriteErrorIntFlag(void);
/*****************************************************************************
 ** \brief	SPI_EnableIntFlag
 **			SPIж
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_EnableIntFlag(void);
/*****************************************************************************
 ** \brief	SPI_DisableIntFlag
 **			رSPIж
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SPI_DisableIntFlag(void);




#endif /* __SPI_H__ */