#include <cms.h>
#include "Touch_Kscan_Library.h"
#include "REL_Sender.h"

volatile unsigned char MainTime;
volatile bit	B_MainLoop;

//ϵͳʼ
void Init_System()
{
	asm("nop");
	asm("clrwdt");
	
	PORTA = 0;
	PORTB = 0;
	PORTC = 0;
	INTCON = 0x00;
	PIR1 = 0;
	PIR2 = 0;
	TRISA = 0x00;
	TRISB = 0x00;
	TRISC = 0x00;
	
	OPTION_REG = 0;
	OSCCON = 0x72;
	PIE1 = 0;
	PIE2 = 0;
	//IOCA = 0;
	//IOCB = 0;
	WPUA = 0;
	WPUB = 0;
	WPUC = 0;
	
	PIE2 = 0;
	PIE1 = 0B00000010;
	PR2 = 125;				//16M½TMR2Ϊ125usж
	T2CON = 5;				//ʹܶʱ2
	INTCON = 0XC0;			//ʹж
}


/**********************************************************
ƣRefurbish_Sfr
ܣˢһЩ⹦ܼĴ
ڲ
ڲ 
    עÿһʱˢһSFRǿ
**********************************************************/
void Refurbish_Sfr()
{
	asm("clrwdt");
	TRISA = 0x00;
	TRISB = 0x00;
	TRISC = 0x00;
	OPTION_REG = 0;
	OSCCON = 0x72;
	PIE1 = 0B00000010;
	PR2 = 125;
	INTCON = 0XC0;
	if(5 != T2CON)
		T2CON = 5;
}


/***********************************************************

***********************************************************/
void Kscan()
{
	static unsigned int KeyOldFlag = 0;
	unsigned int i = (unsigned int)((_CMS_KeyFlag[1]<<8) | _CMS_KeyFlag[0]);
	if(i)
	{
		if(i != KeyOldFlag)
		{
			KeyOldFlag = i;
		}
	}
	else
	{
		KeyOldFlag = 0;
	}
}

/***********************************************************
жϷ
***********************************************************/
void interrupt Isr_Timer()
{
	if(TMR2IF)				//ֻʹһжԴ,ȥж
	{
		TMR2IF = 0;
		if(++MainTime >= 20)
		{
			MainTime = 0;
			B_MainLoop = 1;
		}
	}
}

/***********************************************************
ѭ
***********************************************************/
void main()
{
	Init_System();
	while(1)
	{
		if(B_MainLoop)
		{
			B_MainLoop = 0;
			Refurbish_Sfr();
			Kscan();
			__CMS_CheckTouchKey();
			#if (REL_SENDER_ENABLE == 1)//Ժ궨ǷΪ1
				REL_SenderLoop();//ӳ
			#endif
		}
	}
}