/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file epwm.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __EPWM_H__
#define __EPWM_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms8m3510.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **EPWMͨMask
/*---------------------------------------------------------------------------*/
#define EPWM_CHANNEL_NUM                     (6)    /* EPWM channel number */
#define EPWM_CH_0_MSK                       (0x1)   /* EPWM channel 0 mask */
#define EPWM_CH_1_MSK                       (0x2)   /* EPWM channel 1 mask */
#define EPWM_CH_2_MSK                       (0x4)   /* EPWM channel 2 mask */
#define EPWM_CH_3_MSK                       (0x8)   /* EPWM channel 3 mask */
#define EPWM_CH_4_MSK                       (0x10)  /* EPWM channel 4 mask */
#define EPWM_CH_5_MSK                       (0x20)  /* EPWM channel 5 mask */

#define EPWM0								(0x00)	/* EPWM channel 0 number */
#define EPWM1								(0x01)	/* EPWM channel 1 number */
#define EPWM2								(0x02)	/* EPWM channel 2 number */
#define EPWM3								(0x03)	/* EPWM channel 3 number */
#define EPWM4								(0x04)	/* EPWM channel 4 number */
#define EPWM5								(0x05)	/* EPWM channel 5 number */
/*----------------------------------------------------------------------------
 **EPWMģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_COUNT_UP_DOWN			(0x02)  /*EPWMCOUNTģʽ¼Ķ룩ģʽ*/
#define EPWM_COUNT_DOWN				(0x00)  /*EPWMCOUNTģʽ¼ض룩ģʽ*/
/*----------------------------------------------------------------------------
 **EPWMȽϵԪ(OCU)ģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_OCU_ASYMMETRIC			(0x04)  /*EPWMȽϵԪOCUģʽ ǶԳƼģʽ*/
#define EPWM_OCU_SYMMETRIC			(0x00)  /*EPWMȽϵԪOCUģʽ ԳƼģʽ*/
/*----------------------------------------------------------------------------
 **EPWMηԪ(WFG)ģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_WFG_INDEPENDENT 		(0x00)  /*EPWMηWFGģʽģʽ*/
#define EPWM_WFG_COMPLEMENTARY 		(0x10)  /*EPWMηWFGģʽģʽ*/
#define EPWM_WFG_SYNCHRONIZED		(0x20)  /*EPWMηWFGģʽͬģʽ*/
/*----------------------------------------------------------------------------
 **EPWMƵԪ(OC)ģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_OC_GROUP					(0x08)  /*EPWMƣOCģʽ ģʽ*/
#define EPWM_OC_INDEPENDENT 			(0x00)  /*EPWMƣOCģʽ ͨԶ*/
/*----------------------------------------------------------------------------
 **EPWMɲԴ
/*---------------------------------------------------------------------------*/
#define EPWM_BRK_SOFTWARE  					(0x00)		/*ɲ*/
#define EPWM_BRK_FB							(0x01)		/*FBɲ*/
#define EPWM_BRK_ACMP0						(0x02)		/*ACMP0ɲ*/
#define EPWM_BRK_ACMP1						(0x03)		/*ACMP1ɲ*/
#define EPWM_BRK_ADC						(0x04)		/*ADCȽɲ*/
/*----------------------------------------------------------------------------
 **EPWMɲԴFBɲģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_BRK_FB_LOW						(0x0<< EPWM_PWMFBKC_PWMFBES_Pos)	/*FB͵ƽɲ*/
#define EPWM_BRK_FB_HIGH					(0x1<< EPWM_PWMFBKC_PWMFBES_Pos)	/*FBߵƽɲ*/
/*----------------------------------------------------------------------------
 **EPWM ɲģʽ
/*---------------------------------------------------------------------------*/
#define EPWM_BRK_COUNT_HOLD					(0x1<< EPWM_PWMFBKC_PWMFBCCE_Pos)	/*ɲ0*/
#define EPWM_BRK_COUNT_CLEAR				(0x00)					/*ɲ0*/

/*----------------------------------------------------------------------------
 **EPWMʱӷƵϵ
 * ܷƵ(PWMnDIVƵ) = Fpwmn-PSCƵ * CLK_DIVƵ
 *   Fpwmn-PSCƵ = PWMnPSC/2 (PWMnPSCΪ0)----2Ƶ
/*---------------------------------------------------------------------------*/
#define EPWM_CLK_DIV_1						(0xff)					//=Fsysϵͳʱӣ
#define EPWM_CLK_DIV_2						(0x04)					//= Fpwmn-PSC   (PWMnPSC/2)
#define EPWM_CLK_DIV_4						(0x00)					//= Fpwmn-PSC/2 ((PWMnPSC/2)/2)
#define EPWM_CLK_DIV_8						(0x01)					//= Fpwmn-PSC/4 ((PWMnPSC/2)/4)
#define EPWM_CLK_DIV_16						(0x02)					//= Fpwmn-PSC/8 ((PWMnPSC/2)/8)
#define EPWM_CLK_DIV_32						(0x03)					//= Fpwmn-PSC/16((PWMnPSC/2)/16)



/*****************************************************************************
 ** \brief	 EPWM_ENABLE_LOAD
 **			 ʹܼڡռձ(PERIODnCMPnCMPDn)
 ** \param [in]ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note    
 ****************************************************************************/
#define EPWM_ENABLE_LOAD(ChannelMask) 	(PWMLOADEN |= ChannelMask)

/*****************************************************************************
 ** \brief	 EPWM_ENABLE_COUNT
 **			 ʹEPWM
 ** \param [in] ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
** \note    
 ****************************************************************************/
#define EPWM_ENABLE_COUNT(ChannelMask) 	(PWMCNTE |= ChannelMask)

/*****************************************************************************
 ** \brief	 EPWM_DISABLE_COUNT
 **			 رEPWM
 ** \param [in] ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
** \note   
 ****************************************************************************/
#define EPWM_DISABLE_COUNT(ChannelMask) 	(PWMCNTE &= ~ChannelMask)

/*****************************************************************************
 ** \brief	 EPWM_ENABLE_OUTPUT
 **			 ʹEPWM
 ** \param [in] ChannelMask : EPWM_CH_0_MSK EPWM_CH_1_MSK EPWM_CH_2_MSK 
 **							 EPWM_CH_3_MSK EPWM_CH_4_MSK EPWM_CH_5_MSK
 ** \return  none
 ****************************************************************************/
#define EPWM_ENABLE_OUTPUT(ChannelMask) 	(PWMOE |= ChannelMask)
/*****************************************************************************
 ** \brief	 EPWM_DISABLE_OUTPUT
 **			 رEPWM
 ** \param [in]ChannelMask : EPWM_CH_0_MSK EPWM_CH_1_MSK EPWM_CH_2_MSK 
 **							 EPWM_CH_3_MSK EPWM_CH_4_MSK EPWM_CH_5_MSK
 ** \return  none
 ****************************************************************************/
#define EPWM_DISABLE_OUTPUT(ChannelMask) 	(PWMOE &= ~ChannelMask)
/*****************************************************************************
 ** \brief	 EPWM_SET_MASK_LEVEL
 **			EPWMƽ
 ** \param [in] MaskValue : xx000000 : EPWM0~5 ֵΪ
 **						  ......
 **						  xx111111 : EPWM0~5 ֵΪ
 ** \return  none
 ** \note    PG0 : bit0 PG1bit1PG2: bit2PG3bit3PG4bit4PG5bit5
 ****************************************************************************/
#define EPWM_SET_MASK_LEVEL(MaskValue)  (PWMMASKD = MaskValue)

/*****************************************************************************
 ** \brief	 EPWM_ENABLE_MASK
 **			EPWM
 ** \param [in] ChannelMsk : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note    
 ****************************************************************************/
#define EPWM_ENABLE_MASK(ChannelMsk)  (PWMMASKE |= ChannelMsk)

/*****************************************************************************
 ** \brief	 EPWM_DISABLE_MASK
 **			 رEPWM
 ** \param [in] ChannelMsk : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note    
 ****************************************************************************/
#define EPWM_DISABLE_MASK(ChannelMsk)  (PWMMASKE &= ~(ChannelMsk))

/*****************************************************************************
 ** \brief	 EPWM_SET_BRAKE_LEVEL
 **			EPWMɲƽ
 ** \param [in]MaskValue : xx000000 : EPWM0~5 ɲƽΪ
 **						  ......
 **						  xx111111 : EPWM0~5 ɲƽΪ
 ** \return  none
 ** \note    PG0 : bit0 PG1bit1PG2: bit2PG3bit3PG4bit4PG5bit5
 ****************************************************************************/
#define EPWM_SET_BRAKE_LEVEL(BrakeValue)  ( PWMFBKD = BrakeValue)
												  

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 EPWM_ConfigRunMode
 **			 EPWMģʽ
 ** \param [in] EpwmRunMode:  
							   (1)EPWM_COUNT_UP_DOWN
							   (2)EPWM_COUNT_DOWN
							   (3)EPWM_OCU_ASYMMETRIC
							   (4)EPWM_OCU_SYMMETRIC
							   (5)EPWM_WFG_INDEPENDENT
							   (6)EPWM_WFG_COMPLEMENTARY
							   (7)EPWM_WFG_SYNCHRONIZED
							   (8)EPWM_OC_GROUP
							   (9)EPWM_OC_INDEPENDENT
 ** \return  none
 ** \note    9ʽϳɲͬģʽҹһ8λĴ
 ****************************************************************************/
void EPWM_ConfigRunMode( uint8_t EpwmRunMode);
/*****************************************************************************
 ** \brief	 EPWM_ConfigChannelClk	
 ** \param [in] ClkDiv: (1)EPWM_CLK_DIV_1 
 **						(2)EPWM_CLK_DIV_2
 **						(2)EPWM_CLK_DIV_4
 **						(2)EPWM_CLK_DIV_8
 **						(2)EPWM_CLK_DIV_16
 **						(2)EPWM_CLK_DIV_32
 ** \return  none	
 ** \note 
 **	(1)PWM01PSCͬPWM0PWM1ͨ Դ˺ͳһPWMxxPSC=0x01
 **	ҪķƵԼĴֵ
 **	(2)EPWM ƵΪPWMxPSC PWMnDIV 
 **	һƵ(PWMxPSC)0x00 ԤƵֹͣҼֹͣϵͳʱӷƵϵPWMxPSC+1
 **	ڶƵPWMnDIV): 0x00 FEPWMPSC/2; 0x01 FEPWMPSC/40x02:FEPWMPSC/80x3 FEPWMPSC/16
 **	0x04 FEPWMPSC ;  Fsys 
 ** Ƶ1~4096Fsys=8MEPWMƵʷΧ1.95k ~ 8M	
 ****************************************************************************/
void EPWM_ConfigChannelClk(uint8_t ChannelNum,uint8_t ClkDiv);
/*****************************************************************************
 ** \brief	 EPWM_ConfigChannelPeriod
 **			 EPWMͨƵԼռձ
 ** \param [in] ChannelNum : EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 **				Period: 16λֵ
 ** \return none
 ** \note    
 ****************************************************************************/
void EPWM_ConfigChannelPeriod(uint8_t ChannelNum,uint16_t Period);
 
/*****************************************************************************
 ** \brief	 EPWM_ConfigChannelSymDuty
 **			 EPWMͨԳģʽռձ
 ** \param [in] ChannelNum  :EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 **				Duty: 16λռձ
 ** \return none
 ** \note   
 ****************************************************************************/
void EPWM_ConfigChannelSymDuty(uint8_t ChannelNum,uint16_t Duty);
 /*****************************************************************************
 ** \brief	 EPWM_ConfigChannelAsymDuty
 **			 EPWMͨǶԳģʽռձ
 ** \param [in] ChannelNum  :EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 **				DownCmp: 16 bit ±Ƚֵ
 ** \return none
 ** \note    ֻĶ(¼)ģʽ
 ****************************************************************************/
void EPWM_ConfigChannelAsymDuty(uint8_t ChannelNum,uint16_t UpCmp, uint16_t DowmCmp);
 
 /****************************************************************************
 ** \brief	 EPWM_EnableOneShotMode
 **			 One-Shotģʽ
 ** \param [in]  ChannelMask   EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note	
*****************************************************************************/
void EPWM_EnableOneShotMode(uint8_t ChannelMask);
/****************************************************************************
 ** \brief	 EPWM_EnableAutoLoadMode
 **			 Զģʽ
 ** \param [in]  ChannelMask   EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note	
*****************************************************************************/
void EPWM_EnableAutoLoadMode(uint8_t ChannelMask);

/*****************************************************************************
 ** \brief	 EPWM_Start
 **			
 ** \param [in]  ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note	
 ****************************************************************************/
void EPWM_Start( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_Stop
 **				
 ** \param [in] ChannelMask   EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note    ֹͣEPWM0
*****************************************************************************/
void EPWM_Stop( uint8_t ChannelMask);

/*****************************************************************************
 ** \brief	 EPWM_EnableOutput
 **			 EPWM
 ** \param [in] ChannelMask   EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_EnableOutput( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisableOutput
 **			 رEPWM
 ** \param [in] ChannelMask   EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 ** \return  none
 ** \note    
*****************************************************************************/
void EPWM_DisableOutput( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_EnableFaultBrake
 **			 EPWMɲģʽ
 ** \param [in] BrakeSource: [0]: EPWM_BRK_SOFTWARE		:ɲ
 **						   	[1]: EPWM_BRK_FB			:ⲿӲɲͨ
 **                        	[2]: EPWM_BRK_ACMP0			:Ƚ0ɲ
 **                        	[3]: EPWM_BRK_ACMP1			:Ƚ1ɲ
 ** 					   	[4]: EPWM_BRK_ADC			:ADCɲ
 **				CountMode:(1)EPWM_BRK_COUNT_HOLD		
 **						  (2)EPWM_BRK_COUNT_CLEAR
 ** \return  none
 ** \note  	 
*****************************************************************************/
void EPWM_EnableFaultBrake( uint8_t BrakeSource , uint8_t CountMode);
/*****************************************************************************
 ** \brief	 EPWM_DisableFaultBrake
 **			 رEPWMɲ
 ** \param [in] BrakeSource: [0]: EPWM_BRK_SOFTWARE		:ɲ
 **						   	[1]: EPWM_BRK_FB			:ⲿӲɲͨ
 **                        	[2]: EPWM_BRK_ACMP0			:Ƚ0ɲ
 **                        	[3]: EPWM_BRK_ACMP1			:Ƚ1ɲ
 ** 					   	[4]: EPWM_BRK_ADC			:ADCɲ
 ** \return  none
 ** \note    
*****************************************************************************/
void EPWM_DisableFaultBrake( uint8_t BrakeSource);
/****************************************************************************
 ** \brief	 EPWM_ConfigChannelBrakeLevel
 **			 EPWMͨɲƽ
 ** \param [in]  ChannelMask EPWM_CH_0_MSK ~ EPWM_CH_5_MSK
 **		   		 BrakeLevel: FaultBreakeEPWMͨƽ 0/1(/)
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_ConfigChannelBrakeLevel( uint8_t ChannelMask, uint8_t BrakeLevel);

/****************************************************************************
 ** \brief	 EPWM_EnableDeadZone
 **			 
 ** \param [in] ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK		
 **			DeadTime : ʱ( 0~0xFF) = DeadTime * Tepwm
 ** \return  none
 ** \note  
*****************************************************************************/
void EPWM_EnableDeadZone( uint8_t ChannelMask, uint8_t DeadTime);
/*****************************************************************************
 ** \brief	 EPWM_DisableDeadZone
 **			 رEPWM
 ** \param [in] ChannelMask:  EPWM_CH_0_MSK ~ EPWM_CH_5_MSK		
 ** \return  none
 ** \note  
*****************************************************************************/
void EPWM_DisableDeadZone( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_EnableMaskControl
 **			 ƿ
 ** \param [in] ChannelMask:  EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	 	
 ** 	    	MaskLevel:  :0/1(/)
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_EnableMaskControl( uint8_t ChannelMask, uint8_t MaskLevel);
/*****************************************************************************
 ** \brief	 EPWM_DisableMaskControl
 **			 ƹر
 ** \param [in] ChannelMask:  EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	 		
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_DisableMaskControl( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_EnableUpCmpInt
 **			 ϱȽж
 ** \param [in]  ChannelMask EPWM_CH_0_MSK ~ EPWM_CH_5_MSK		
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_EnableUpCmpInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisableUpCmptInt
 **			 رϱȽж
 ** \param [in]ChannelMask EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_DisableUpCmpInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_GetUpCmpIntFlag
 **			 ȡϱȽжϱ־λ
 ** \param [in] ChannelNum:EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5 
 ** \return  0: жϲ
 **          1жϲ
 ** \note   
*****************************************************************************/
uint8_t EPWM_GetUpCmpIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_ClearUpCmpIntFlag
 **			 ϱȽжϱ־λ
 ** \param [in] ChannelNum:EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_ClearUpCmpIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_EnableDownCmpInt
 **			 ±Ƚж
 ** \param [in] ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_EnableDownCmpInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisableDownCmpInt
 **			 ر±Ƚж
 ** \param [in] ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_DisableDownCmpInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_GetUpCmpIntFlag
 **			 ȡ±Ƚжϱ־λ
 ** \param [in] ChannelNum: EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return  0: жϲ
 **          1жϲ
 ** \note   
*****************************************************************************/
uint8_t EPWM_GetDownCmpIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_ClearUpCmpIntFlag
 **			 ±Ƚжϱ־λ
 ** \param [in] ChannelNum :EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return  none
 ** \note   
*****************************************************************************/
void EPWM_ClearDownCmpIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_EnablePeriodInt
 **			 ж
 ** \param [in] ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_EnablePeriodInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisablePeriodInt
 **			 رж
 ** \param [in]  ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_DisablePeriodInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_ClearPeriodIntFlag
 **			 ȡжϱ־λ 
 ** \param [in]  ChannelNum: EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return   0жϲ
 **           1жϲ
 ** \note   
*****************************************************************************/
uint8_t EPWM_GetPeriodIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_ClearPeriodIntFlag
 **			 жϱ־λ 
 ** \param [in]  ChannelNum: EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_ClearPeriodIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_EnableZeroInt
 **			 ж
 ** \param [in]  ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_EnableZeroInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisableZeroInt
 **			 رж 
 ** \param [in]ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_DisableZeroInt( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_GetZeroIntFlag
 **			 ȡжϱ־λ 
 ** \param [in] ChannelNum: EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return   0жϲ
 **           1жϲ   
 ** \note   
 *****************************************************************************/
uint8_t EPWM_GetZeroIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_ClearZeroIntFlag
 **			 жϱ־λ
 ** \param [in] ChannelNum: EPWM0,EPWM1,EPWM2,EPWM3,EPWM4,EPWM5
 ** \return   none     
 ** \note   
*****************************************************************************/
void EPWM_ClearZeroIntFlag( uint8_t ChannelNum);
/*****************************************************************************
 ** \brief	 EPWM_EnableFaultBrakeInt	
 **			 ɲж 
 ** \param [in]none
 ** \return  none
 ** \note  
*****************************************************************************/
void EPWM_EnableFaultBrakeInt( void);
/*****************************************************************************
 ** \brief	 EPWM_DisableFaultBrakeInt	
 **			 رչɲж 
 ** \param [in]none
 ** \return  none
 ** \note 
*****************************************************************************/
void EPWM_DisableFaultBrakeInt(void);
/*****************************************************************************
 ** \brief	 EPWM_GetFaultBrakeIntFlag
 **			 ȡɲжϱ־λ
 ** \param [in] none
 ** \return  0: жϲ
 **          1жϲ
 ** \note  
*****************************************************************************/
uint8_t EPWM_GetFaultBrakeIntFlag( void);
/*****************************************************************************
 ** \brief	 EPWM_ClearFaultBrakeIntFlag	
 ** 		 ɲжϱ־λ 
 ** \param [in] none
 ** \return  none
 ** \note 
 *****************************************************************************/
void EPWM_ClearFaultBrakeIntFlag( void);
/*****************************************************************************
 ** \brief	 EPWM_TrigSoftwareBrake
 **			  ɲ
 ** \param [in]	none
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_TrigSoftwareBrake(void);
/*****************************************************************************
 ** \brief	 EPWM_DisableSoftwareBreake
 **			 رɲ
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_DisableSoftwareBrake(void);
/*****************************************************************************
 ** \brief	 EPWM_EnableReverseOutput
 **			 
 ** \param [in] ChannelMask : EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return  none
 ** \note  ģʽ EPWM ʼӳֵʼʱPWMΪ͵ƽ, 
 **	EPWMֵϡ¼ƥʱת
*****************************************************************************/
void  EPWM_EnableReverseOutput( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_DisableReverseOutput
 **			 رշ
 ** \param [in]ChannelMask: EPWM_CH_0_MSK ~ EPWM_CH_5_MSK	
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_DisableReverseOutput( uint8_t ChannelMask);
/*****************************************************************************
 ** \brief	 EPWM_ConfigFBBrake
 **			 FBɲ
 ** \param [in] FBBrakeLevel : (1)EPWM_BRK_FB_LOW
 **                           		    (2)EPWM_BRK_FB_HIGH	
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_ConfigFBBrake(uint8_t FBBrakeLevel);

/*****************************************************************************
 ** \brief	 EPWM_AllIntEnable
 **			 ʹEPWMж
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_AllIntEnable(void);
/*****************************************************************************
 ** \brief	 EPWM_AllIntDisable
 **			 رEPWMж
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void  EPWM_AllIntDisable(void);

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/

#endif /* __EPWM_H__ */







