/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file timer.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __TIMER_H__
#define __TIMER_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms8m3510.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **Timer ģ
---------------------------------------------------------------------------*/
#define		TMR0					(0x00)			/* Timer 0 Number*/	
#define		TMR1					(0x01)			/* Timer 1 Number*/	
#define 	TMR2					(0x02)			/* Timer 2 Number*/	
#define		TMR3					(0x03)			/* Timer 3 Number*/	
#define 	TMR4					(0x04)			/* Timer 4 Number*/	

/*----------------------------------------------------------------------------
 **Timer ģʽ
---------------------------------------------------------------------------*/
#define		TMR_MODE_TIMING		 	(0x00)			/*ʱʱģʽ(Timer 0,1,3,4)*/
#define		TMR_MODE_COUNT			(0x01)			/*ʱģʽ(Timer 0,1)*/
	
/*----------------------------------------------------------------------------
 **Timer ʱӷƵ
---------------------------------------------------------------------------*/	
#define 	TMR_CLK_DIV_12			(0x00)			/*ϵͳʱ12Ƶ(Timer 0,1,3,4)*/
#define 	TMR_CLK_DIV_4			(0x01)			/*ϵͳʱ4Ƶ(Timer 0,1,3,4)*/
/*----------------------------------------------------------------------------
 **Timer ʱ/ģʽ
---------------------------------------------------------------------------*/	
#define 	TMR_TIM_13BIT					(0x00)		/*ʱ/13λģʽ*/
#define 	TMR_TIM_16BIT					(0x01)		/*ʱ/16λģʽ*/
#define 	TMR_TIM_AUTO_8BIT				(0x02)		/*ʱ/8λԶģʽ*/
#define 	TMR_TIM_TWO_INDEPENDENT_8BIT	(0x03)		/*ʱ/28λģʽ*/

/*----------------------------------------------------------------------------
 ****************************************************************************
---------------------------------------------------------------------------*/	
/*----------------------------------------------------------------------------
 **Timer2 ʱ//Ƚ/ģʽ
---------------------------------------------------------------------------*/	
#define		TMR2_MODE_TIMING		(0x01)			/*ʱ2ʱģʽ*/
#define		TMR2_MODE_COUNT			(0x02)			/*ʱ2ģʽ*/
#define 	TMR2_MODE_COMPARE		(0x02)			/*ʱ2Ƚģʽ*/
/*----------------------------------------------------------------------------
 **Timer2 ʱӷƵ
---------------------------------------------------------------------------*/	
#define 	TMR2_CLK_DIV_12			(0x00)						/*ϵͳʱ12Ƶ*/
#define 	TMR2_CLK_DIV_24			(0x01<<TMR_T2CON_T2PS_Pos)	/*ϵͳʱ24Ƶ*/
/*----------------------------------------------------------------------------
 **Timer2 Ƚ/ͨ
---------------------------------------------------------------------------*/	
#define 	TMR2_CC0				(0x00)			/*Timer2 Compare or Capture Channel 0 number*/
#define 	TMR2_CC1				(0x01)			/*Timer2 Compare or Capture Channel 1 number*/
#define 	TMR2_CC2				(0x02)			/*Timer2 Compare or Capture Channel 2 number*/
#define 	TMR2_CC3				(0x03)			/*Timer2 Compare or Capture Channel 3 number*/


/*----------------------------------------------------------------------------
 **Timer2 ģ ģʽ
---------------------------------------------------------------------------*/	
#define 	TMR2_CAP_WRITE_REGISTER	(0x03)						/*ͨдĴʱ*/
#define		TMR2_CAP_EDGE_FALLING	(0x00)						/*ͨ½ز*/
#define		TMR2_CAP_EDGE_RISING	(0x01)						/*ͨز*/
#define		TMR2_CAP_EDGE_BOTH		(0x03)						/*ͨ½ضɲ*/	
/*----------------------------------------------------------------------------
 **Timer2 ģʽ
---------------------------------------------------------------------------*/	
#define 	TMR2_AUTO_LOAD			(0x02<< TMR_T2CON_T2Rn_Pos)	/*Timer2Զģʽ*/
#define		TMR2_T2EX_LOAD			(0x03<< TMR_T2CON_T2Rn_Pos)	/*Timer2T2EX½ģʽ*/
#define		TMR2_LOAD_DISBALE		(0x00<< TMR_T2CON_T2Rn_Pos)	/*ֹ*/
/*----------------------------------------------------------------------------
 **Timer2 Ƚģʽ
---------------------------------------------------------------------------*/	
#define		TMR2_CMP_MODE_0			(0x00)						/*Timer2Ƚģʽ0*/
#define		TMR2_CMP_MODE_1			(0x01<< TMR_T2CON_T2CM_Pos)	/*Timer2Ƚģʽ1*/
/*----------------------------------------------------------------------------
 **Timer2 Ƚģ0 жϲģʽ
---------------------------------------------------------------------------*/	
#define		TMR2_CMP_INT_MODE1		(0x01<< TMR_T2CON_I3FR_Pos)	/*Ƚͨ0TL2/TH2RLDL/RLDHӲȵʱ̲ж*/	
#define		TMR2_CMP_INT_MODE0		(0x00)						/*Ƚͨ0TL2/TH2RLDL/RLDHȵʱ̲ж*/	


/***************************************************************************
 ** \brief	TMR0_SET_PERIOD
 **			öʱʱ
 ** \param [in] TimerPeriodH:(1)TH0 
 **				TimerPeriodL:(1)TL0 
 ** \return  none
 ** \note    13λʱ THx[7:0],TLx[4:0]
*****************************************************************************/
#define		TMR0_SET_PERIOD(TimerPeriodH,TimerPeriodL)	do{\
															TH0 = (uint8_t)TimerPeriodH;\
															TL0 = (uint8_t)TimerPeriodL;\					
														}while(0)
/***************************************************************************
 ** \brief	TMR1_SET_PERIOD
 **			öʱʱ
 ** \param [in] TimerPeriodH:(1)TH1 
 **				TimerPeriodL:(1)TL1 
 ** \return  none
 ** \note    13λʱ THx[7:0],TLx[4:0]
*****************************************************************************/
#define		TMR1_SET_PERIOD(TimerPeriodH,TimerPeriodL)	do{\
															TH1 = (uint8_t)TimerPeriodH;\
															TL1 = (uint8_t)TimerPeriodL;\					
															}while(0)
/***************************************************************************
 ** \brief	TMR3_SET_PERIOD
 **			öʱʱ
 ** \param [in] TimerPeriodH:(1)TH3 
 **				TimerPeriodL:(1)TL3 
 ** \return  none
 ** \note    13λʱ THx[7:0],TLx[4:0]
*****************************************************************************/
#define		TMR3_SET_PERIOD(TimerPeriodH,TimerPeriodL)	do{\
															TH3 = (uint8_t)TimerPeriodH;\
															TL3 = (uint8_t)TimerPeriodL;\					
															}while(0)
															
/***************************************************************************
 ** \brief	TMR4_SET_PERIOD
 **			öʱʱ
 ** \param [in] TimerPeriodH:(1)TH4 
 **				TimerPeriodL:(1)TL4 
 ** \return  none
 ** \note    13λʱ THx[7:0],TLx[4:0]
*****************************************************************************/
#define		TMR4_SET_PERIOD(TimerPeriodH,TimerPeriodL)	do{\
															TH4 =(uint8_t)TimerPeriodH;\
															TL4 =(uint8_t)TimerPeriodL;\					
															}while(0)															
																													
/***************************************************************************
 ** \brief	TMR2_SET_PERIOD
 **			öʱʱ
 ** \param [in]  TimerPeriod:16bit
 ** \return  none
 ** \note    
*****************************************************************************/
#define		TMR2_SET_PERIOD(TimerPeriod)	do{\
													TH2 = (uint8_t)(TimerPeriod >> 8);\
													TL2 = (uint8_t)(TimerPeriod);\														
												}while(0)

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	TMR_ConfigRunMode
 **			öʱģʽ
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 **				TimerMode 	(1)TMR_MODE_TIMING	:ʱģʽ
 **							  (2)TMR_MODE_COUNT		:ģʽ
 **				TimerModeBranch	ģʽķ֧
 **								(1)TMR_TIM_13BIT 	:13λʱ/ģʽ
 **								(2)TMR_TIM_16BIT 	:16λʱ/ģʽ		
 **								(3)TMR_TIM_AUTO_8BIT :8λԶضʱ/ģʽ
 **								(4)TMR_TIM_TWO_INDEPENDENT_8BIT	:8λʱ/ģʽ
 ** \return  none
 ** \note    ˺֧TMR2 
 *****************************************************************************/
void TMR_ConfigRunMode(uint8_t Timern, uint8_t TimerMode, uint8_t TimerModeBranch);
/*****************************************************************************
 ** \brief	TMR_ConfigTimerClk
 **			öʱʱ
 ** \param [in]  Timern			TMR0,TMR1,TMR3,TMR4
 **				TimerClkDiv	(1)TMR_CLK_DIV_4 
 **							  (2)TMR_CLK_DIV_12
 ** \note   
 *****************************************************************************/
void TMR_ConfigTimerClk(uint8_t Timern,uint8_t TimerClkDiv);
/***************************************************************************
 ** \brief	TMR_ConfigTimerPeriod
 **			öʱʱ
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 **				TimerPeriodH:(1)TH0 (2)TH1 (3)TH3 (4)TH4
 **				TimerPeriodL:(1)TL0 (2)TL1 (3)TL3 (4)TL4
 ** \return  none
 ** \note   13λʱ THx[7:0],TLx[4:0]
*****************************************************************************/
void TMR_ConfigTimerPeriod(uint8_t Timern , uint8_t TimerPeriodHigh,uint8_t TimerPeriodLow);
/*****************************************************************************
 ** \brief	TMR_EnableGATE
 **			ʹܶʱſ
 ** \param [in] Timern		TMR0,TMR1
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR_EnableGATE(uint8_t Timern);
/*****************************************************************************
 ** \brief	TMR_DisableGATE
 **			رնʱſ
 ** \param [in] Timern		TMR0,TMR1
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR_DisableGATE(uint8_t Timern);

/*****************************************************************************
 ** \brief	TMR_GetCountValue
 **			ȡʱģʽļֵ
 ** \param [in] Timern		TMR0,TMR1
 ** \return  16bitsļֵ[THn:TLn]
 ** \note   ģʽ2/3: ʹ
 *****************************************************************************/
uint16_t TMR_GetCountValue(uint8_t Timern);

/*****************************************************************************
 ** \brief	TMR_EnableOverflowInt
 **			ʹܶʱж
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR_EnableOverflowInt(uint8_t TimerMask);

/*****************************************************************************
 ** \brief	TMR_DisableOverflowInt
 **			رնʱж
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR_DisableOverflowInt(uint8_t TimerMask);
/*****************************************************************************
 ** \brief	TMR_GetOverflowIntFlag
 **			ȡʱжϱ־
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return   0жϣ 1ж
 ** \note   ʱ03ʹģʽ3ʱTLnжʹTMR03жϱ־
 **									   THnжʹTMR14жϱ־ 
 *****************************************************************************/
uint8_t TMR_GetOverflowIntFlag(uint8_t TimerNumber);
/*****************************************************************************
 ** \brief	TMR_ClearOverflowIntFlag
 **			ʱжϱ־
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR_ClearOverflowIntFlag(uint8_t TimerNumber);
/*****************************************************************************
 ** \brief	TMR_Start
 **			ʱ
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR_Start(uint8_t Timern);
/*****************************************************************************
 ** \brief	TMR_Stop
 **			رնʱ
 ** \param [in] Timern			TMR0,TMR1,TMR3,TMR4
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR_Stop(uint8_t Timern);


/*****************************************************************************
 ** \brief	TMR2_ConfigRunMode
 **			Timer2ģʽ
 ** \param [in]	Timer2Mode 	:	(1)TMR2_MODE_TIMING	:ʱģʽ
 **								(2)TMR2_MODE_COUNT	:ģʽ
 **			   Timer2LoadMode		
 **								(1)TMR2_AUTO_LOAD	:ʱ2Զģʽ
 **								(2)TMR2_T2EX_LOAD	:ʱ2ⲿģʽ
**								(3)TMR2_LOAD_DISBALE: ֹ
 ** \return  none
 ** \note    
*****************************************************************************/
void TMR2_ConfigRunMode(  uint8_t Timer2Mode, uint8_t Timer2LoadMode);
/*****************************************************************************
 ** \brief	TMR2_ConfigTimerClk
 **			öʱʱ
 ** \param [in]	TimerClkDiv	TMR2_CLK_DIV_12 TMR2_CLK_DIV_24
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_ConfigTimerClk(uint8_t TimerClkDiv);

/***************************************************************************
 ** \brief	TMR2_ConfigTimerPeriod
 **			öʱ2ʱ
 ** \param [in] TimerPeriodʱ2ʱ
 ** \return  none
 ** \note   
*****************************************************************************/
void TMR2_ConfigTimerPeriod(uint16_t TimerPeriod);
/*****************************************************************************
 ** \brief	TMR2_EnableGATE
 **			ʹܶʱ2ſع
 ** \param [in] none
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_EnableGATE(void);
/*****************************************************************************
 ** \brief	TMR2_DisableGATE
 **			رնʱ2ſع
 ** \param [in] none
 ** \return  none
 ** \note  
 *****************************************************************************/
void TMR2_DisableGATE(void);
/*****************************************************************************
 ** \brief	TMR2_EnableCompare
 **			ʹܱȽģʽ
 ** \param [in]	Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 **				CompareMode :(1)TMR2_CMP_MODE_0
 **							 (2)TMR2_CMP_MODE_1
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_EnableCompare(uint8_t Timer2CCn, uint8_t CompareMode);
/*****************************************************************************
 ** \brief	TMR2_DisableCompare
 **			رձȽģʽ
 ** \param [in]	Timer2CCMask:  TMR2_CC0 ~ TMR2_CC3
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_DisableCompare(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_ConfigCompareValue
 **			ñȽͨȽֵ
 ** \param [in]	Timer2CCMask:  TMR2_CC0 ~ TMR2_CC3
 **				CompareValue:  0x0 ~ 0xFFFF;
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_ConfigCompareValue(uint8_t Timer2CCn, uint16_t CompareValue);

/*****************************************************************************
 ** \brief	TMR2_ConfigCompareIntMode
 **			ñȽͨȽжģʽ
 ** \param [in]	Timer2CompareIntMode:	(1)TMR2_CMP_INT_MODE0   
 **										(2)TMR2_CMP_INT_MODE1	  
 ** \return  none
 ** \note   
 **						 
 *****************************************************************************/
void TMR2_ConfigCompareIntMode(uint8_t Timer2CompareIntMode);

/*****************************************************************************
 ** \brief	TMR2_EnableCapture
 **			ʹܲģʽ
 ** \param [in]	Timer2CCMask:  TMR2_CC0 ~ TMR2_CC3
 **				Timer2CaptureMode: (1)TMR2_CAP_WRITE_REGISTER   ͨдĴʱ
 **								   (2)TMR2_CAP_EDGE_FALLING		ͨ½ز			  	
 **								   (3)TMR2_CAP_EDGE_RISING		ͨز
 **								   (4)TMR2_CAP_EDGE_BOTH		ͨ½ضɲ							   
 ** \return  none
 ** \note  
 *****************************************************************************/
void TMR2_EnableCapture(uint8_t Timer2CCn, uint8_t Timer2CaptureMode);

/*****************************************************************************
 ** \brief	TMR2_DisableCapture
 **			رղģʽ
 ** \param [in]	Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return  none
 ** \note   
*****************************************************************************/
void TMR2_DisableCapture(uint8_t Timer2CCn);

/*****************************************************************************
 ** \brief	TMR2_GetCaptureValue
 **			ȡֵ
 ** \param [in]	Timer2CCn:  TMR2_CC0 ~ TMR2_CC3			
 ** \return  16bit value
 ** \note   
 *****************************************************************************/
uint16_t TMR2_GetCaptureValue(uint8_t Timer2CCn);

/*****************************************************************************
 ** \brief	TMR2_EnableOverflowInt
 **			ʹܶʱ2ж
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_EnableOverflowInt(void);
/*****************************************************************************
 ** \brief	TMR2_DisableOverflowInt
 **			رնʱ2ж
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_DisableOverflowInt(void);
/*****************************************************************************
 ** \brief	TMR_GetOverflowIntFlag
 **			ȡʱ2жϱ־
 ** \param [in] none
 ** \return   0жϣ 1ж
 ** \note   
 *****************************************************************************/
uint8_t TMR2_GetOverflowIntFlag(void);
/*****************************************************************************
 ** \brief	TMR2_ClearOverflowIntFlag
 **			ʱ2жϱ־
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_ClearOverflowIntFlag(void);

/*****************************************************************************
 ** \brief	TMR2_EnableT2EXInt
 **			ʹܶʱ2ⲿT2EXж
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_EnableT2EXInt(void);

/*****************************************************************************
 ** \brief	TMR2_DisableT2EXInt
 **			رնʱ2ⲿT2EXж
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_DisableT2EXInt(void);
/*****************************************************************************
 ** \brief	TMR_GetT2EXIntFlag
 **			ȡʱ2ⲿT2EXжϱ־
 ** \param [in] none
 ** \return   0жϣ 1ж
 ** \note   
 *****************************************************************************/
uint8_t TMR2_GetT2EXIntFlag(void);
/*****************************************************************************
 ** \brief	TMR2_ClearT2EXIntFlag
 **			ʱ2ⲿT2EXжϱ־
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_ClearT2EXIntFlag(void);

/*****************************************************************************
 ** \brief	TMR2_EnableCompareInt
 **			ʹܶʱ2ͨȽж
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_EnableCompareInt(uint8_t Timer2CCn);

/*****************************************************************************
 ** \brief	TMR2_DisableCompareInt
 **			رնʱ2ͨȽж
 ** \param [in] Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_DisableCompareInt(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_GetCompareIntFlag
 **			ȡʱ2ͨȽжϱ־
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   0жϣ 1ж
 ** \note   
 *****************************************************************************/
uint8_t TMR2_GetCompareIntFlag(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_ClearCompareIntFlag
 **			ʱ2ͨȽжϱ־
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_ClearCompareIntFlag(uint8_t Timer2CCn);

/*****************************************************************************
 ** \brief	TMR2_EnableCaptureInt
 **			ʹܶʱ2ͨж
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_EnableCaptureInt(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_DisableCaptureInt
 **			رնʱ2ͨж
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_DisableCaptureInt(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_GetCaptureIntFlag
 **			ȡʱ2ͨжϱ־
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   0жϣ 1ж
 ** \note   
 *****************************************************************************/
uint8_t TMR2_GetCaptureIntFlag(uint8_t Timer2CCn);
/*****************************************************************************
 ** \brief	TMR2_ClearCaptureIntFlag
 **			ʱ2ͨжϱ־
 ** \param [in]Timer2CCn:  TMR2_CC0 ~ TMR2_CC3
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_ClearCaptureIntFlag(uint8_t Timer2CCn);


/*****************************************************************************
 ** \brief	TMR2_AllIntEnable
 **			ʱ2жϿ
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_AllIntEnable(void);

/*****************************************************************************
 ** \brief	TMR2_AllIntDisable
 **			ʱ2жϹر
 ** \param [in] none
 ** \return   none
 ** \note   
 *****************************************************************************/
void TMR2_AllIntDisable(void);
/*****************************************************************************
 ** \brief	TMR2_Start
 **			ʱ2
 ** \param [in] none
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_Start(void);
/*****************************************************************************
 ** \brief	TMR2_Stop
 **			رնʱ2
 ** \param [in] none
 ** \return  none
 ** \note   
 *****************************************************************************/
void TMR2_Stop(void);

#endif /* __TIMER_H__ */






