/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file adc.c
**
**  
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "dac.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/

/*****************************************************************************
 ** \brief	 DAC_Start		
**           DAC 
 ** \param [in] DACn : DAC0DAC1     
 ** \return  none
*****************************************************************************/
void  DAC_Start(uint8_t DACn)
{
	if(DAC0 == DACn)
	{
		DAC0CON0 |= DAC_DAC0CON0_DAC0EN_Msk;
	}
	if(DAC1 == DACn)
	{
		DAC1CON0 |= DAC_DAC1CON0_DAC1EN_Msk;
	}
	
}
/*****************************************************************************
 ** \brief	 DAC_Stop	
**           رDAC
 ** \param [in] DACn : DAC0DAC1           
 ** \return  none
*****************************************************************************/
void  DAC_Stop(uint8_t DACn)
{
	if(DAC0 == DACn)
	{
		DAC0CON0 &= ~DAC_DAC0CON0_DAC0EN_Msk;
	}
	if(DAC1 == DACn)
	{
		DAC1CON0 &= ~DAC_DAC1CON0_DAC1EN_Msk;
	}
}

/*****************************************************************************
 ** \brief	 DAC_ConfigVoltageOut
 **			  DACѹ
** \param [in] 
**						DACn : DAC0DAC1   
**						DACVoltageSet: 0~0x3f 	
**								0x00: 0V
**								0x01: 20mV
**								0x02: 40mV
**								0x03: 60mV
**								......
**						    0x3f: 1.26V
**           ѹ= 20mV * DACVoltageSet
 ** \return  none
 ** \note 	
*****************************************************************************/
void  DAC_ConfigVoltageOut(uint8_t DACn,uint8_t DACVoltageSet)
{
	uint8_t temp;
	if(DAC0 == DACn)
	{
		temp = DAC0CON1;
		temp &= ~(DAC_DAC0CON1_DAC0D_Msk);
		temp |=  DACVoltageSet;
		DAC0CON1 = temp;
	}
	if(DAC1 == DACn)
	{
		uint8_t temp;
		temp = DAC1CON1;
		temp &= ~(DAC_DAC1CON1_DAC1D_Msk);
		temp |=  DACVoltageSet;
		DAC1CON1 = temp;
	}

}



