/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file dac.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __DAC_H__
#define __DAC_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms8h5120x.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **DAC ͨ
/*---------------------------------------------------------------------------*/
#define DAC0					(0x00)		/*dac channel 0 number*/
#define DAC1					(0x01)		/*dac channel 1 number*/
/*----------------------------------------------------------------------------
 **DAC
/*---------------------------------------------------------------------------*/
#define  DAC_OUT_0mv		 	(0x00)				
#define  DAC_OUT_20mv			(0x01)				
#define  DAC_OUT_40mv		 	(0x02)				
#define  DAC_OUT_60mv			(0x03)				
#define  DAC_OUT_80mv		 	(0x04)				
#define  DAC_OUT_100mv			(0x05)				
#define  DAC_OUT_120mv		 	(0x06)				
#define  DAC_OUT_140mv			(0x07)				
#define  DAC_OUT_160mv		 	(0x08)				
#define  DAC_OUT_180mv			(0x09)				
#define  DAC_OUT_200mv			(0x0a)		
#define  DAC_OUT_1240mv			(0x3e)	
#define  DAC_OUT_1260mv			(0x3f)	

/*****************************************************************************
 ** \brief	 DAC_Start		
**           DAC 
 ** \param [in] DACn : DAC0DAC1     
 ** \return  none
*****************************************************************************/
void  DAC_Start(uint8_t DACn);

/*****************************************************************************
 ** \brief	 DAC_Stop	
**           رDAC
 ** \param [in] DACn : DAC0DAC1           
 ** \return  none
*****************************************************************************/
void  DAC_Stop(uint8_t DACn);

/*****************************************************************************
 ** \brief	 DAC_ConfigVoltageOut
 **			  DACѹ
** \param [in] 
**						DACn : DAC0DAC1   
**						DACVoltageSet: 0~0x3f 	
**								0x00: 0V
**								0x01: 20mV
**								0x02: 40mV
**								0x03: 60mV
**								......
**						    0x3f: 1.26V
**           ѹ= 20mV * DACVoltageSet
 ** \return  none
 ** \note 	
*****************************************************************************/
void  DAC_ConfigVoltageOut(uint8_t DACn,uint8_t DACVoltageSet);


#endif /* __DAC_H__ */






