/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file adc.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __ADC_H__
#define __ADC_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms8h5120x.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **ADC ͨ
/*---------------------------------------------------------------------------*/
#define  ADC_CH_0		 	(0x00)				/* AN0 */
#define  ADC_CH_1			(0x01)				/* AN1 */
#define  ADC_CH_2		 	(0x02)				/* AN2 */
#define  ADC_CH_3			(0x03)				/* AN3 */
#define  ADC_CH_4		 	(0x04)				/* AN4 */
#define  ADC_CH_5			(0x05)				/* AN5 */
#define  ADC_CH_6		 	(0x06)				/* AN6 */
#define  ADC_CH_7			(0x07)				/* AN7 */
#define  ADC_CH_8		 	(0x08)				/* AN8 */
#define  ADC_CH_9			(0x09)				/* AN9 */
#define  ADC_CH_10			(0x0a)				/* AN10 */
#define  ADC_CH_11		 	(0x0b)				/* AN11 */
#define  ADC_CH_12			(0x0c)				/* AN12 */
#define  ADC_CH_13		 	(0x0d)				/* AN13 */
#define  ADC_CH_14			(0x0e)				/* AN14 */
#define  ADC_CH_15			(0x0f)				/* AN15 */

#define  ADC_CH_16			(0x10)				/* AN16 */
#define  ADC_CH_17			(0x11)				/* AN17 */
#define  ADC_CH_18			(0x12)				/* AN18 */
#define  ADC_CH_19			(0x13)				/* AN19 */
#define  ADC_CH_20			(0x14)				/* AN20 */
#define  ADC_CH_21			(0x15)				/* AN21 */
#define  ADC_CH_22			(0x16)				/* AN22 */
//#define  ADC_CH_23			(0x17)				/* AN23 */
//#define  ADC_CH_24			(0x18)				/* AN24 */
//#define  ADC_CH_25			(0x19)				/* AN25 */
//#define  ADC_CH_26			(0x1a)				/* AN26 */
//#define  ADC_CH_27			(0x1b)				/* AN27 */
//#define  ADC_CH_28			(0x1c)				/* AN28 */
//#define  ADC_CH_29			(0x1d)				/* AN29 */
//#define  ADC_CH_30			(0x1e)				/* AN30 */
#define  ADC_CH_31			(0x1f)				/* AN31 */


#define  ADC_CH_31_BGR			(0x0)				/* AN31ӹ̶οѹ1.2V*/
#define  ADC_CH_31_ACMP_VREF	(0x1)				/* AN31ACMP_VREF*/
#define  ADC_CH_31_OP0_O    	(0x2)				/* AN31OP0*/
#define  ADC_CH_31_OP1_O    	(0x3)				/* AN31OP1*/
#define  ADC_CH_31_PGA    		(0x4)				/* AN63 PGAڲź*/
#define  ADC_CH_31_VSS			  (0x5)				/* AN31 VSS ADCο*/
#define  ADC_CH_31_VDD			  (0x7)				/* AN31 VDD οѹ*/

/*----------------------------------------------------------------------------
 **ADC ʱ
/*---------------------------------------------------------------------------*/
#define  ADC_SP_TIME_4		(0x1<<ADC_ADCON3_SPTIME_Pos)		/*4ADC Clock*/
#define  ADC_SP_TIME_8		(0x0<<ADC_ADCON3_SPTIME_Pos)		/*8ADC Clock*/
/*----------------------------------------------------------------------------
 **ADC ʱӷƵ
/*---------------------------------------------------------------------------*/
#define  ADC_CLK_DIV_1		(0x10)
#define  ADC_CLK_DIV_6		(0x11)
#define  ADC_CLK_DIV_12		(0x12)
#define  ADC_CLK_DIV_24		(0x13)
#define  ADC_CLK_DIV_48		(0x14)
#define  ADC_CLK_DIV_96		(0x15)
#define  ADC_CLK_DIV_192	(0x16)


#define  ADC_CLK_DIV_2		(0x00)
#define  ADC_CLK_DIV_4		(0x01)
#define  ADC_CLK_DIV_8		(0x02)
#define  ADC_CLK_DIV_16		(0x03)
#define  ADC_CLK_DIV_32		(0x04)
#define  ADC_CLK_DIV_64		(0x05)
#define  ADC_CLK_DIV_128	(0x06)
#define  ADC_CLK_DIV_256	(0x07)
/*----------------------------------------------------------------------------
 **ADC תʽ
/*---------------------------------------------------------------------------*/
#define	 ADC_RESULT_LEFT	(0x00<< ADC_ADCON0_ADFM_Pos)			/**/
#define  ADC_RESULT_RIGHT	(0x01<< ADC_ADCON0_ADFM_Pos)			/*Ҷ*/

/*----------------------------------------------------------------------------
 **ADC ת
/*---------------------------------------------------------------------------*/
#define	 ADC_CT_TIME_1		(0x00)			/*1ת*/
#define	 ADC_CT_TIME_4		(0x01)			/*4ת*/
#define	 ADC_CT_TIME_8		(0x02)			/*8ת*/
#define	 ADC_CT_TIME_16		(0x03)			/*16ת*/
/*----------------------------------------------------------------------------
 **ADC Ӳģʽ
/*---------------------------------------------------------------------------*/
#define	ADC_TG_PWM0			(0x00)		//PWM0ADCת
#define	ADC_TG_PWM2			(0x01)		//PWM2ADCת
#define	ADC_TG_PWM4			(0x02)		//PWM4ADCת
#define	ADC_TG_ADET			(0x03)		//ADETŴADCת

#define	ADC_TG_FALLING		(0x00)		//½ش
#define	ADC_TG_RISING		(0x01)		//ش
#define	ADC_TG_PWM_PE		(0x02)		//PWMڵڵ㴥
#define	ADC_TG_PWM_ZE		(0x03)		//PWMڵ㴥

/*----------------------------------------------------------------------------
 **ADC Ƚ
/*---------------------------------------------------------------------------*/
#define ADC_CMP_NEG			(0x1<<ADC_ADCMPC_ADCMPPS_Pos)		//תСڱȽֵADCMPO =1;
#define ADC_CMP_POS			(0x0)								//תڻڱȽֵADCMPO =1;

/*****************************************************************************
 ** \brief	 ADC_IS_BUSY
 **			 жADC״̬
 ** \param [in]	 none        
 ** \return   
*****************************************************************************/
#define  ADC_IS_BUSY				(ADCON0 & ADC_ADCON0_ADGO_Msk)
/*****************************************************************************
 ** \brief	 ADC_GO
 **			 ADCת()
 ** \param [in]	 none     
 ** \return  none
*****************************************************************************/
#define  ADC_GO() 				 do{\
									ADCON0 |= ADC_ADCON0_ADGO_Msk;\
								   }while(0)
							   
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/
                   
/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 ADC_Start
 **			 ADCģ鿪
 ** \param [in]	 none
 **          
 ** \return  none
*****************************************************************************/
void  ADC_Start(void);
/*****************************************************************************
 ** \brief	 ADC_Stop
 **			 ADCģֹͣ
 ** \param [in] none
 **          
 ** \return  none
*****************************************************************************/
void  ADC_Stop(void);

/*****************************************************************************
 ** \brief	 ADC_ConfigRunMode
 **			  ADCģʽ
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 **          	ADCResultTpye: (1)ADC_RESULT_LEFT    
 **							   (2)ADC_RESULT_RIGHT   Ҷ
 ** \return  none
 ** \note 	 ģʽ: ADRESHݵĸ8λADRESL4λݵ4λ
 **			 Ҷģʽ: ADRESHݵĸ4λADRESLݵ8λ	
*****************************************************************************/
void  ADC_ConfigRunMode( uint8_t ADCClkDiv, uint8_t ADCResultTpye);

/*****************************************************************************
 ** \brief	 ADC_ConfigSampleTime
 **			  ADCĲʱ
 ** \param [in] ADCSample: (1)ADC_SP_TIME_4		
 **						   (2)ADC_SP_TIME_8
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigSampleTime( uint8_t ADCSample);

/*****************************************************************************
 ** \brief	 ADC_ConfigConvertTime
 **			  ADCת
 ** \param [in] ConvertTime:  (1)ADC_CT_TIME_1		1ת	
 **						      (2)ADC_CT_TIME_4		4ת
 **						      (3)ADC_CT_TIME_8		8ת
 **						      (4)ADC_CT_TIME_16		16ת
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigConvertTime( uint8_t ConvertTime);

/*****************************************************************************
 ** \brief	 ADC_EnableHardwareTrig
 **			ʹӲADC
 ** \param [in] none
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_EnableHardwareTrig(void);

/*****************************************************************************
 ** \brief	 ADC_DisableHardwareTrigger
 **			رӲADC
 ** \param [in] none
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_DisableHardwareTrig(void);

/*****************************************************************************
 ** \brief	 ADC_ConfigHardwareTrig
 **			 Ӳģʽ
 ** \param [in] ADCTGSource: ADC_TG_PWM0ADC_TG_PWM2ADC_TG_PWM4ADC_TG_ADET
 **				TGMode(1)ADC_TG_FALLING
 **						(2)ADC_TG_RISING
 **						(3)ADC_TG_PWM_PE
 **						(4)ADC_TG_PWM_ZE
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_ConfigHardwareTrig(uint8_t ADCTGSource, uint8_t TGMode);
/*****************************************************************************
 ** \brief	 ADC_SetTrigDelayTime
 **			Ӳģʽʱʱ
 ** \param [in]  TrigTime: 0~1023
 ** \return  none
 ** \note 	(TrigTime + 4)) *Tsys
*****************************************************************************/
void  ADC_SetTrigDelayTime(uint16_t TrigTime);

/*****************************************************************************
 ** \brief	 ADC_EnableChannel
 **			 ʹADCתͨ
 ** \param [in]  ADCChannel: ADC_CH_0 ..... ADC_CH_31
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_EnableChannel(uint8_t ADCChannel);

/*****************************************************************************
 ** \brief	 ADC_ConfigAN31
 **			 AN63ͨ
 ** \param [in]	An31Channel:1ADC_CH_31_BGR...ADC_CH_31_VDD
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigAN31(uint8_t An31Channel);

/*****************************************************************************
 ** \brief	 ADC_ConfigCompareValue
 **			 ADCȽֵ
 ** \param [in]  ADCCompareValue: ADCMPH,ADCMPL
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_ConfigCompareValue(uint16_t ADCCompareValue);

/*****************************************************************************
 ** \brief	 ADC_ConfigCompareOut
 **			 ADCȽ
 ** \param [in] Config : (1)ADC_CMP_NEG	תСڱȽֵADCMPO =1;
 **						 (2)ADC_CMP_POS תڻڱȽֵADCMPO =1;
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_ConfigCompareOut(uint8_t Config);

/*****************************************************************************
 ** \brief	 ADC_GetCmpResult
 **			 ȡADCȽϽ
 ** \param [in]  none
 ** \return   0/1
 ** \note 
*****************************************************************************/
uint8_t  ADC_GetCmpResult(void);

/*****************************************************************************
 ** \brief	 ADC_GetADCResult
 **			 ȡADCת
 ** \param [in]  none
 ** \return  12bits ADCֵ
 ** \note 
*****************************************************************************/
uint16_t  ADC_GetADCResult(void);

/*****************************************************************************
 ** \brief	 ADC_EnableInt
 **			 ADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_EnableInt(void);
/*****************************************************************************
 ** \brief	 ADC_DisableInt
 **			 رADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_DisableInt(void);
/*****************************************************************************
 ** \brief	 ADC_GetIntFlag
 **			 ȡADCתжϱ־λ
 ** \param [in]  none
 ** \return  0жϣ1ж
 ** \note 
******************************************************************************/
uint8_t ADC_GetIntFlag(void);
/******************************************************************************
 ** \brief	 ADC_ClearIntFlag
 **			 ADCתжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void ADC_ClearIntFlag(void);



#endif /* __ADC_H__ */






