/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file acmp.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __ACMP_H__
#define __ACMP_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms8h5120x.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **ACMP 通道
---------------------------------------------------------------------------*/
#define ACMP0 					(0x00)			/* ACMP channel 0 number */
#define ACMP1					(0x01)			/* ACMP channel 1 number */
/*----------------------------------------------------------------------------
 **ACMP 输出滤波时间
---------------------------------------------------------------------------*/
#define ACMP_NFCLK_1_TSYS		(0x00)		/*(0~1)*Tsys*/
#define ACMP_NFCLK_2_TSYS		(0x01)		/*(1~2)*Tsys*/
#define ACMP_NFCLK_3_TSYS		(0x02)		/*(2~3)*Tsys*/
#define ACMP_NGCLK_5_TSYS		(0x03)		/*(4~5)*Tsys*/
#define ACMP_NFCLK_9_TSYS		(0x04)		/*(8~9)*Tsys*/
#define ACMP_NFCLK_17_TSYS		(0x05)		/*(16~17)*Tsys*/
#define ACMP_NFCLK_33_TSYS		(0x06)		/*(32~33)*Tsys*/
#define ACMP_NGCLK_65_TSYS		(0x07)		/*(64~65)*Tsys*/
#define ACMP_NFCLK_129_TSYS		(0x08)		/*(128~129)*Tsys*/
#define ACMP_NFCLK_257_TSYS		(0x09)		/*(256~257)*Tsys*/
#define ACMP_NFCLK_513_TSYS		(0x0a)		/*(512~513)*Tsys*/
/*----------------------------------------------------------------------------
 **ACMP 正端通道
---------------------------------------------------------------------------*/
#define ACMP_POSSEL_P0			(0x00)		/*ACMP P0输入端口*/
#define ACMP_POSSEL_P1			(0x01)		/*ACMP P1输入端口*/
#define ACMP_POSSEL_P2			(0x02)		/*ACMP P2输入端口*/
#define ACMP_POSSEL_P4			(0x04)		/*ACMP P4输入端口*/
#define ACMP_POSSEL_P5			(0x05)		/*ACMP P5输入端口*/
#define ACMP_POSSEL_PGAANA		(0x06)		/*PGA输出*/
/*----------------------------------------------------------------------------
 **ACMP 负端通道
---------------------------------------------------------------------------*/
#define ACMP_NEGSEL_VREF_VDD	(0x03)		/*ACMP Vref 源选择VDD*/
#define ACMP_NEGSEL_VREF_BG		(0x02)		/*ACMP Vref 源选择BG 1.2V*/
#define ACMP_NEGSEL_BG			(0x01)		/*Bandgap:1.2V*/
#define ACMP_NEGSEL_CN			(0x00)		/*ACMP N输入端口*/

/*----------------------------------------------------------------------------
 **ACMP 刹车模式
---------------------------------------------------------------------------*/
#define ACMP_BRK_RISING		(0x00)				/*ACMP输出上升沿刹车*/
#define ACMP_BRK_FALLING	(0x01)				/*ACMP输出下降沿刹车*/

/*----------------------------------------------------------------------------
 **ACMP 正负迟滞
/*---------------------------------------------------------------------------*/
#define ACMP_HYS_SEL_P			(0x01)			/*正迟滞*/
#define ACMP_HYS_SEL_N			(0x02)			/*负迟滞*/
#define ACMP_HYS_SEL_BOUTH		(0x03)			/*正负迟滞*/
/*----------------------------------------------------------------------------
 **ACMP 迟滞配置
---------------------------------------------------------------------------*/
#define ACMP_HYS_10				(0x01)			/*10mV迟滞*/
#define ACMP_HYS_20				(0x02)			/*20mV迟滞*/
#define ACMP_HYS_60				(0x03)			/*60mV迟滞*/

/*----------------------------------------------------------------------------
 **ACMP 修调模式
---------------------------------------------------------------------------*/
#define	ACMP_ADJ_POS_IN			(0x00)		//正端与负端连接, 接到P端
#define ACMP_ADJ_NAG_IN			(0x01)		//正端与负端连接, 接到N端
#define ACMP_ADJ_GND			(0x02)		//正端与负端连接, 接到GND


#define ACMP_OFFSET_CONFIG		(0x00)		//使用内部Config中的调节值
#define ACMP_OFFSET_ACMPDJ		(0xAA)		//使用ACMPADJ中的调节值
		
/*----------------------------------------------------------------------------
 **ACMP 锁定模式
---------------------------------------------------------------------------*/
#define ACMP_UNLOCK_TMR0		(0x01)
#define ACMP_UNLOCK_TMR1		(0x02)
#define ACMP_UNLOCK_DISABLE		(0x00)
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **ACMP 负端基准电压系数K
---------------------------------------------------------------------------*/
typedef enum Vref_K{
	Vref_K_2_20 =0x0, 			
	Vref_K_3_20 =0x1, 				
	Vref_K_4_20 =0x2, 				
	Vref_K_5_20 =0x3, 				
	Vref_K_6_20 =0x4,				
	Vref_K_7_20 =0x5,    			
	Vref_K_8_20 =0x6, 			
	Vref_K_9_20 =0x7, 			
	Vref_K_10_20 =0x8, 			
	Vref_K_11_20 =0x9,				
	Vref_K_12_20 =0xa,  			
	Vref_K_13_20 =0xb, 			
	Vref_K_14_20 =0xc, 			
	Vref_K_15_20 =0xd, 			
	Vref_K_16_20 =0xe,				
	Vref_K_17_20 =0xf,				
}Vref_K_T;

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/******************************************************************************
 ** \brief	 ACMP_ConfigPositive
 **			 设置比较器正端输入
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** 			 PositiveSource:  (1)ACMP_POSSEL_P0		
 **								  (2)ACMP_POSSEL_P1		
 **								  (3)ACMP_POSSEL_P2		
 **								  (4)ACMP_POSSEL_P4	
 **								  (5)ACMP_POSSEL_P5		
 **								  (6)ACMP_POSSEL_PGAANA		
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_ConfigPositive( uint8_t ACMPn, uint8_t PositiveSource);

/*****************************************************************************
 ** \brief	 ACMP_ConfigNegative
 **			 设置比较器负端输入
 ** \param [in] ACMPn: ACMP0、ACMP1
 **				NegativeSource:  (1)ACMP_NEGSEL_CN		:CnN			
 **								 (2)ACMP_NEGSEL_VREF_BG	: ACMP Vref 源选择BG
 **								 (3)ACMP_NEGSEL_VREF_VDD：ACMP Vref 源选择VDD
 **								 (4)ACMP_NEGSEL_BG		: 内部1.2V BG	
 **				Vref_k: 基准电压系数K (1)Vref_K_2_20......Vref_K_17_20  分压系数K	
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_ConfigNegative( uint8_t ACMPn, uint8_t NegativeSource,uint8_t Vref_k);


/*****************************************************************************
 ** \brief	 ACMP_EnableReverseOutput
 **			 开启反相输出
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void  ACMP_EnableReverseOutput( uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_DisableReverseOutput
 **			 关闭反向输出
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
******************************************************************************/
void  ACMP_DisableReverseOutput( uint8_t ACMPn);

/******************************************************************************
 ** \brief	 ACMP_EnableFilter
 **			 开启滤波
 ** \param [in] ACMPn: ACMP0、ACMP1
 **				FilterTime: (1)ACMP_NFCLK_1_TSYS ....
 ** \return  none
 ** \note   
******************************************************************************/
void  ACMP_EnableFilter( uint8_t ACMPn, uint8_t FilterTime);
/******************************************************************************
 ** \brief	 ACMP_DisableFilter
 **			 关闭滤波
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void  ACMP_DisableFilter( uint8_t ACMPn);


/******************************************************************************
 ** \brief	 ACMP_EnableInt
 **			 开启ACMP中断
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
 *****************************************************************************/
void ACMP_EnableInt(uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_DisableInt
 **			 关闭ACMP中断
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_DisableInt( uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_GetIntFlag
 **			 获取ACMP中断标志
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  0: 无比较器中断产生 ， 1：产生中断
 ** \note   
******************************************************************************/
uint8_t ACMP_GetIntFlag( uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_ClearIntFlag
 **			 清ACMP中断
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
******************************************************************************/
void ACMP_ClearIntFlag( uint8_t ACMPn);

/*****************************************************************************
 ** \brief	 ACMP_Start
 **			 开启ACMP
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
******************************************************************************/
void ACMP_Start( uint8_t ACMPn);

/*****************************************************************************
 ** \brief	 ACMP_Stop
 **			 关闭ACMP
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
**********************************************************************�*******/
void ACMP_Stop( uint8_t ACMPn);

/*****************************************************************************
 ** \brief	 ACMP_GetResult
 **			 获取比较器值
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  0/1
 ** \note   
 *****************************************************************************/
uint8_t ACMP_GetResult( uint8_t ACMPn);

/*****************************************************************************
 ** \brief	 ACMP_EnableHYS
 **			 配置比较器迟滞模式
 ** \param [in] ACMPn: ACMP0、ACMP1
 **				HYSSelect	:(1)ACMP_HYS_SEL_P	: 正迟滞
 **							 (2)ACMP_HYS_SEL_N	: 负迟滞
 **							 (3)ACMP_HYS_SEL_BOUTH
 **				HYSValue 	:(1)ACMP_HYS_10	：10mV
 **							 (2)ACMP_HYS_20	：20mV
 **							 (3)ACMP_HYS_60	：60mV
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_EnableHYS( uint8_t ACMPn ,uint8_t HYSSelect, uint8_t HYSValue);

/*****************************************************************************
 ** \brief	 ACMP_DisableHYS
 **			 关闭比较器迟滞模式
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_DisableHYS( uint8_t ACMPn);

/*****************************************************************************
 ** \brief	 ACMP_ConfigOffsetAdj
 **			 配置ACMP失调电压调节方式
 ** \param [in] ACMPn : ACMP0		
 **				OffsetAdjMode:	(1)ACMP_OFFSET_CONFIG
 **								(2)ACMP_OFFSET_ACMPDJ
 **				AdjVlue : 失调电压调节值：0x00~0x1f
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_ConfigOffsetAdj(uint8_t ACMPn,uint8_t OffsetAdjMode, uint8_t AdjVlue);


/*****************************************************************************
 ** \brief	 ACMP_GetOffsetAdjValue
 **			 获取ACMP失调电压调节值
 ** \param [in] ACMPn : ACMP0
 **				ACMPMode:  (1)ACMP_ADJ_POS_IN		//正端与负端连接, 接到P端
 **						   (2)ACMP_ADJ_NAG_IN		//正端与负端连接, 接到N端
 **						   (3)ACMP_ADJ_GND			//正端与负端连接，接到GND
 **				InputPort: (1)ACMP_POSSEL_P0 .... ACMP_POSSEL_P3   //正端输入选择
 **						  （2）ACMP_NEGSEL_CN 		//负端的输入选择
 ** \return  5位失调电压修调值
 ** \note   
 *****************************************************************************/
uint8_t  ACMP_GetOffsetAdjValue(uint8_t ACMPn, uint8_t ACMPMode, uint8_t InputPort);


/*****************************************************************************
 ** \brief	 ACMP_EnableLock
 **			 使能锁定
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_EnableLock(uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_DisableLock
 **			 关闭锁定
 ** \param [in] ACMPn: ACMP0、ACMP1
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_DisableLock(uint8_t ACMPn);
/*****************************************************************************
 ** \brief	 ACMP_ConfigUnlock
 **			 配置解锁
 ** \param [in] ACMPn: ACMP0、ACMP1
 **			    Mode ：(1)ACMP_UNLOCK_TMR0
 **					   (2)ACMP_UNLOCK_TMR1
 **					   (3)ACMP_UNLOCK_DISABLE
 ** \return  none
 ** \note   
*****************************************************************************/
void ACMP_ConfigUnlock(uint8_t ACMPn,uint8_t Mode);

#endif /* __ACMP_H__ */







