/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file adc.c
**
**  
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "adc.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/

/*****************************************************************************
 ** \brief	 ADC_Start			
 ** \param [in] none       
 ** \return  none
*****************************************************************************/
void  ADC_Start(void)
{
	ADCON1 |= ADC_ADCON1_ADEN_Msk;
}
/*****************************************************************************
 ** \brief	 ADC_Stop			
 ** \param [in] none         
 ** \return  none
*****************************************************************************/
void  ADC_Stop(void)
{
	ADCON1 &= ~(ADC_ADCON1_ADEN_Msk);
}

/*****************************************************************************
 ** \brief	 ADC_ConfigRunMode
 **			  ADCģʽ
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 **          	ADCResultTpye: (1)ADC_RESULT_LEFT    
 **							   (2)ADC_RESULT_RIGHT   Ҷ
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_ConfigRunMode( uint8_t ADCClkDiv, uint8_t ADCResultTpye)
{
	uint8_t temp;
	temp = ADCON0;
	temp &= ~(ADC_ADCON0_ADFM_Msk);
	temp |= ADCResultTpye;
	ADCON0 = temp;
	
	temp = ADCON3;
	temp &= ~(ADC_ADCON3_ADCKS4_Msk);
	if(ADCClkDiv & 0x10)
		temp |= (ADC_ADCON3_ADCKS4_Msk);	
	ADCON3 = temp;
	
	temp = ADCON1;
	temp &= ~(ADC_ADCON1_ADCKS_Msk);		
	temp |= (0x7 & ADCClkDiv)<< ADC_ADCON1_ADCKS_Pos;
	ADCON1 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_ConfigSampleTime
 **			  ADCĲʱ
 ** \param [in] ADCSample: (1)ADC_SP_TIME_4		
 **						   (2)ADC_SP_TIME_8
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigSampleTime( uint8_t ADCSample)
{
	uint8_t temp;
	temp = ADCON3;
	temp &= ~(ADC_ADCON3_SPTIME_Msk);
	temp |=  ADCSample;
	ADCON3 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_ConfigConvertTime
 **			  ADCת
 ** \param [in] ConvertTime:  (1)ADC_CT_TIME_1		1ת	
 **						      (2)ADC_CT_TIME_4		4ת
 **						      (3)ADC_CT_TIME_8		8ת
 **						      (4)ADC_CT_TIME_16		16ת
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigConvertTime( uint8_t ConvertTime)
{
	uint8_t temp;
	temp = ADCON3;
	temp &= ~(ADC_ADCON3_ADCTIMES_Msk);
	temp |=  (ConvertTime << ADC_ADCON3_ADCTIMES_Pos);
	ADCON3 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_EnableHardwareTrig
 **			ʹӲADC
 ** \param [in] none
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_EnableHardwareTrig(void)
{
	ADCON2 |= (ADC_ADCON2_ADCEX_Msk);
}
/*****************************************************************************
 ** \brief	 ADC_DisableHardwareTrig
 **			 رӲADC
 ** \param [in] none
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_DisableHardwareTrig(void)
{
	ADCON2 &= ~(ADC_ADCON2_ADCEX_Msk);
}
/*****************************************************************************
 ** \brief	 ADC_ConfigHardwareTrig
 **			 Ӳģʽ
 ** \param [in] ADCTGSource: ADC_TG_PWM0ADC_TG_PWM2ADC_TG_PWM4ADC_TG_ADET
 **				TGMode(1)ADC_TG_FALLING
 **						(2)ADC_TG_RISING
 **						(3)ADC_TG_PWM_PE
 **						(4)ADC_TG_PWM_ZE
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_ConfigHardwareTrig(uint8_t ADCTGSource, uint8_t TGMode)
{
	uint8_t temp;
	temp = ADCON2;
	temp &= ~(ADC_ADCON2_ADTGS_Msk | ADC_ADCON2_ADEGS_Msk);
	temp |= (ADCTGSource<< ADC_ADCON2_ADTGS_Pos) | (TGMode<<ADC_ADCON2_ADEGS_Pos);
	ADCON2 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_EnableChannel
 **			 ʹADCתͨ
 ** \param [in]  ADCChannel: ADC_CH_0 ..... ADC_CH_31
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_EnableChannel(uint8_t ADCChannel)
{	
	uint8_t temp;
	temp = ADCON0;
	temp &= ~(ADC_ADCON0_ADCHS4_Msk);
	if(ADCChannel & 0x10)
		temp |= (ADC_ADCON0_ADCHS4_Msk);
  ADCON0 = temp;	
	
	temp = ADCON1;
	temp &= ~(ADC_ADCON1_ADCHS_Msk);
	temp |= 0xf & ADCChannel;
	ADCON1 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_ConfigAN31
 **			 AN31ͨ
 ** \param [in]	An31Channel:1ADC_CH_31_BGR...ADC_CH_31_VDD
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigAN31(uint8_t An31Channel)
{
	uint8_t temp;
	temp = ADCON0;
	temp &= ~(ADC_ADCON0_AN31CH_Msk);
	temp |= (An31Channel<<ADC_ADCON0_AN31CH_Pos);
	ADCON0 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_SetTrigDelayTime
 **			 Ӳģʽʱʱ
 ** \param [in]  TrigTime: 0~1023
 ** \return  none
 ** \note 	(TrigTime + 4)) *Tsys
*****************************************************************************/
void  ADC_SetTrigDelayTime(uint16_t TrigTime)
{
	uint8_t temp;
	ADDLYL =  TrigTime;
	temp = ADCMPC;
	temp &= ~(ADC_ADCMPC_ADDLY_Msk);
	temp |= ADC_ADCMPC_ADDLY_Msk & (TrigTime >> 8);
	ADCMPC = temp;
}

/*****************************************************************************
 ** \brief	 ADC_ConfigCompareValue
 **			 ADCȽֵ
 ** \param [in]  ADCCompareValue: ADCMPH,ADCMPL
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_ConfigCompareValue(uint16_t ADCCompareValue)
{
	ADCMPL = ADCCompareValue & 0xF;
	ADCMPH = ADCCompareValue>>4; 
}
/*****************************************************************************
 ** \brief	 ADC_ConfigCompareOut
 **			 ADCȽ
 ** \param [in] Config : (1)ADC_CMP_NEG	תСڱȽֵADCMPO =1;
 **						 (2)ADC_CMP_POS תڻڱȽֵADCMPO =1;
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_ConfigCompareOut(uint8_t Config)
{
	uint8_t temp;
	temp = ADCMPC;
	temp &= ~(ADC_ADCMPC_ADCMPPS_Msk);
	temp |= Config;
	ADCMPC = temp;
}
/*****************************************************************************
 ** \brief	 ADC_GetCmpResult
 **			 ȡADCȽϽ
 ** \param [in]  none
 ** \return   0/1
 ** \note 
*****************************************************************************/
uint8_t  ADC_GetCmpResult(void)
{
	return ((ADCMPC & ADC_ADCMPC_ADCMPO_Msk) ? 1:0);
}

/*****************************************************************************
 ** \brief	 ADC_GetADCResult
 **			 ȡADCת
 ** \param [in]  none
 ** \return  12bits ADCֵ
 ** \note 
*****************************************************************************/
uint16_t  ADC_GetADCResult(void)
{
	if(!(ADCON0 & ADC_ADCON0_ADFM_Msk))		/**/
	{
		return (0xfff & (((ADRESH<<4) | (ADRESL>>4))));
	}
	return (0xfff & ((ADRESH<<8)| ADRESL));	
}

/*****************************************************************************
 ** \brief	 ADC_EnableInt
 **			 ADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_EnableInt(void)
{
	EIE2 |= IRQ_EIE2_ADCIE_Msk;
}
/*****************************************************************************
 ** \brief	 ADC_DisableInt
 **			 رADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_DisableInt(void)
{
	EIE2 &= ~(IRQ_EIE2_ADCIE_Msk);
}
/*****************************************************************************
 ** \brief	 ADC_GetIntFlag
 **			 ȡADCתжϱ־λ
 ** \param [in]  none
 ** \return  0жϣ1ж
 ** \note 
*****************************************************************************/
uint8_t ADC_GetIntFlag(void)
{
	return ((EIF2 & IRQ_EIF2_ADCIF_Msk) ? 1:0);
}
/*****************************************************************************
 ** \brief	 ADC_ClearIntFlag
 **			 ADCתжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_ClearIntFlag(void)
{
	EIF2 = 0xFF &(~(IRQ_EIF2_ADCIF_Msk));
}


