/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province,
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file i2c.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __I2C_H__
#define __I2C_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f231x.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/


/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	I2C_ConfigCLK
 **			I2Cʱ
 ** \param [in] I2CMtp: 0x0~0x7f
 ** \return  none
 ** \note	(1)I2CMtp = 0 ,SCL = 3*10*Tsys
 **			(2)I2CMtp != 0, SCL = 2*(1+I2CMtp)*10*Tsys
*****************************************************************************/
void I2C_ConfigCLK(uint8_t I2CMtp);

/*****************************************************************************
 ** \brief	I2C_EnableMasterMode
 **			ʹģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void I2C_EnableMasterMode(void);
/*****************************************************************************
 ** \brief	I2C_DisableMasterMode
 **			رģʽ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void I2C_DisableMasterMode(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterSendAddrFlag
 **			ȡģʽѰַӦ־
 ** \param [in] none
 ** \return 0: ӻӦ  1ӻӦ
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetMasterSendAddrFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterSendDataFlag
 **			ȡģӦ־
 ** \param [in] none
 ** \return 0: ӻӦ  1ӻӦ
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetMasterSendDataFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterBusArbitrationFlag
 **			ȡģٲñ־
 ** \param [in] none
 ** \return 0:   1:ʧ߿Ȩ
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetMasterBusArbitrationFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterErrorFlag
 **			ȡģʽ־
 ** \param [in] none
 ** \return 0: ޴ 1д
 ** \note	־(1)ѰַӻӦ (2)ݴӻӦ
 **							  (3)I2Cٲóͻ
*****************************************************************************/
uint8_t I2C_GetMasterErrorFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterBusyFlag
 **			ȡģBusy״̬־
 ** \param [in] none
 ** \return  1ڷ
 ** \note	
*****************************************************************************/
uint8_t I2C_GetMasterBusyFlag(void);

/*****************************************************************************
 ** \brief	I2C_GetMasterIdleFlag
 **			ȡģʽ״̬־
 ** \param [in] none
 ** \return 0:  1
 ** \note	
*****************************************************************************/
uint8_t I2C_GetMasterIdleFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetBusBusyFlag
 **			ȡæ״̬־
 ** \param [in] none
 ** \return 0:  1æ
 ** \note	
*****************************************************************************/
uint8_t I2C_GetBusBusyFlag(void);

/*****************************************************************************
 ** \brief	I2C_EnableInt
 **			ж
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void I2C_EnableInt(void);
/*****************************************************************************
 ** \brief	I2C_DisableInt
 **			رж
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void I2C_DisableInt(void);
/*****************************************************************************
 ** \brief	I2C_GetMasterIntFlag
 **			ȡģʽµжϱ־λ
 ** \param [in] none
 ** \return  0:ж 1ж
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetMasterIntFlag(void);
/*****************************************************************************
 ** \brief	I2C_ClearMasterIntFlag
 **			ģʽµжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void I2C_ClearMasterIntFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetSReceiveCompFlag
**			I2Cģʽݱ־
 ** \param [in] none
** \return  1ӻյ
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetSReceiveCompFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetSlavePrepareSendFlag
**			I2Cģʽ׼ݱ־
 ** \param [in] none
** \return  1ӻԷ
 ** \note	 
*****************************************************************************/
uint8_t I2C_GetSlavePrepareSendFlag(void);
/*****************************************************************************
 ** \brief	I2C_SlaveWriteBuffer
 **			I2Cģʽд
 ** \param [in] data
 ** \return  none
 ** \note	 
*****************************************************************************/
void  I2C_SlaveWriteBuffer(uint8_t Data);
/*****************************************************************************
 ** \brief	I2C_SlaveAddressSet
 **			ôģʽĵַ
 ** \param [in] none
 ** \return none
 ** \note	 7λַûãslaveַBit6~bit0
*****************************************************************************/
void I2C_SlaveAddressSet(uint8_t SlaveAddress);
/*****************************************************************************
 ** \brief	I2C_EnableSlaveMode
 **			ʹI2Cģʽ
 ** \param [in] none
 ** \return none
 ** \note	 
*****************************************************************************/
void I2C_EnableSlaveMode(void);
/*****************************************************************************
 ** \brief	 I2C_GetIntFlag
 **			 ȡI2Cжϱ־λ
 ** \param [in]  none
 ** \return  0жϣ1ж
 ** \note 
*****************************************************************************/
uint8_t I2C_GetIntFlag(void);
/*****************************************************************************
 ** \brief	 SPI_ClearIntFlag
 **			 I2Cжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void I2C_ClearIntFlag(void);










#endif /* __I2C_H__ */
