/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province,
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file extint.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __EXTINT_H__
#define __EXTINT_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f231x.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **ⲿжͨ
/*---------------------------------------------------------------------------*/
#define		EXTINT0				(0x00)			/*EXTINT channel 0 number*/
#define		EXTINT1				(0x01)			/*EXTINT channel 1 number*/
/*----------------------------------------------------------------------------
 **ⲿжϴģʽ
/*---------------------------------------------------------------------------*/
#define  EXTINT_TRIG_LOW		(0x00)			/*͵ƽģʽ*/
#define  EXTINT_TRIG_FALLING  	(0x01)			/*½شģʽ*/

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/********************************************************************************
 ** \brief	 EXTINT_ConfigInt
 **			 ⲿжϹ
 ** \param [in]  Extintn : (1)EXTINT0     :ⲿж0
 **            				(2)EXTINT1     :ⲿж1
 **			     IntMode  (1)EXTINT_TRIG_LOW	:͵ƽģʽ
 **							(2)EXTINT_TRIG_FALLING :½شģʽ
 ** \return  none
 ** \note  
 ******************************************************************************/
void EXTINT_ConfigInt(uint8_t Extintn, uint8_t IntMode);
/********************************************************************************
 ** \brief	 EXTINT_EnableInt
 **			 ʹⲿжϹ
 ** \param [in]  Extintn : (1)EXTINT0     :ⲿж0
 **            				(2)EXTINT1     :ⲿж1
 ** \return  none
 ** \note   
 ******************************************************************************/
void EXTINT_EnableInt(uint8_t Extintn);

/********************************************************************************
 ** \brief	 EXTINT_DisableInt
 **			 رⲿжϹ
 ** \param [in]  Extintn : (1)EXTINT0     :ⲿж0
 **            				(2)EXTINT1     :ⲿж1 
 ** \return  none
 ** \note   
 ******************************************************************************/
void EXTINT_DisableInt(uint8_t Extintn);

/********************************************************************************
 ** \brief	 EXTINT_GetIntFlag
 **			 ȡжϱ־
 ** \param [in]  Extintn : (1)EXTINT0     :ⲿж0
 **            				(2)EXTINT1     :ⲿж1	 
 ** \return  0:ж1ж
 ** \note  
 ******************************************************************************/
uint8_t  EXTINT_GetIntFlag(uint8_t Extintn);
 
 /********************************************************************************
 ** \brief	 EXTINT_ClearIntFlag
 **			 жϱ־
 ** \param [in]  Extintn : (1)EXTINT0     :ⲿж0
 **            				(2)EXTINT1     :ⲿж1		 
 ** \return  none
 ** \note   
 ******************************************************************************/
void EXTINT_ClearIntFlag(uint8_t Extintn);


#endif /* __EXTINT_H__ */






