/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file uart.c
**
**  
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "uart.h"
/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/
/******************************************************************************
 ** \brief UART_ConfigRunMode
 **			UARTģʽ
 ** \param [in] UARTn: (1)UART0
 **									(2)UART1
 **					UARTMode:		
 **									(0)UART_MOD_ASY_8BIT: 8λ첽ģʽ
 **									(1)UART_MOD_ASY_9BIT9λ첽ģʽ
 **					UARTBaudTimer:  (1)UART_BAUD_BRT : BRT
 **									(1)UART_BAUD_TMR1 :	Timer1
 ** \return none
******************************************************************************/
void UART_ConfigRunMode(uint8_t UARTn, uint8_t UARTMode, uint8_t UARTBaudTimer)
{	
	if(UARTn == UART0)
	{
		SCON0 &= ~(UART_SCON0_U0SMn_Msk);
		SCON0 |= (UARTMode<< UART_SCON0_U0SMn_Pos);
		if(UARTBaudTimer == UART_BAUD_BRT)
			CKCON &= ~(SYS_CKCON_U0M_Msk);
		else
			CKCON |= SYS_CKCON_U0M_Msk;
	}
	if(UARTn == UART1)
	{
		SCON1 &= ~(UART_SCON1_U1SMn_Msk);
		SCON1 |= (UARTMode<< UART_SCON1_U1SMn_Pos);		
		if(UARTBaudTimer == UART_BAUD_BRT)
			CKCON &= ~(SYS_CKCON_U1M_Msk);
		else
			CKCON |= SYS_CKCON_U1M_Msk;					
	}	
	
}

/******************************************************************************
 ** \brief UART_ConfigBaudRate
 **			UART
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 **					BaudRateValue:  ֵ
 ** \return Timer1: 8λԶװģʽTHxֵ
 **			BRT: 16 λʱģʽ BRTDH:BRTDL ֵ
******************************************************************************/
uint32_t  SystemClock1=48000000;
uint16_t UART_ConfigBaudRate(uint8_t UARTn, uint32_t  BaudRateValue)
{
#ifdef  USE_FORMULA
	float  BaudRateTemp =0;	
	float  BaudRate = 0.55;
	uint16_t PeriodValue =0;
	uint8_t  T_Flag =0;
	uint8_t  BaudRateTimer =0;
		
	if(UARTn == UART0)
	{	
		BaudRateTimer = (CKCON & SYS_CKCON_U0M_Msk)>>SYS_CKCON_U0M_Pos;
	}
	if(UARTn == UART1)
	{	
		BaudRateTimer = (CKCON & SYS_CKCON_U1M_Msk)>>SYS_CKCON_U1M_Pos;
	}
	
	switch(BaudRateTimer)
	{
		case UART_BAUD_TMR1:	// Timer1 16λʱ\
			T_Flag = ((CKCON & SYS_CKCON_T1M_Msk)? 1:3);		/*ȡT1Mλ*/
			BaudRateTemp = 256 - SystemClock1*2/ 32 / 4 /T_Flag/BaudRateValue;					
			break;		
		case UART_BAUD_BRT:	// BRT
			BaudRateTemp = (SystemClock1 / 16/ BaudRateValue)-1;	
			break;				
		default:
			break;
	}				
	if((BaudRateTemp - (uint16_t) BaudRateTemp) > BaudRate)
	{
		PeriodValue = (uint16_t)BaudRateTemp + 1;
	}
	else
	{
		PeriodValue = BaudRateTemp;
	}	
	return (PeriodValue);
#else	
	UARTn =0;
	BaudRateValue =0;
	return 0;
#endif 
}

/******************************************************************************
 ** \brief UART_EnableReceive
 **			ģʽ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_EnableReceive(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		SCON0 |= UART_SCON0_U0REN_Msk;
	}
	if(UARTn == UART1)
	{
		SCON1 |= UART_SCON1_U1REN_Msk;
	}
}
/******************************************************************************
 ** \brief UART_DisableReceive
 **			رսģʽ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_DisableReceive(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		SCON0 &= ~(UART_SCON0_U0REN_Msk);
	}
	if(UARTn == UART1)
	{
		SCON1 &= ~(UART_SCON1_U1REN_Msk);
	}	
}

/******************************************************************************
 ** \brief UART_EnableMult
 **			ͨѶģʽ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_EnableMult(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		SCON0 |= UART_SCON0_U0SM2_Msk;
	}
	if(UARTn == UART1)
	{
		SCON1 |= UART_SCON1_U1SM2_Msk;
	}	
}

/******************************************************************************
 ** \brief UART_DisableReceive
 **			رնͨѶģʽ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_DisableMult(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		SCON0 &= ~(UART_SCON0_U0SM2_Msk);
	}
	if(UARTn == UART1)
	{
		SCON1 &= ~(UART_SCON1_U1SM2_Msk);
	}	
}

/******************************************************************************
 ** \brief UART_EnableInt
 **			ж
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_EnableInt(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		ES0 =1;
	}
	if(UARTn == UART1)
	{
		ES1 =1;
	}
}
/******************************************************************************
 ** \brief UART_DisableInt
 **			رж
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_DisableInt(uint8_t UARTn)
{
	if(UARTn == UART0)
	{
		ES0 =0;
	}
	if(UARTn == UART1)
	{
		ES1 =0;
	}
}
/******************************************************************************
 ** \brief UART_GetReceiveIntFlag
 **			ȡжϱ־λ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 0жϣ1ж
******************************************************************************/
uint8_t  UART_GetReceiveIntFlag(uint8_t UARTn)
{
	uint8_t uartFlag;
	uartFlag =0;
	if(UART0 ==  UARTn)
	{
		uartFlag =((SCON0 & UART_SCON0_RI0_Msk)? 1:0);
	}
	if(UART1 == UARTn)
	{
		uartFlag =((SCON1 & UART_SCON1_RI1_Msk)? 1:0);
	}
	
	return uartFlag ;
}

/******************************************************************************
 ** \brief UART_ClearReceiveIntFlag
 **			жϱ־λ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_ClearReceiveIntFlag(uint8_t UARTn)
{
	uint8_t temp;	
	if(UART0 ==  UARTn)
	{
		temp  = SCON0;
		temp &= ~(UART_SCON0_RI0_Msk);
		SCON0 = temp | UART_SCON0_TI0_Msk;
	}
	if(UART1 == UARTn)
	{
		temp  = SCON1;
		temp &= ~(UART_SCON1_RI1_Msk);
		SCON1 = temp | UART_SCON1_TI1_Msk;		
	}
}

/******************************************************************************
 ** \brief UART_GetSendIntFlag
 **			ȡжϱ־λ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 0жϣ1ж
******************************************************************************/
uint8_t  UART_GetSendIntFlag(uint8_t UARTn)
{
	uint8_t uartFlag;
	uartFlag =0;
	if(UART0 ==  UARTn)
	{
		return((SCON0 & UART_SCON0_TI0_Msk)? 1:0);
	}
	if(UART1 ==  UARTn)
	{
		return((SCON1 & UART_SCON1_TI1_Msk)? 1:0);
	}	
	return uartFlag;
}

/******************************************************************************
 ** \brief UART_ClearSendIntFlag
 **			жϱ־λ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
void UART_ClearSendIntFlag(uint8_t UARTn)
{
	uint8_t temp;
	
	if(UART0 ==  UARTn)
	{
		temp  = SCON0;
		temp &= ~(UART_SCON0_TI0_Msk);
		SCON0 = temp | UART_SCON0_RI0_Msk;		
	}
	if(UART1 == UARTn)
	{
		temp  = SCON1;
		temp &= ~(UART_SCON1_TI1_Msk) ;
		SCON1 = temp | UART_SCON1_RI1_Msk;		
	}		
}

/******************************************************************************
 ** \brief UART_GetBuff
 **			ȡBuffֵ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 
******************************************************************************/
uint8_t UART_GetBuff(uint8_t UARTn)
{
	uint8_t  uartbuf;
	uartbuf =0;
	if(UART0 == UARTn)
	{
		uartbuf = SBUF0;
	}
	if(UART1 ==  UARTn)
	{
		uartbuf = SBUF1;
	}	
	return uartbuf;
}

/******************************************************************************
 ** \brief UART_SendBuff
 **			ݵBuff
 ** \param [in] UARTn: (1) UART0
 **						         (2) UART1
 **				   UARTSendValue : ͵8λֵ
 ** \return 
******************************************************************************/
void UART_SendBuff(uint8_t UARTn, uint8_t UARTSendValue)
{
	if(UART0 == UARTn)
	{
		SBUF0 = UARTSendValue;
	}
	if(UART1 == UARTn)
	{
		SBUF1 = UARTSendValue;
	}		
}

/******************************************************************************
 ** \brief UART_SendNinthBit
 **			ݵĵھλ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 **				   UARTSendValue : ͵ĵھλֵ
 ** \return 
******************************************************************************/
void UART_SendNinthBit(uint8_t UARTn, uint8_t UARTSendValue)
{
	if(UART0 == UARTn)
	{
		if(0 == UARTSendValue)
		{
			SCON0 &= ~(UART_SCON0_U0TB8_Msk);
		}
		else
		{
			SCON0 |= UART_SCON0_U0TB8_Msk;	
		}
	}
	if(UART1 == UARTn)
	{
		if(0 == UARTSendValue)
		{
			SCON1 &= ~(UART_SCON1_U1TB8_Msk);
		}
		else 
		{
			SCON1 |= UART_SCON1_U1TB8_Msk;	
		}
	}		
	
}
/******************************************************************************
 ** \brief UART_GetNinthBit
 **			ȡݵĵھλ
 ** \param [in]    UARTn: (1) UART0
 **						  (2) UART1
 ** \return 0/1
******************************************************************************/
uint8_t UART_GetNinthBit(uint8_t UARTn)
{
	uint8_t ninthbit;
	ninthbit=0;
	if(UARTn == UART0)
	{
		ninthbit= ((SCON0 & UART_SCON0_U0RB8_Msk)? 1:0);
	}
	if(UARTn == UART1)
	{
		ninthbit= ((SCON1 & UART_SCON1_U1RB8_Msk)? 1:0);
	}	
	return ninthbit;
}

/******************************************************************************
 ** \brief UART_EnableBRT
 **		   ʹBRTʱģ
 ** \param [in]none
 ** \return none
******************************************************************************/
void UART_EnableBRT(void)
{
	BRTDH |= 0x80;	
}
/******************************************************************************
 ** \brief UART_DisableBRT
 **		   رBRTʱģ
 ** \param [in]none
 ** \return none
******************************************************************************/
void UART_DisableBRT(void)
{
	BRTDH &= 0x7F;	
}
/******************************************************************************
 ** \brief UART_ConfigBRTPeriod
 **		   BRTģʱ
 ** \param [in] BRTPeriod: 16bit
 ** \return none
******************************************************************************/
void UART_ConfigBRTPeriod( uint16_t BRTPeriod)
{	
	uint8_t BRTemp=0;
		
	BRTDL = BRTPeriod;
	BRTemp = BRTDH & 0x80;
	BRTDH = BRTemp | BRTPeriod>>8;	
}








