/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file led.c
**
**  
**
**	History:
**
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "led.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/
/*****************************************************************************
 ** \brief	 LED_EnableMatrixMode
 **			 ʹLEDģʽ
 ** \param [in] none		
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableMatrixMode(void)
{
	LEDMODE = 0x55;
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixMode
 **			 LEDģʽ
 ** \param [in] Duty:	(1) LED_DUTY_4
 **						(2)	LED_DUTY_5
 **						(3)	LED_DUTY_6
 **						(4)	LED_DUTY_8	  
 **				Common:	(1) LED_COM_CATHODE			ģʽ
 **						(2)	LED_COM_ANODE   		ģʽ			
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixMode(uint8_t Duty, uint8_t Common)
{
	LEDCON &= 0x80;
	LEDCON |=  LED_LEDCON_FIXCLKEN_Msk | (Duty<<LED_LEDCON_DUTY_Pos) | (Common<<LED_LEDCON_CCCA_Pos);	
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixClk
 **			 LEDģʽʱ
 ** \param [in] ClkDiv: LED_CLK_32Tfix,LED_CLK_64Tfix,LED_CLK_128Tfix,LED_CLK_256Tfix
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixClk(uint16_t ClkDiv)
{
	LEDCKS &= ~LED_LEDCKS_CLKn_Msk;
	LEDCKS =  (uint8_t)ClkDiv;
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixDeadTime
 **			 LEDģʽʱ
 ** \param [in] DTim:  LED_MatDTim_8Tfix,LED_MatDTim_16Tfix,
 **                       LED_MatDTim_32Tfix,LED_MatDTim_64Tfix
 ** \return  none
 ** \note Tfix=8MHz  
******************************************************************************/
void LED_ConfigMatrixDeadTime(uint16_t DTim)
{
	LEDCKS &= ~LED_LEDCKS_DTSELn_Msk;
	LEDCKS =  (uint8_t)DTim<<LED_LEDCKS_DTSELn_Pos;
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixComTime
 **			 þģʽCOMЧʱ
 ** \param [in] Time  0x01~0xff
 ** \return  none
 ** \note   ֹó0x00
******************************************************************************/
void LED_ConfigMatrixComTime(uint8_t Time)
{
	LEDCOMTIME = Time;
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixComTime
 **			 þģʽSEGЧʱ
 ** \param [in] Time  0x01~0xff
 ** \return  none
 ** \note   ֹó0x00
******************************************************************************/
void LED_ConfigMatrixSegTime(uint8_t Time)
{
	LEDSEGTIME = Time;
}
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixSegCurrent
 **			 þģʽSEG
 ** \param [in] Time  LED_DRVC_0mA~LED_DRVC_50mA
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixSegCurrent(uint8_t LSCurrent)
{
	LEDDRV = LSCurrent;
}
/*****************************************************************************
 ** \brief	 LED_StartMatrix
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StartMatrix(void)
{
	LEDCON |= LED_LEDCON_EN_Msk;
}
/*****************************************************************************
 ** \brief	 LED_StopMatrix
 **			 ֹͣLED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StopMatrix(void)
{
	LEDCON &= ~(LED_LEDCON_EN_Msk);
}
	
/*****************************************************************************
 ** \brief	 LED_EnableLatticeMode
 **			 ʹLEDģʽ
 ** \param [in] none		
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableLatticeMode(void)
{
	LEDMODE = 0xAA;
}
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeMode
 **			 LEDģʽ
 ** \param [in] Mode:	(1) LED_LATTICE_4X4			4*4
 **						(2)	LED_LATTICE_5X5			5*5
 **						(3)	LED_LATTICE_6X6			6*6
 **						(4)	LED_LATTICE_6X7			6*7
 **						(5)	LED_LATTICE_7X7			7*7
 **						(6)	LED_LATTICE_7X8			7*8
 **						(7)	LED_LATTICE_8X8 		8*8
 **				Scan:	(1) LED_SCAN_INTERRUPT		жɨģʽ
 **						(2)	LED_SCAN_LOOP   		ѭɨģʽ			
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticeMode(uint8_t Mode, uint8_t Scan)
{
	LEDCON1 &=0x80;
	LEDCON1 |= LED_LEDCON1_FIXCLKEN_Msk | (Mode<<LED_LEDCON1_DUTY_Pos)|(Scan<<LED_LEDCON1_SMODE_Pos);
}
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeClk
 **			 LEDģʽʱӷƵ
 ** \param [in] ClkDiv: LED_CLK_32Tfix,LED_CLK_64Tfix,LED_CLK_128Tfix,LED_CLK_256Tfix
 ** \return  none
 ** \note Tfix=8MHz  
******************************************************************************/
void LED_ConfigLatticeClk(uint16_t ClkDiv)
{
	LEDCKS &= ~LED_LEDCKS_CLKn_Msk;
	LEDCKS =  (uint8_t)ClkDiv;
}
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeDeadTime
 **			 LEDģʽʱ
 ** \param [in] DTim:  LED_LatDTim_12Tfix,LED_LatDTim_24Tfix,
 **                       LED_LatDTim_48Tfix,LED_LatDTim_96Tfix
 ** \return  none
 ** \note Tfix=8MHz  
******************************************************************************/
void LED_ConfigLatticeDeadTime(uint16_t DTim)
{
	LEDCKS &= ~LED_LEDCKS_DTSELn_Msk;
	LEDCKS =  (uint8_t)DTim<<LED_LEDCKS_DTSELn_Pos;
}
/*****************************************************************************
 ** \brief	 LED_ConfigLatticePeriod1
 **			 LEDģʽ1
 ** \param [in] Period: 0x00~0xff
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticePeriod1(uint8_t Period)
{
	SCAN1W =  Period;
}
/*****************************************************************************
 ** \brief	 LED_ConfigLatticePeriod2
 **			 LEDģʽ2
 ** \param [in] Period: 0x00~0xff
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticePeriod2(uint8_t Period)
{
	SCAN2W =  Period;			
}

/*****************************************************************************
 ** \brief	 LED_StartLattice
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StartLattice(void)
{
	LEDCON1 |= LED_LEDCON1_SSTART_Msk;
}
/*****************************************************************************
 ** \brief	 LED_StopLattice
 **			 ֹͣLED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StopLattice(void)
{
	LEDCON1 &= ~(LED_LEDCON1_SSTART_Msk);
}

/*****************************************************************************
 ** \brief	 LED_RestartLattice
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_RestartLattice(void)
{
	LEDCON1 &= ~(LED_LEDCON1_SSTART_Msk);
	LEDCON1 |= LED_LEDCON1_SSTART_Msk;	
}

/*****************************************************************************
 ** \brief	 LED_EnableInt
 **			 ʹLEDģʽж
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableInt(void)
{
	LEDSTATUS |= LED_LEDSTATUS_LEDIE_Msk;
}
/*****************************************************************************
 ** \brief	 LED_DisableInt
 **			 رLEDģʽж
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_DisableInt(void)
{
	LEDSTATUS &= ~(LED_LEDSTATUS_LEDIE_Msk);
}
/*****************************************************************************
 ** \brief	 LED_GetIntFlag
 **			 ȡLEDģʽжϱ־
 ** \param [in] none
 ** \return  0:ж  1:ж
 ** \note   
******************************************************************************/
uint8_t LED_GetIntFlag(void)
{
	return((LEDSTATUS & LED_LEDSTATUS_LEDIF_Msk) ? 1:0);
}
/*****************************************************************************
 ** \brief	 LED_ClearIntFlag
 **			 LEDģʽжϱ־
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ClearIntFlag(void)
{
	LEDSTATUS &= ~(LED_LEDSTATUS_LEDIF_Msk);
}



