/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file gpio.c
**
** 
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "gpio.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

 /********************************************************************************
 ** \brief	 GPIO_EINTx_Enable
 **			 ʹչж
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03			 
 ** \return  none
 ** \note   
 ******************************************************************************/
void GPIO_EINTx_Enable(EINTx_CH_t EINTCH)
{
	EI0IE |= 1 << EINTCH;
}
/********************************************************************************
 ** \brief	 GPIO_EINTx_Disable
 **			 رչж
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03		 
 ** \return  none
 ** \note   
 ******************************************************************************/
void GPIO_EINTx_Disable(EINTx_CH_t EINTCH)
{
	EI0IE &= ~(1 << EINTCH);
}

 /******************************************************************************
 ** \brief	 GPIO_EINTx_GetFlag
 **			 ȡжϱ־
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03	 
 ** \return  0жϲ
 **			 1жϲ
 ** \note  
 ******************************************************************************/
uint8_t  GPIO_EINTx_GetFlag(EINTx_CH_t EINTCH)
{
	uint8_t PinIntFlag = 0;
	if(EI0IF & (1 << EINTCH)) 
		return 1;
	else
		return 0;
}
 /********************************************************************************
 ** \brief	 GPIO_EINTx_ClearFlag
 **			жϱ־λ
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03	  		 
 ** \return  none
 ** \note  
 ******************************************************************************/
void GPIO_EINTx_ClearFlag(EINTx_CH_t EINTCH)
{
	EI0IF &= ~(1<< EINTCH);
}

 /********************************************************************************
 ** \brief	 GPIO_ClearIntFlag
 **			жϱ־λ
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03
 ** \param [in] TrigM: GPIO_INT_NONE GPIO_INT_RISING
 **                    GPIO_INT_FALLING GPIO_INT_BOTH_EDGE	  		 
 ** \return  none
 ** \note  
 ******************************************************************************/
void GPIO_EINTx_Trig(EINTx_CH_t EINTCH, uint8_t TrigM)
{
  uint8_t Temp=0;
	
	Temp = EI0CFGL;
	Temp &= ~(3<<(EINTCH*2));
	Temp |= TrigM<<(EINTCH*2);
	EI0CFGL = Temp;
}


