/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file FLASH.c
**
** 
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "flash.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/


/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/
/*****************************************************************************
 ** \brief	FLASH_UnLock
 **			
 ** \param [in] none
 ** \return  none
 ** \note	  ֵַ֧Լ
*****************************************************************************/
void FLASH_UnLock(void)
{
	MLOCK = 0xAA;
}
/*****************************************************************************
 ** \brief	FLASH_Lock
 **			
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void FLASH_Lock(void)
{
	MLOCK = 0x00;
}


/*****************************************************************************
 ** \brief	FLASH_ReadMLockFlag
 **			ȡMLCOK־λ
 ** \param [in] none
 ** \return  0ɲFLASH  1ɲFLASH
 ** \note	 
*****************************************************************************/
uint8_t  FLASH_ReadMLockFlag(void)
{
	return ((MSTATUS & FLASH_MSTATUS_MLOCKF_Msk)? 1:0);
}

/*****************************************************************************
 ** \brief	FLASH_ReadErrorFlag
 **			ȡ־λ
 ** \param [in] none
 ** \return  0޴  1
 ** \note	 
*****************************************************************************/
uint8_t  FLASH_ReadErrorFlag(void)
{
	return ((MSTATUS & FLASH_MSTATUS_ERROR_Msk)? 1:0);
}

/*****************************************************************************
 ** \brief	FLASH_Write
 **			д
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 **				Data: 8bit
 ** \return  none
 ** \note
*****************************************************************************/
void FLASH_Write(uint8_t FLASHModule, uint16_t Addr, uint8_t Data)
{
	MREGION = FLASHModule;
	MADRH = 0xFF & (Addr>>8);
	MADRL = 0xFF & Addr;	
	
	MDATA = Data;		
	MMODE = FLASH_WRITE;
	
	MSTATUS |= FLASH_MSTATUS_START_Msk;
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();	
	while(MSTATUS & 0x08);
	
}

/*****************************************************************************
 ** \brief	FLASH_Read
 **			
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **							  (3)FLASH_CONFIG : ûCONFIG
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 **							  (3)FLASH_CONFIG:  
 ** \return  8bit Data
 ** \note	
*****************************************************************************/
uint8_t FLASH_Read(uint8_t FLASHModule, uint16_t Addr)
{	
	MREGION = FLASHModule;
	MADRH = 0xFF & (Addr>>8);
	MADRL = 0xFF & Addr;	
		
	MMODE = FLASH_READ;

	MSTATUS |= FLASH_MSTATUS_START_Msk;

	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	while(MSTATUS & 0x08);

	return (MDATA);
}

/*****************************************************************************
 ** \brief	FLASH_Erase
 **			
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 ** \return  none
 ** \note	
*****************************************************************************/
void FLASH_Erase(uint8_t FLASHModule, uint16_t Addr)
{	
	MREGION = FLASHModule;
	
	MADRH = 0xFF & (Addr>>8);
	MADRL = 0xFF & Addr;	
		
	MMODE = FLASH_ERASE;

	MSTATUS |= FLASH_MSTATUS_START_Msk;

	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	while(MSTATUS & 0x08);

}

/*****************************************************************************
 ** \brief	FLASH_ReadCRC
 **			FLASHCRCֵ
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROM: APROM
 **							  (3)FLASH_CONFIG: ѡinformation
 **							  (4)FLASH_UID: ѡUID
 **				Addr: ѡCRCַ		  
 ** \return  CRCֵ
 ** \note
*****************************************************************************/
uint16_t FLASH_ReadCRC(uint8_t FLASHModule, uint16_t EAddr)
{
	uint16_t RCrcDat=0;
	
	CRCIN = 0;			//CRC
	CRCDL = 0;
	CRCDH = 0;	
	FLASH_UnLock();
	MADRH = 0xFF & (EAddr>>8);
	MADRL = 0xFF & EAddr;	
	MREGION = FLASHModule;	
	MMODE = FLASH_CRC;	

	MSTATUS |=FLASH_MSTATUS_START_Msk;

	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	while(MSTATUS & 0x08);
	
	RCrcDat = (CRCDH<<8)| CRCDL;
	FLASH_Lock();
	
	return RCrcDat;
}

/*****************************************************************************
 ** \brief	FLASH_ReadUID
 **			UIDֵ
** \param [in] UIDNum:0~15(which UID will be read)
 ** \return  ӦUIDֵ
 ** \note	
*****************************************************************************/
uint8_t FLASH_ReadUID(uint8_t UIDNum)
{	
	uint16_t UADDR = FLASH_ADDRUID;
	
	UADDR = UADDR + UIDNum;			//ƫƵַܹ16UIDһ
	FLASH_UnLock();
	MREGION = FLASH_UID;
	MADRH = 0xFF & (UADDR>>8);
	MADRL = 0xFF & UADDR;	
		
	MMODE = FLASH_READ;

	MSTATUS |= FLASH_MSTATUS_START_Msk;

	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	while(MSTATUS & 0x08);

	FLASH_Lock();
	
	return (MDATA);
}

/*****************************************************************************
 ** \brief	FLASH_ReadInformation
 **			Informationֵ
** \param [in] InfNum:0~31(which information will be read)
 ** \return  ӦInformationֵ
 ** \note	
*****************************************************************************/
uint8_t FLASH_ReadInformation(uint8_t InfNum)
{	
	uint16_t InfADDR = FLASH_ADDRInformation;
	
	InfADDR = InfADDR + InfNum;			//ƫƵַܹ32informationһ
	FLASH_UnLock();
	MREGION = FLASH_CONFIG;
	MADRH = 0xFF & (InfADDR>>8);
	MADRL = 0xFF & InfADDR;	
		
	MMODE = FLASH_READ;

	MSTATUS |= FLASH_MSTATUS_START_Msk;

	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	_nop_();
	while(MSTATUS & 0x08);

	FLASH_Lock();
	
	return (MDATA);
}



