/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file system.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __SYSTEM_H__
#define __SYSTEM_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **System  外设时钟
-----------------------------------------------------------------------------*/
/*----PCGEN0----------------------------------------------------------------*/
#define 	SYS_CLK0_UART1_MSK		(SYS_PCGEN0_UART1EN_Msk)	  /*UART1时钟使能位*/
#define 	SYS_CLK0_UART0_MSK		(SYS_PCGEN0_UART0EN_Msk)	  /*UART0时钟使能位*/
#define 	SYS_CLK0_SPI_MSK			(SYS_PCGEN0_SPIEN_Msk)		  /*SPI时钟使能位*/
#define 	SYS_CLK0_IIC_MSK			(SYS_PCGEN0_IICEN_Msk)	    /*IIC时钟使能位*/
#define 	SYS_CLK0_WDT_MSK			(SYS_PCGEN0_WDTEN_Msk)		  /*WDT时钟使能位*/
#define 	SYS_CLK0_TIMER5_MSK	(SYS_PCGEN0_TIMER5EN_Msk)	  /*TIMER5时钟使能位*/
#define 	SYS_CLK0_TIMER2_MSK	(SYS_PCGEN0_TIMER2EN_Msk)		/*TIMER2时钟使能位*/
#define 	SYS_CLK0_TIMER01_MSK	(SYS_PCGEN0_TIMER01EN_Msk)	/*TIMER01时钟使能位*/
/*----PCGEN1----------------------------------------------------------------*/
#define 	SYS_CLK1_DAC_MSK			(SYS_PCGEN1_DACEN_Msk)		  /*DAC时钟使能位*/
#define 	SYS_CLK1_TOUCH_MSK		(SYS_PCGEN1_TOUCHEN_Msk)		/*TOUCH时钟使能位*/
#define 	SYS_CLK1_LED_MSK		  (SYS_PCGEN1_LEDEN_Msk)	    /*LED时钟使能位*/
#define 	SYS_CLK1_ADC_MSK		  (SYS_PCGEN1_ADCEN_Msk)	    /*ADC时钟使能位*/
#define 	SYS_CLK1_PWM_MSK	    (SYS_PCGEN1_PWMEN_Msk)	    /*PWM时钟使能位*/
#define 	SYS_CLK1_LVD_MSK	    (SYS_PCGEN1_LVDEN_Msk)	    /*LVD时钟使能位*/
#define 	SYS_CLK1_BRT_MSK	    (SYS_PCGEN1_BRTEN_Msk)	    /*BRT波特率时钟使能位*/


/*----------------------------------------------------------------------------
**System 复位标志
---------------------------------------------------------------------------*/
typedef enum
{
	SYS_RSTFLAG_SWR  = 0x80,			//软件复位
  SYS_RSTFLAG_POR  = 0x40,			//上电复位
	SYS_RSTFLAG_EXTR = 0x20,      //外部复位
	SYS_RSTFLAG_WDTR = 0x04,			//WDT复位
	SYS_RSTFLAG_LVR  = 0x01,			//LVD复位	
}SYS_RSTF_t;

/*----------------------------------------------------------------------------
 **System 系统LVD电压监测点
---------------------------------------------------------------------------*/
#define 	SYS_LVD_2_5V		(0x07)	/*LVD电压监测点2.5V*/
#define 	SYS_LVD_2_7V		(0x06)	/*LVD电压监测点2.7V*/
#define 	SYS_LVD_3_3V		(0x04)	/*LVD电压监测点3.3V*/
#define 	SYS_LVD_3_0V		(0x03)	/*LVD电压监测点3.0V*/
#define 	SYS_LVD_3_7V		(0x02)	/*LVD电压监测点3.7V*/
#define 	SYS_LVD_4_0V		(0x01)	/*LVD电压监测点4.0V*/
#define 	SYS_LVD_4_3V		(0x00)	/*LVD电压监测点4.3V*/

/*----------------------------------------------------------------------------
 **System 系统LVD中断边沿
---------------------------------------------------------------------------*/
#define 	SYS_LVDINTEdge_Double	  (0x03)	/*LVD双沿产生中断*/
#define 	SYS_LVDINTEdge_Falling	(0x02)	/*LVD下降沿产生中断*/
#define 	SYS_LVDINTEdge_Rising	  (0x01)	/*LVD上升沿产生中断*/
#define 	SYS_LVDINTEdge_None		  (0x00)	/*LVD中断边沿检测功能关闭*/

/*----------------------------------------------------------------------------
 **System 系统LVD滤波时间
---------------------------------------------------------------------------*/
#define 	SYS_LVDFiltTime_4	  (0x03)	/*4个滤波时钟*/
#define 	SYS_LVDFiltTime_3	  (0x02)	/*3个滤波时钟*/
#define 	SYS_LVDFiltTime_2	  (0x01)	/*2个滤波时钟*/
#define 	SYS_LVDFiltTime_1		(0x00)	/*1个滤波时钟*/

/*----------------------------------------------------------------------------
 **System 系统LVD滤波时钟选择
---------------------------------------------------------------------------*/
#define 	SYS_LVDFiltFreq_64	(0x03)	/*滤波时钟为系统时钟64分频*/
#define 	SYS_LVDFiltFreq_16	(0x02)	/*滤波时钟为系统时钟16分频*/
#define 	SYS_LVDFiltFreq_4	  (0x01)	/*滤波时钟为系统时钟4分频*/
#define 	SYS_LVDFiltFreq_1		(0x00)	/*滤波时钟为系统时钟1分频*/

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/	
/*****************************************************************************
 ** \brief	 SYS_EnablePeripheralClk0
 **			 开启外设时钟
 ** \param [in] CLKSr:(0)SYS_CLK0_UART1_MSK		  UART1时钟使能位
 **               (1)SYS_CLK0_UART0_MSK		  UART0时钟使能位
 **               (2)SYS_CLK0_SPI_MSK			  SPI时钟使能位
 **               (3)SYS_CLK0_IIC_MSK			  IIC时钟使能位
 **               (4)SYS_CLK0_WDT_MSK			  WDT时钟使能位
 **               (5)SYS_CLK0_TIMER5_MSK	    TIMER5时钟使能位
 **               (6)SYS_CLK0_TIMER2_MSK		  TIMER2时钟使能位
 **               (7)SYS_CLK0_TIMER01_MSK		TIMER01时钟使能位
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnablePeripheralClk0(uint8_t Module);
/*****************************************************************************
 ** \brief	 SYS_EnablePeripheralClk1
 **			 开启外设时钟
 ** \param [in] CLKSr:(0)SYS_CLK1_DAC_MSK				DAC时钟使能位
 **               (1)SYS_CLK1_TOUCH_MSK			TOUCH时钟使能位
 **               (2)SYS_CLK1_LED_MSK		    LED时钟使能位
 **               (3)SYS_CLK1_ADC_MSK		    ADC时钟使能位
 **               (4)SYS_CLK1_PWM_MSK	      PWM时钟使能位
 **               (5)SYS_CLK1_LVD_MSK	      LVD时钟使能位
 **               (6)SYS_CLK1_BRT_MSK	      BRT波特率时钟使能位
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnablePeripheralClk1(uint8_t Module);
/*****************************************************************************
 ** \brief	 SYS_EnableSoftwareReset
 **			 使能软件复位System
 ** \param [in] none
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnableSoftwareReset(void);
/*****************************************************************************
 ** \brief	 SYS_DisableSoftwareReset
 **			 关闭软件复位System
 ** \param [in] none
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_DisableSoftwareReset(void);
/*****************************************************************************
 ** \brief	 SYS_GetWDTResetFlag
 **			 获取System复位的标志
 ** \param [in] FlagSt：SYS_RSTFLAG_POR，SYS_RSTFLAG_EXTR，SYS_RSTFLAG_WDTR
** \return 0：对应标志没有复位    1：对应标志有复位
 ** \note
 *****************************************************************************/
uint8_t SYS_GetResetFlag(SYS_RSTF_t FlagSt);
/*****************************************************************************
 ** \brief	 SYS_ClearWDTResetFlag
 **			 清除System复位的标志
 ** \param [in] FlagSt：SYS_RSTFLAG_POR，SYS_RSTFLAG_EXTR，SYS_RSTFLAG_WDTR
 ** \return   none
 ** \note
 *****************************************************************************/
void SYS_ClearResetFlag(SYS_RSTF_t FlagSt);
/*****************************************************************************
 ** \brief	 SYS_EnterStop
 **			 进入休眠中STOP状态
 ** \param [in] none
 ** \return none
 ** \note	
 *****************************************************************************/
void SYS_EnterStop(void);
/*****************************************************************************
 ** \brief	 SYS_EnterIdle
 **			 进入休眠模式中Idle状态
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnterIdle(void);
/*****************************************************************************
 ** \brief	 SYS_EnableSCM
 **			 使能停振监测功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnableSCM(void);
/*****************************************************************************
 ** \brief	 SYS_DisableSCM
 **			 关闭停振监测功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_DisableSCM(void);
/*****************************************************************************
 ** \brief	 SYS_EnableSCMInt
 **			 使能停振监测中断功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnableSCMInt(void);
/*****************************************************************************
 ** \brief	 SYS_DisableSCMInt
 **			 关闭停振监测中断功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_DisableSCMInt(void);
/*****************************************************************************
 ** \brief	 SYS_GetSCMIntFlag
 **			 获取停振监测中断标志位
 ** \param [in] none
 ** \return  0:无中断 1：有中断
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetSCMIntFlag(void);
/*****************************************************************************
 ** \brief	 SYS_GetSCMState
 **			 获取停振监测状态位位
 ** \param [in] none
 ** \return  0:停振恢复 1：停振
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetSCMState(void);
/*****************************************************************************
 ** \brief	 SYS_ClearSCMIntFlag
 **			 清除停振监测中断标志位
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ClearSCMIntFlag(void);
/*****************************************************************************
 ** \brief	 SYS_EnableLVD
 **			 开启电压监测功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_EnableLVD(void);
/*****************************************************************************
 ** \brief	 SYS_DisableLVD
 **			  关闭电压监测功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_DisableLVD(void);
/*****************************************************************************
  ** \brief	 SYS_ConfigLVD
 **			 配置系统电压监测电压
 ** \param [in] LVDValue :(1)SYS_LVD_2_5V		LVD电压监测点2.5V					
						(2)	SYS_LVD_2_7V		LVD电压监测点2.7V
						(3)	SYS_LVD_3_3V		LVD电压监测点3.3V
						(4)	SYS_LVD_3_0V		LVD电压监测点3.0V
						(5)	SYS_LVD_3_7V		LVD电压监测点3.7V
						(6)	SYS_LVD_4_0V		LVD电压监测点4.0V
						(7)	SYS_LVD_4_3V		LVD电压监测点4.3V
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVD(uint8_t LVDValue);
/*****************************************************************************
 ** \brief	 SYS_EnableLVDInt
 **			 开启电压监测中断功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_EnableLVDInt(void);
/*****************************************************************************
 ** \brief	 SYS_DisableLVDInt
 **			  关闭电压监测中断功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_DisableLVDInt(void);
/*****************************************************************************
  ** \brief	 SYS_ConfigLVD
 **			 配置LVD中断产生触发边沿
 ** \param [in] LVDValue :(1)SYS_LVDINTEdge_Double	  LVD双沿产生中断
						(2) SYS_LVDINTEdge_Falling	LVD下降沿产生中断
						(3) SYS_LVDINTEdge_Rising	  LVD上升沿产生中断
						(4) SYS_LVDINTEdge_None		  LVD中断边沿检测功能关闭
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDINT_Edge(uint8_t LVDEdg);
/*****************************************************************************
 ** \brief	 SYS_GetLVDIntFlag
 **			 获取LVD中断标志位
 ** \param [in] none
 ** \return  0:无中断 1：有中断
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetLVDIntFlag(void);
/*****************************************************************************
 ** \brief	 SYS_ClearLVDIntFlag
 **			 清除LVD中断标志位
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ClearLVDIntFlag(void);
/*****************************************************************************
  ** \brief	 SYS_ConfigLVDFilt_Time
 **			 配置系统电压监测滤波时间
 ** \param [in] LVDClk :(1)SYS_LVDFiltTime_4	  4个滤波时钟
						(2) SYS_LVDFiltTime_3	  3个滤波时钟
						(3) SYS_LVDFiltTime_2	  2个滤波时钟
						(4) SYS_LVDFiltTime_1		1个滤波时钟
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDFilt_Time(uint8_t LVDFiltTime);
/*****************************************************************************
  ** \brief	 SYS_ConfigLVDFilt_CLK
 **			 配置系统电压监测滤波时钟
 ** \param [in] LVDClk :(1)SYS_LVDFiltFreq_64	滤波时钟为系统时钟64分频
						(2) SYS_LVDFiltFreq_16	滤波时钟为系统时钟16分频
						(3) SYS_LVDFiltFreq_4	  滤波时钟为系统时钟4分频
						(4) SYS_LVDFiltFreq_1		滤波时钟为系统时钟1分频
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDFilt_CLK(uint8_t LVDFiltClk);

#endif /* __SYSTEM_H__ */



