/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province,
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file flash.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __FLASH_H__
#define __FLASH_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **FLASH 
/*---------------------------------------------------------------------------*/
#define	FLASH_APROM			(0x55)
#define	FLASH_DATA			(0xAA)
#define	FLASH_CONFIG		(0x69)
#define	FLASH_UID   		(0x66)

/*----------------------------------------------------------------------------
 **FLASH 
/*---------------------------------------------------------------------------*/
#define	FLASH_WRITE			(0xAA)
#define	FLASH_READ			(0x69)
#define	FLASH_ERASE			(0x55)
#define	FLASH_CRC       (0x96)

#define	FLASH_ADDRUID   				(0x680)
#define	FLASH_ADDRInformation   (0x480)
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	FLASH_UnLock
 **			
 ** \param [in] none
 ** \return  none
 ** \note	 ֵַ֧Լ
*****************************************************************************/
void FLASH_UnLock(void);
/*****************************************************************************
 ** \brief	FLASH_Lock
 **			
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void FLASH_Lock(void);

/*****************************************************************************
 ** \brief	FLASH_Write
 **			д
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 **				Data: 8bit
 ** \return  none
 ** \note	 
*****************************************************************************/
void FLASH_Write(uint8_t FLASHModule, uint16_t Addr, uint8_t Data);

/*****************************************************************************
 ** \brief	FLASH_Read
 **			
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **							  (3)FLASH_CONFIG : ûCONFIG
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 **							  (3)FLASH_CONFIG:  
 ** \return  8bit Data
 ** \note	
*****************************************************************************/
uint8_t FLASH_Read(uint8_t FLASHModule, uint16_t Addr);

/*****************************************************************************
 ** \brief	FLASH_Erase
 **			
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROMAPROM
 **				Addr: 		  (1)DATA 0x00~0x3FF
 **							  (2)APROM0x00~0x7FFF
 ** \return  none
 ** \note	
*****************************************************************************/
void FLASH_Erase(uint8_t FLASHModule, uint16_t Addr);

/*****************************************************************************
 ** \brief	FLASH_ReadCRC
 **			FLASHCRCֵ
 ** \param [in] FLASHModule	(1)FLASH_DATA: DATA
 **							  (2)FLASH_APROM: APROM
 **							  (3)FLASH_CONFIG: ѡinformation
 **							  (4)FLASH_UID: ѡUID
 **				Addr: ѡCRCַ		  
 ** \return  CRCֵ
 ** \note
*****************************************************************************/
uint16_t FLASH_ReadCRC(uint8_t FLASHModule, uint16_t EAddr);

/*****************************************************************************
 ** \brief	FLASH_ReadMLockFlag
 **			ȡMLCOK־λ
 ** \param [in] none
 ** \return  0ɲFLASH  1ɲFLASH
 ** \note	 
*****************************************************************************/
uint8_t  FLASH_ReadMLockFlag(void);

/*****************************************************************************
 ** \brief	FLASH_ReadErrorFlag
 **			ȡ־λ
 ** \param [in] none
 ** \return  0޴  1
 ** \note	 
*****************************************************************************/
uint8_t  FLASH_ReadErrorFlag(void);

/*****************************************************************************
 ** \brief	FLASH_ReadUID
 **			UIDֵ
** \param [in] UIDNum:0~15(which UID will be read)
 ** \return  ӦUIDֵ
 ** \note	
*****************************************************************************/
uint8_t FLASH_ReadUID(uint8_t UIDNum);
/*****************************************************************************
 ** \brief	FLASH_ReadInformation
 **			Informationֵ
** \param [in] InfNum:0~31(which information will be read)
 ** \return  ӦInformationֵ
 ** \note	
*****************************************************************************/
uint8_t FLASH_ReadInformation(uint8_t InfNum);


#endif /* __FLASH_H__ */
