/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file adc.h
**
** 
**
** History:
** 
******************************************************************************/
#ifndef __ADC_H__
#define __ADC_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **ADC ͨ
/*---------------------------------------------------------------------------*/
#define  ADC_CH_0		 	(0x00)				/* AN0 */
#define  ADC_CH_1			(0x01)				/* AN1 */
#define  ADC_CH_2		 	(0x02)				/* AN2 */
#define  ADC_CH_3			(0x03)				/* AN3 */
#define  ADC_CH_4		 	(0x04)				/* AN4 */
#define  ADC_CH_5			(0x05)				/* AN5 */
#define  ADC_CH_6		 	(0x06)				/* AN6 */
#define  ADC_CH_7			(0x07)				/* AN7 */
#define  ADC_CH_8		 	(0x08)				/* AN8 */
#define  ADC_CH_9			(0x09)				/* AN9 */
#define  ADC_CH_10			(0x0a)				/* AN10 */
#define  ADC_CH_11		 	(0x0b)				/* AN11 */
#define  ADC_CH_12			(0x0c)				/* AN12 */
#define  ADC_CH_13		 	(0x0d)				/* AN13 */
#define  ADC_CH_14			(0x0e)				/* AN14 */
#define  ADC_CH_15			(0x0f)				/* AN15 */
#define  ADC_CH_16			(0x10)				/* AN16 */
#define  ADC_CH_17			(0x11)				/* AN17 */
#define  ADC_CH_18			(0x12)				/* AN18 */
#define  ADC_CH_19			(0x13)				/* AN19 */
#define  ADC_CH_20			(0x14)				/* AN20 */
#define  ADC_CH_21			(0x15)				/* AN21 */
#define  ADC_CH_22			(0x16)				/* AN22 */
#define  ADC_CH_23			(0x17)				/* AN23 */
#define  ADC_CH_39			(0x27)				/* AN39 */
#define  ADC_CH_40			(0x28)				/* AN40 */
#define  ADC_CH_41			(0x29)				/* AN41 */
#define  ADC_CH_42			(0x2a)				/* AN42 */
#define  ADC_CH_43			(0x2b)				/* AN43 */
#define  ADC_CH_44			(0x2c)				/* AN44 */
#define  ADC_CH_48			(0x30)				/* AN48-VDD */
#define  ADC_CH_49			(0x31)				/* AN49-GND */
#define  ADC_CH_52			(0x34)				/* AN52-VBG0.8V */


/*----------------------------------------------------------------------------
 **ADC ʱӷƵ
/*---------------------------------------------------------------------------*/
#define  ADC_CLK_DIV_2		(0x00)
#define  ADC_CLK_DIV_4		(0x01)
#define  ADC_CLK_DIV_8		(0x02)
#define  ADC_CLK_DIV_16		(0x03)
#define  ADC_CLK_DIV_32		(0x04)
#define  ADC_CLK_DIV_64		(0x05)
#define  ADC_CLK_DIV_128	(0x06)
#define  ADC_CLK_DIV_256	(0x07)

/*----------------------------------------------------------------------------
 **ADC οѹ
/*---------------------------------------------------------------------------*/
#define  ADC_VREF_VDDREF		(0x00)    //LDOAD need to be closed
#define  ADC_VREF_ADCLDO		(0x01)

/*****************************************************************************
 ** \brief	 ADC_IS_BUSY
 **			 жADC״̬
 ** \param [in]	 none        
 ** \return   
*****************************************************************************/
#define  ADC_IS_BUSY				(ADCON0 & ADC_ADCON0_ADGO_Msk)
/*****************************************************************************
 ** \brief	 ADC_GO
 **			 ADCת()
 ** \param [in]	 none     
 ** \return  none
*****************************************************************************/
#define  ADC_GO() 				 do{\
									ADCON0 |= ADC_ADCON0_ADGO_Msk;\
								   }while(0)
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/
                   
/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 ADC_Start			
 ** \param [in] none       
 ** \return  none
*****************************************************************************/
void  ADC_Start(void);
/*****************************************************************************
 ** \brief	 ADC_Stop			
 ** \param [in] none         
 ** \return  none
*****************************************************************************/
void  ADC_Stop(void);

/*****************************************************************************
 ** \brief	 ADC_ConvertClock
 **			  ADCת
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigClock( uint8_t ConvertTime);

/*****************************************************************************
 ** \brief	 ADC_ConvertClock
 **			  ADCĲοѹ
 ** \param [in] VrefDatADC_VREF_VDDREF, ADC_VREF_ADCLDO
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigVREF( uint8_t VrefDat);

/*****************************************************************************
 ** \brief	 ADC_ConfigRunMode
 **			  ADCģʽ
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 **          	  VrefDatADC_VREF_VDDREF, ADC_VREF_ADCLDO
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_ConfigRunMode( uint8_t ADCClkDiv, uint8_t ADCVRef);

/*****************************************************************************
 ** \brief	 ADC_EnableChannel
 **			 ʹADCתͨ
 ** \param [in]  ADCChannel: ADC_CH_0 ..... ADC_CH_54
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_EnableChannel(uint16_t ADCChannel);

/*****************************************************************************
 ** \brief	 ADC_GetADCResult
 **			 ȡADCת
 ** \param [in]  none
 ** \return  12bits ADCֵ
 ** \note 
*****************************************************************************/
uint16_t  ADC_GetADCResult(void);

/*****************************************************************************
 ** \brief	 ADC_EnableInt
 **			 ADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_EnableInt(void);
/*****************************************************************************
 ** \brief	 ADC_DisableInt
 **			 رADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_DisableInt(void);
/*****************************************************************************
 ** \brief	 ADC_GetIntFlag
 **			 ȡADCתжϱ־λ
 ** \param [in]  none
 ** \return  0жϣ1ж
 ** \note 
******************************************************************************/
uint8_t ADC_GetIntFlag(void);
/******************************************************************************
 ** \brief	 ADC_ClearIntFlag
 **			 ADCתжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void ADC_ClearIntFlag(void);
/*****************************************************************************
 ** \brief	 ADC_LDOStart
 **			 ʹADCLDO
 ** \param [in] none:
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_LDOStart(void);
/*****************************************************************************
 ** \brief	 ADC_LDOStop
 **			 رADCLDO
 ** \param [in] none:
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_LDOStop(void);


#endif /* __ADC_H__ */






