/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file cms80f752x.h
**
**
**
** History:
** 
*****************************************************************************/
#ifndef _CMS80F752X_H_
#define _CMS80F752X_H_
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "intrins.h"

/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*!< Signed integer types  */
typedef   signed char     int8_t;
typedef   signed short    int16_t;
typedef   signed long     int32_t;

/*!< Unsigned integer types  */
typedef unsigned char     uint8_t;
typedef unsigned short    uint16_t;
typedef unsigned long     uint32_t;

typedef int32_t  s32;
typedef int16_t  s16;
typedef int8_t   s8;

typedef uint32_t  u32;
typedef uint16_t  u16;
typedef uint8_t   u8;

sfr P0          =   0x0080;   
sfr SP          =   0x0081;   
sfr DPL0        =   0x0082;   
sfr DPH0        =   0x0083;   
sfr DPS         =   0x0086;   
sfr PCON        =   0x0087;   
sfr TCON        =   0x0088;   
sfr TMOD        =   0x0089;   
sfr TL0         =   0x008A;   
sfr TL1         =   0x008B;   
sfr TH0         =   0x008C;   
sfr TH1         =   0x008D;   
sfr CKCON       =   0x008E;   
sfr WDKEY       =   0x008F;   
sfr P1          =   0x0090;   
sfr PCGEN0      =   0x0092;   
sfr PCGEN1      =   0x0093;   
sfr RSTCF       =   0x0095;   
sfr TA          =   0x0096;   
sfr WDCON       =   0x0097;   
sfr SCON0       =   0x0098;   
sfr SBUF0       =   0x0099;   
sfr P0TRIS      =   0x009A;   
sfr P1TRIS      =   0x009B;   
sfr P2TRIS      =   0x009C;   
sfr P5TRIS      =   0x009F;   
sfr P2          =   0x00A0;   
sfr IREMAP      =   0x00A1;   
sfr IE          =   0x00A8;   
sfr EIE2        =   0x00AA;   
sfr EI0IE       =   0x00AC;   
sfr EI1IE       =   0x00AD;      
sfr EIF2        =   0x00B2;   
sfr EI0IF       =   0x00B4;   
sfr EI1IF       =   0x00B5;   
sfr IP          =   0x00B8;   
sfr EIP1        =   0x00B9;   
sfr EIP2        =   0x00BA;   
sfr EIP3        =   0x00BB;   
sfr CCL1        =   0x00C2;   
sfr CCH1        =   0x00C3;   
sfr T2CON       =   0x00C8;   
sfr T2IF        =   0x00C9;   
sfr RLDL        =   0x00CA;   
sfr RLDH        =   0x00CB;   
sfr TL2         =   0x00CC;   
sfr TH2         =   0x00CD;   
sfr CCEN        =   0x00CE;   
sfr T2IE        =   0x00CF;   
sfr PSW         =   0x00D0;   
sfr TL5         =   0x00D3;   
sfr TH5         =   0x00D4;   
sfr T5CON       =   0x00D5;   
sfr P5          =   0x00D8;   
sfr ADRESL      =   0x00DC;   
sfr ADRESH      =   0x00DD;   
sfr ADCON1      =   0x00DE;   
sfr ADCON0      =   0x00DF;   
sfr ACC         =   0x00E0;   
sfr SCON1       =   0x00EA;   
sfr SBUF1       =   0x00EB;   
sfr SPCR        =   0x00EC;   
sfr SPSR        =   0x00ED;   
sfr SPDR        =   0x00EE;   
sfr SSCR        =   0x00EF;   
sfr B           =   0x00F0;   
sfr I2CCON      =   0x00F1;   
sfr I2CCLR      =   0x00F2;   
sfr I2CSTAT     =   0x00F3;   
sfr I2CDAT      =   0x00F4;   
sfr I2CCLK      =   0x00F5;   
sfr I2CADR      =   0x00F6;   
sfr I2CXAR      =   0x00F7;   
sfr MREGION     =   0x00F9;   
sfr MMODE       =   0x00FA;   
sfr MDATA       =   0x00FB;   
sfr MADRL       =   0x00FC;   
sfr MADRH       =   0x00FD;   
sfr MSTATUS     =   0x00FE;   
sfr MLOCK       =   0x00FF; 

#define P0DIG           *(volatile unsigned char xdata *)   0xF060   
#define P1DIG           *(volatile unsigned char xdata *)   0xF061   
#define P2DIG           *(volatile unsigned char xdata *)   0xF062   
#define P5DIG           *(volatile unsigned char xdata *)   0xF065   
#define P0UP            *(volatile unsigned char xdata *)   0xF068   
#define P1UP            *(volatile unsigned char xdata *)   0xF069   
#define P2UP            *(volatile unsigned char xdata *)   0xF06A   
#define P5UP            *(volatile unsigned char xdata *)   0xF06D   
#define P0OD            *(volatile unsigned char xdata *)   0xF070   
#define P1OD            *(volatile unsigned char xdata *)   0xF071   
#define P2OD            *(volatile unsigned char xdata *)   0xF072   
#define P5OD            *(volatile unsigned char xdata *)   0xF075   
#define P0RD            *(volatile unsigned char xdata *)   0xF078   
#define P1RD            *(volatile unsigned char xdata *)   0xF079   
#define P2RD            *(volatile unsigned char xdata *)   0xF07A   
#define P5RD            *(volatile unsigned char xdata *)   0xF07D   
#define PS_T0           *(volatile unsigned char xdata *)   0xF0C2   
#define PS_T0G          *(volatile unsigned char xdata *)   0xF0C3   
#define PS_T1           *(volatile unsigned char xdata *)   0xF0C4   
#define PS_T1G          *(volatile unsigned char xdata *)   0xF0C5   
#define PS_T2           *(volatile unsigned char xdata *)   0xF0C6   
#define PS_T2EX         *(volatile unsigned char xdata *)   0xF0C7   
#define PS_EINT0        *(volatile unsigned char xdata *)   0xF0C8   
#define PS_EINT1        *(volatile unsigned char xdata *)   0xF0C9   
#define PS_EINT2        *(volatile unsigned char xdata *)   0xF0CA   
#define PS_EINT3        *(volatile unsigned char xdata *)   0xF0CB   
#define PS_TXD1         *(volatile unsigned char xdata *)   0xF0D0   
#define PS_RXD1         *(volatile unsigned char xdata *)   0xF0D1   
#define PS_TXD0         *(volatile unsigned char xdata *)   0xF0D2   
#define PS_RXD0         *(volatile unsigned char xdata *)   0xF0D3   
#define PS_SCL          *(volatile unsigned char xdata *)   0xF0D4   
#define PS_SDA          *(volatile unsigned char xdata *)   0xF0D5   
#define PS_PG0          *(volatile unsigned char xdata *)   0xF0D6   
#define PS_PG1          *(volatile unsigned char xdata *)   0xF0D7   
#define PS_PG2          *(volatile unsigned char xdata *)   0xF0D8   
#define PS_PG3          *(volatile unsigned char xdata *)   0xF0D9   
#define PS_PG4          *(volatile unsigned char xdata *)   0xF0DA   
#define PS_PG5          *(volatile unsigned char xdata *)   0xF0DB   
#define PS_CC0          *(volatile unsigned char xdata *)   0xF0DC   
#define PS_CC1          *(volatile unsigned char xdata *)   0xF0DD   
#define EI0CFGL         *(volatile unsigned char xdata *)   0xF0E0   
#define INTFC           *(volatile unsigned char xdata *)   0xF0E4   
#define PS_SCLKOI       *(volatile unsigned char xdata *)   0xF0F0   
#define PS_MOSI         *(volatile unsigned char xdata *)   0xF0F1   
#define PS_MISO         *(volatile unsigned char xdata *)   0xF0F2   
#define PS_NSS0OI       *(volatile unsigned char xdata *)   0xF0F3   
#define PS_NSS1OI       *(volatile unsigned char xdata *)   0xF0F4   
#define PS_NSS2OI       *(volatile unsigned char xdata *)   0xF0F5   
#define PS_NSS3OI       *(volatile unsigned char xdata *)   0xF0F6   
#define PS_CLO          *(volatile unsigned char xdata *)   0xF0F7   
#define PWMCON          *(volatile unsigned char xdata *)   0xF120   
#define PWMOE           *(volatile unsigned char xdata *)   0xF121   
#define PWMPINV         *(volatile unsigned char xdata *)   0xF122   
#define PWMCNTE         *(volatile unsigned char xdata *)   0xF126   
#define PWMCNTM         *(volatile unsigned char xdata *)   0xF127   
#define PWMCNTCLR       *(volatile unsigned char xdata *)   0xF128   
#define PWMLOADEN       *(volatile unsigned char xdata *)   0xF129   
#define PWM0DIV         *(volatile unsigned char xdata *)   0xF12A   
#define PWM1DIV         *(volatile unsigned char xdata *)   0xF12B   
#define PWM2DIV         *(volatile unsigned char xdata *)   0xF12C  
#define PWMP0L          *(volatile unsigned char xdata *)   0xF130   
#define PWMP0H          *(volatile unsigned char xdata *)   0xF131	
#define PWMP1L          *(volatile unsigned char xdata *)   0xF134   
#define PWMP1H          *(volatile unsigned char xdata *)   0xF135   
#define PWMP2L          *(volatile unsigned char xdata *)   0xF138   
#define PWMP2H          *(volatile unsigned char xdata *)   0xF139 	  
#define PWMD0L          *(volatile unsigned char xdata *)   0xF140   
#define PWMD0H          *(volatile unsigned char xdata *)   0xF141   
#define PWMD1L          *(volatile unsigned char xdata *)   0xF142   
#define PWMD1H          *(volatile unsigned char xdata *)   0xF143   
#define PWMD2L          *(volatile unsigned char xdata *)   0xF144   
#define PWMD2H          *(volatile unsigned char xdata *)   0xF145   
#define PWMD3L          *(volatile unsigned char xdata *)   0xF146   
#define PWMD3H          *(volatile unsigned char xdata *)   0xF147   
#define PWMD4L          *(volatile unsigned char xdata *)   0xF148   
#define PWMD4H          *(volatile unsigned char xdata *)   0xF149   
#define PWMD5L          *(volatile unsigned char xdata *)   0xF14A   
#define PWMD5H          *(volatile unsigned char xdata *)   0xF14B   
#define PWMDTE          *(volatile unsigned char xdata *)   0xF160   
#define PWM01DT         *(volatile unsigned char xdata *)   0xF161   
#define PWM23DT         *(volatile unsigned char xdata *)   0xF162   
#define PWM45DT         *(volatile unsigned char xdata *)   0xF163   
#define PWMZIE          *(volatile unsigned char xdata *)   0xF169   
#define PWMDIE          *(volatile unsigned char xdata *)   0xF16B   
#define PWMZIF          *(volatile unsigned char xdata *)   0xF16D   
#define PWMDIF          *(volatile unsigned char xdata *)   0xF16F     
#define BRTDL           *(volatile unsigned char xdata *)   0xF5C1   
#define BRTDH           *(volatile unsigned char xdata *)   0xF5C2   
#define LVDCON          *(volatile unsigned char xdata *)   0xF690   
#define LVDEICFG        *(volatile unsigned char xdata *)   0xF691   
#define LVDS            *(volatile unsigned char xdata *)   0xF692   
#define ADCLDO          *(volatile unsigned char xdata *)   0xF693   
#define XT_SCM          *(volatile unsigned char xdata *)   0xF697   
#define KEYCON0         *(volatile unsigned char xdata *)   0xF6D0   
#define KEYCON1         *(volatile unsigned char xdata *)   0xF6D1   
#define KEYCON2         *(volatile unsigned char xdata *)   0xF6D2   
#define KEYCON3         *(volatile unsigned char xdata *)   0xF6D3   
#define KEYCON4         *(volatile unsigned char xdata *)   0xF6D4   
#define KEYCON5         *(volatile unsigned char xdata *)   0xF6D5   
#define KEYCON6         *(volatile unsigned char xdata *)   0xF6D6   
#define KEYCON7         *(volatile unsigned char xdata *)   0xF6D7   
#define KEYCON8         *(volatile unsigned char xdata *)   0xF6D8   
#define KEYCON9         *(volatile unsigned char xdata *)   0xF6D9   
#define KEYMAXL         *(volatile unsigned char xdata *)   0xF6E0   
#define KEYMAXH         *(volatile unsigned char xdata *)   0xF6E1   
#define KEYMINL         *(volatile unsigned char xdata *)   0xF6E2   
#define KEYMINH         *(volatile unsigned char xdata *)   0xF6E3   
#define KEYAVGL         *(volatile unsigned char xdata *)   0xF6E4   
#define KEYAVGH         *(volatile unsigned char xdata *)   0xF6E5   
#define KEYTEST         *(volatile unsigned char xdata *)   0xF6E6   
#define CRCIN           *(volatile unsigned char xdata *)   0xF708   
#define CRCDL           *(volatile unsigned char xdata *)   0xF709   
#define CRCDH           *(volatile unsigned char xdata *)   0xF70A   
#define LEDC0DATA0      *(volatile unsigned char xdata *)   0xF740   
#define LED0DATA        *(volatile unsigned char xdata *)   0xF740   
#define LEDC0DATA1      *(volatile unsigned char xdata *)   0xF741   
#define LED1DATA        *(volatile unsigned char xdata *)   0xF741   
#define LEDC0DATA2      *(volatile unsigned char xdata *)   0xF742   
#define LEDC0DATA3      *(volatile unsigned char xdata *)   0xF743   
#define LEDC1DATA0      *(volatile unsigned char xdata *)   0xF744   
#define LED2DATA        *(volatile unsigned char xdata *)   0xF744   
#define LEDC1DATA1      *(volatile unsigned char xdata *)   0xF745   
#define LED3DATA        *(volatile unsigned char xdata *)   0xF745   
#define LEDC1DATA2      *(volatile unsigned char xdata *)   0xF746   
#define LEDC1DATA3      *(volatile unsigned char xdata *)   0xF747   
#define LEDC2DATA0      *(volatile unsigned char xdata *)   0xF748   
#define LED4DATA        *(volatile unsigned char xdata *)   0xF748   
#define LEDC2DATA1      *(volatile unsigned char xdata *)   0xF749   
#define LED5DATA        *(volatile unsigned char xdata *)   0xF749   
#define LEDC2DATA2      *(volatile unsigned char xdata *)   0xF74A   
#define LEDC2DATA3      *(volatile unsigned char xdata *)   0xF74B   
#define LEDC3DATA0      *(volatile unsigned char xdata *)   0xF74C   
#define LED6DATA        *(volatile unsigned char xdata *)   0xF74C   
#define LEDC3DATA1      *(volatile unsigned char xdata *)   0xF74D   
#define LED7DATA        *(volatile unsigned char xdata *)   0xF74D   
#define LEDC3DATA2      *(volatile unsigned char xdata *)   0xF74E   
#define LEDC3DATA3      *(volatile unsigned char xdata *)   0xF74F   
#define LEDC4DATA0      *(volatile unsigned char xdata *)   0xF750   
#define LED0SEL         *(volatile unsigned char xdata *)   0xF750   
#define LEDC4DATA1      *(volatile unsigned char xdata *)   0xF751   
#define LED1SEL         *(volatile unsigned char xdata *)   0xF751   
#define LEDC4DATA2      *(volatile unsigned char xdata *)   0xF752   
#define LEDC4DATA3      *(volatile unsigned char xdata *)   0xF753   
#define LEDC5DATA0      *(volatile unsigned char xdata *)   0xF754   
#define LED2SEL         *(volatile unsigned char xdata *)   0xF754   
#define LEDC5DATA1      *(volatile unsigned char xdata *)   0xF755   
#define LED3SEL         *(volatile unsigned char xdata *)   0xF755   
#define LEDC5DATA2      *(volatile unsigned char xdata *)   0xF756   
#define LEDC5DATA3      *(volatile unsigned char xdata *)   0xF757   
#define LEDC6DATA0      *(volatile unsigned char xdata *)   0xF758   
#define LED4SEL         *(volatile unsigned char xdata *)   0xF758   
#define LEDC6DATA1      *(volatile unsigned char xdata *)   0xF759   
#define LED5SEL         *(volatile unsigned char xdata *)   0xF759   
#define LEDC6DATA2      *(volatile unsigned char xdata *)   0xF75A   
#define LEDC6DATA3      *(volatile unsigned char xdata *)   0xF75B   
#define LEDC7DATA0      *(volatile unsigned char xdata *)   0xF75C   
#define LED6SEL         *(volatile unsigned char xdata *)   0xF75C   
#define LEDC7DATA1      *(volatile unsigned char xdata *)   0xF75D   
#define LED7SEL         *(volatile unsigned char xdata *)   0xF75D   
#define LEDC7DATA2      *(volatile unsigned char xdata *)   0xF75E   
#define LEDC7DATA3      *(volatile unsigned char xdata *)   0xF75F   
#define LEDCOMEN        *(volatile unsigned char xdata *)   0xF760   
#define LEDIOEN         *(volatile unsigned char xdata *)   0xF760   
#define LEDSEGEN0       *(volatile unsigned char xdata *)   0xF761   
#define SCAN1W          *(volatile unsigned char xdata *)   0xF761   
#define LEDSEGEN1       *(volatile unsigned char xdata *)   0xF762   
#define SCAN2W          *(volatile unsigned char xdata *)   0xF762   
#define LEDSEGEN2       *(volatile unsigned char xdata *)   0xF763   
#define LEDSEGEN3       *(volatile unsigned char xdata *)   0xF764   
#define LEDCON          *(volatile unsigned char xdata *)   0xF765   
#define LEDCON1         *(volatile unsigned char xdata *)   0xF765   
#define LEDCKS          *(volatile unsigned char xdata *)   0xF766   
#define LEDCOMTIME      *(volatile unsigned char xdata *)   0xF768   
#define LEDMODE         *(volatile unsigned char xdata *)   0xF769   
#define LEDSTATUS       *(volatile unsigned char xdata *)   0xF76A   
#define LEDDRV          *(volatile unsigned char xdata *)   0xF76B   
#define LEDRESEQ        *(volatile unsigned char xdata *)   0xF76C   
#define LEDSEGTIME      *(volatile unsigned char xdata *)   0xF76D   
#define LEDCOMDRV       *(volatile unsigned char xdata *)   0xF76E   
#define LEDDRVEN0       *(volatile unsigned char xdata *)   0xF76F   
#define LEDDRVEN1       *(volatile unsigned char xdata *)   0xF770   
#define LEDDRVEN2       *(volatile unsigned char xdata *)   0xF771   
#define LEDDRVEN3       *(volatile unsigned char xdata *)   0xF772   

#define LEDCON1         *(volatile unsigned char xdata *)   0xF765 
#define SCAN1W          *(volatile unsigned char xdata *)   0xF761 
#define SCAN2W          *(volatile unsigned char xdata *)   0xF762

#define LEDSEGDR0       *(volatile unsigned char xdata *)   0xF76F   
#define LEDSEGDR1       *(volatile unsigned char xdata *)   0xF770   
#define LEDSEGDR2       *(volatile unsigned char xdata *)   0xF771 
#define LEDSEGDR3       *(volatile unsigned char xdata *)   0xF772 
	
#define LED0DATA        *(volatile unsigned char xdata *)   0xF740
#define LED1DATA        *(volatile unsigned char xdata *)   0xF741
#define LED2DATA        *(volatile unsigned char xdata *)   0xF744
#define LED3DATA        *(volatile unsigned char xdata *)   0xF745
#define LED4DATA        *(volatile unsigned char xdata *)   0xF748
#define LED5DATA        *(volatile unsigned char xdata *)   0xF749
#define LED6DATA        *(volatile unsigned char xdata *)   0xF74C
#define LED7DATA        *(volatile unsigned char xdata *)   0xF74D
	
#define LED0SEL         *(volatile unsigned char xdata *)   0xF750
#define LED1SEL         *(volatile unsigned char xdata *)   0xF751
#define LED2SEL         *(volatile unsigned char xdata *)   0xF754
#define LED3SEL         *(volatile unsigned char xdata *)   0xF755
#define LED4SEL         *(volatile unsigned char xdata *)   0xF758
#define LED5SEL         *(volatile unsigned char xdata *)   0xF759
#define LED6SEL         *(volatile unsigned char xdata *)   0xF75C
#define LED7SEL         *(volatile unsigned char xdata *)   0xF75D
#define LEDIOEN         *(volatile unsigned char xdata *)   0xF760		
/*--------------------------------------------------------------- --------
  BIT Register  
-------------------------------------------------------------------------*/
/*  P0  */
  sbit P07	= P0^7;
  sbit P06  = P0^6;
  sbit P05  = P0^5;
  sbit P04  = P0^4;
  sbit P03  = P0^3;
  sbit P02  = P0^2;
  sbit P01  = P0^1;
  sbit P00  = P0^0;
/*  P1  */
  sbit P17  = P1^7;
  sbit P16  = P1^6;
  sbit P15  = P1^5;
  sbit P14  = P1^4;
  sbit P13  = P1^3;
  sbit P12  = P1^2;
  sbit P11  = P1^1;
  sbit P10  = P1^0;
/*  P2  */
  sbit P27  = P2^7;
  sbit P26  = P2^6;
  sbit P25  = P2^5;
  sbit P24  = P2^4;
  sbit P23  = P2^3;
  sbit P22  = P2^2;
  sbit P21  = P2^1;
  sbit P20  = P2^0;
  
/*  P5  */
  sbit P55  = P5^5;
  sbit P54  = P5^4;
  sbit P53  = P5^3;
  sbit P52  = P5^2;
  sbit P51  = P5^1;
  sbit P50  = P5^0;    

/* Definitions for P0 register  */
sbit P0_7    =   P0^7;
sbit P0_6    =   P0^6;
sbit P0_5    =   P0^5;
sbit P0_4    =   P0^4;
sbit P0_3    =   P0^3;
sbit P0_2    =   P0^2;
sbit P0_1    =   P0^1;
sbit P0_0    =   P0^0;

/* Definitions for TCON register  */
sbit TF1     =   TCON^7;
sbit TR1     =   TCON^6;
sbit TF0     =   TCON^5;
sbit TR0     =   TCON^4;
sbit IE1     =   TCON^3;
sbit IT1     =   TCON^2;
sbit IE0     =   TCON^1;
sbit IT0     =   TCON^0;

/* Definitions for P1 register  */
sbit P1_7    =   P1^7;
sbit P1_6    =   P1^6;
sbit P1_5    =   P1^5;
sbit P1_4    =   P1^4;
sbit P1_3    =   P1^3;
sbit P1_2    =   P1^2;
sbit P1_1    =   P1^1;
sbit P1_0    =   P1^0;

/* Definitions for SCON0 register  */
sbit U0SM0   =   SCON0^7;
sbit U0SM1   =   SCON0^6;
sbit U0SM2   =   SCON0^5;
sbit U0REN   =   SCON0^4;
sbit U0TB8   =   SCON0^3;
sbit U0RB8   =   SCON0^2;
sbit TI0     =   SCON0^1;
sbit RI0     =   SCON0^0;

/* Definitions for P2 register  */
sbit P2_7    =   P2^7;
sbit P2_6    =   P2^6;
sbit P2_5    =   P2^5;
sbit P2_4    =   P2^4;
sbit P2_3    =   P2^3;
sbit P2_2    =   P2^2;
sbit P2_1    =   P2^1;
sbit P2_0    =   P2^0;

/* Definitions for IE register  */
sbit EA      =   IE^7;
sbit ES1     =   IE^6;
sbit ET2     =   IE^5;
sbit ES0     =   IE^4;
sbit ET1     =   IE^3;
sbit EX1     =   IE^2;
sbit ET0     =   IE^1;
sbit EX0     =   IE^0;

/* Definitions for IP register  */
sbit PS1     =   IP^6;
sbit PT2     =   IP^5;
sbit PS0     =   IP^4;
sbit PT1     =   IP^3;
sbit PX1     =   IP^2;
sbit PT0     =   IP^1;
sbit PX0     =   IP^0;

/* Definitions for T2CON register  */
sbit T2PS    =   T2CON^7;
sbit I3FR    =   T2CON^6;
sbit CAPES   =   T2CON^5;
sbit T2R1    =   T2CON^4;
sbit T2R0    =   T2CON^3;
sbit T2CM    =   T2CON^2;
sbit T2I1    =   T2CON^1;
sbit T2I0    =   T2CON^0;

/* Definitions for PSW register  */
sbit CY      =   PSW^7;
sbit AC      =   PSW^6;
sbit F0      =   PSW^5;
sbit RS1     =   PSW^4;
sbit RS0     =   PSW^3;
sbit OV      =   PSW^2;
sbit P       =   PSW^0;

/* Definitions for P5 register  */
sbit P5_7    =   P5^7;
sbit P5_6    =   P5^6;
sbit P5_5    =   P5^5;
sbit P5_4    =   P5^4;
sbit P5_3    =   P5^3;
sbit P5_2    =   P5^2;
sbit P5_1    =   P5^1;
sbit P5_0    =   P5^0;

/* Definitions for ACC register  */
sbit ACC_7   =   ACC^7;
sbit ACC_6   =   ACC^6;
sbit ACC_5   =   ACC^5;
sbit ACC_4   =   ACC^4;
sbit ACC_3   =   ACC^3;
sbit ACC_2   =   ACC^2;
sbit ACC_1   =   ACC^1;
sbit ACC_0   =   ACC^0;

/* Definitions for B register  */
sbit B_7     =   B^7;
sbit B_6     =   B^6;
sbit B_5     =   B^5;
sbit B_4     =   B^4;
sbit B_3     =   B^3;
sbit B_2     =   B^2;
sbit B_1     =   B^1;
sbit B_0     =   B^0;
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/

/*-----------------------------------------------------------------
**	Peripheral memory map
------------------------------------------------------------------*/

/*-----------------------------------------------------------------
**IRQ 中断 
------------------------------------------------------------------*/
/*------IE--------------------------------------------------------*/
#define IRQ_IE_EA_Pos			  (7)
#define IRQ_IE_EA_Msk			  (0x1 << IRQ_IE_EA_Pos)
#define IRQ_IE_ES1_Pos			(6)
#define IRQ_IE_ES1_Msk			(0x1 << IRQ_IE_ES1_Pos)
#define IRQ_IE_ET2_Pos			(5)
#define IRQ_IE_ET2_Msk			(0x1 << IRQ_IE_ET2_Pos)
#define IRQ_IE_ES0_Pos			(4)
#define IRQ_IE_ES0_Msk			(0x1 << IRQ_IE_ES0_Pos)
#define IRQ_IE_ET1_Pos			(3)
#define IRQ_IE_ET1_Msk			(0x1 << IRQ_IE_ET1_Pos)
#define IRQ_IE_EX1_Pos			(2)
#define IRQ_IE_EX1_Msk			(0x1 << IRQ_IE_EX1_Pos)
#define IRQ_IE_ET0_Pos			(1)
#define IRQ_IE_ET0_Msk			(0x1 << IRQ_IE_ET0_Pos)
#define IRQ_IE_EX0_Pos			(0)
#define IRQ_IE_EX0_Msk			(0x1 << IRQ_IE_EX0_Pos)

/*------EIE2------------------------------------------------------*/
#define IRQ_EIE2_SPIIE_Pos		(7)
#define IRQ_EIE2_SPIIE_Msk		(0x1 << IRQ_EIE2_SPIIE_Pos)
#define IRQ_EIE2_I2CIE_Pos		(6)
#define IRQ_EIE2_I2CIE_Msk		(0x1 << IRQ_EIE2_I2CIE_Pos)
#define IRQ_EIE2_ADCIE_Pos		(4)
#define IRQ_EIE2_ADCIE_Msk		(0x1 << IRQ_EIE2_ADCIE_Pos)
#define IRQ_EIE2_PWMIE_Pos		(3)
#define IRQ_EIE2_PWMIE_Msk		(0x1 << IRQ_EIE2_PWMIE_Pos)
#define IRQ_EIE2_ET5IE_Pos		(2)
#define IRQ_EIE2_ET5IE_Msk		(0x1 << IRQ_EIE2_ET5IE_Pos)

/*------T2IE------------------------------------------------------*/
#define IRQ_T2IE_T2OVIE_Pos		(7)
#define IRQ_T2IE_T2OVIE_Msk		(0x1 << IRQ_T2IE_T2OVIE_Pos)
#define IRQ_T2IE_T2EXIE_Pos		(6)
#define IRQ_T2IE_T2EXIE_Msk		(0x1 << IRQ_T2IE_T2EXIE_Pos)
#define IRQ_T2IE_T2C1IE_Pos		(1)
#define IRQ_T2IE_T2C1IE_Msk		(0x1 << IRQ_T2IE_T2C1IE_Pos)
#define IRQ_T2IE_T2C0IE_Pos		(0)
#define IRQ_T2IE_T2C0IE_Msk		(0x1 << IRQ_T2IE_T2C0IE_Pos)

/*------EI0IE------------------------------------------------------*/
#define IRQ_EI0IE_EI0IE3_Pos		(3)
#define IRQ_EI0IE_EI0IE3_Msk		(0x1 << IRQ_EI0IE_EI0IE3_Pos)
#define IRQ_EI0IE_EI0IE2_Pos		(2)
#define IRQ_EI0IE_EI0IE2_Msk		(0x1 << IRQ_EI0IE_EI0IE2_Pos)
#define IRQ_EI0IE_EI0IE1_Pos		(1)
#define IRQ_EI0IE_EI0IE1_Msk		(0x1 << IRQ_EI0IE_EI0IE1_Pos)
#define IRQ_EI0IE_EI0IE0_Pos		(0)
#define IRQ_EI0IE_EI0IE0_Msk		(0x1 << IRQ_EI0IE_EI0IE0_Pos)

/*------EIF2------------------------------------------------------*/
#define IRQ_EIF2_SPIIF_Pos		(7)
#define IRQ_EIF2_SPIIF_Msk		(0x1 << IRQ_EIF2_SPIIF_Pos)
#define IRQ_EIF2_I2CIF_Pos		(6)
#define IRQ_EIF2_I2CIF_Msk		(0x1 << IRQ_EIF2_I2CIF_Pos)
#define IRQ_EIF2_ADCIF_Pos		(4)
#define IRQ_EIF2_ADCIF_Msk		(0x1 << IRQ_EIF2_ADCIF_Pos)
#define IRQ_EIF2_PWMIF_Pos		(3)
#define IRQ_EIF2_PWMIF_Msk		(0x1 << IRQ_EIF2_PWMIF_Pos)
#define IRQ_EIF2_TF5_Pos		  (2)
#define IRQ_EIF2_TF5_Msk		  (0x1 << IRQ_EIF2_TF5_Pos)

/*------T2IF------------------------------------------------------*/
#define IRQ_T2IF_T2F_Pos			(7)
#define IRQ_T2IF_T2F_Msk			(0x1 << IRQ_T2IF_T2F_Pos)
#define IRQ_T2IF_T2EXIF_Pos		(6)
#define IRQ_T2IF_T2EXIF_Msk		(0x1 << IRQ_T2IF_T2EXIF_Pos)
#define IRQ_T2IF_T2C1IF_Pos		(1)
#define IRQ_T2IF_T2C1IF_Msk		(0x1 << IRQ_T2IF_T2C1IF_Pos)
#define IRQ_T2IF_T2C0IF_Pos		(0)
#define IRQ_T2IF_T2C0IF_Msk		(0x1 << IRQ_T2IF_T2C0IF_Pos)

/*------EI0IF------------------------------------------------------*/
#define IRQ_EI0IF_EI0IF3_Pos		(3)
#define IRQ_EI0IF_EI0IF3_Msk		(0x1 << IRQ_EI0IF_EI0IF3_Pos)
#define IRQ_EI0IF_EI0IF2_Pos		(2)
#define IRQ_EI0IF_EI0IF2_Msk		(0x1 << IRQ_EI0IF_EI0IF2_Pos)
#define IRQ_EI0IF_EI0IF1_Pos		(1)
#define IRQ_EI0IF_EI0IF1_Msk		(0x1 << IRQ_EI0IF_EI0IF1_Pos)
#define IRQ_EI0IF_EI0IF0_Pos		(0)
#define IRQ_EI0IF_EI0IF0_Msk		(0x1 << IRQ_EI0IF_EI0IF0_Pos)

/*------INTFC------------------------------------------------------*/
#define IRQ_INTFC_INTSNUS1_Pos		(3)
#define IRQ_INTFC_INTSNUS1_Msk		(0x1 << IRQ_INTFC_INTSNUS1_Pos)
#define IRQ_INTFC_INTSNUS0_Pos		(2)
#define IRQ_INTFC_INTSNUS0_Msk		(0x1 << IRQ_INTFC_INTSNUS0_Pos)
#define IRQ_INTFC_INTSCKS1_Pos		(1)
#define IRQ_INTFC_INTSCKS1_Msk		(0x1 << IRQ_INTFC_INTSCKS1_Pos)
#define IRQ_INTFC_INTSCKS0_Pos		(0)
#define IRQ_INTFC_INTSCKS0_Msk		(0x1 << IRQ_INTFC_INTSCKS0_Pos)

/*-----------------------------------------------------------------
**LVD
------------------------------------------------------------------*/
/*------LVDCON----------------------------------------------------*/
#define LVD_LVDCON_LVDOUTBFILT_Pos	(3)
#define LVD_LVDCON_LVDOUTBFILT_Msk	(0x1 << LVD_LVDCON_LVDOUTBFILT_Pos)
#define LVD_LVDCON_LVDOUTB_Pos		  (2)
#define LVD_LVDCON_LVDOUTB_Msk		  (0x1 << LVD_LVDCON_LVDOUTB_Pos)
#define LVD_LVDCON_LVDINTE_Pos		  (1)
#define LVD_LVDCON_LVDINTE_Msk		  (0x1 << LVD_LVDCON_LVDINTE_Pos)
#define LVD_LVDCON_LVDINTF_Pos		  (0)
#define LVD_LVDCON_LVDINTF_Msk		  (0x1 << LVD_LVDCON_LVDINTF_Pos)

/*------LVDEICFG----------------------------------------------------*/
#define LVD_LVDEICFG_LVDSNUS_Pos		(6)
#define LVD_LVDEICFG_LVDSNUS_Msk		(0x3 << LVD_LVDEICFG_LVDSNUS_Pos)
#define LVD_LVDEICFG_LVDSCKS_Pos		(4)
#define LVD_LVDEICFG_LVDSCKS_Msk		(0x3 << LVD_LVDEICFG_LVDSCKS_Pos)
#define LVD_LVDEICFG_INTEDGE_Pos		(0)
#define LVD_LVDEICFG_INTEDGE_Msk		(0x3 << LVD_LVDEICFG_INTEDGE_Pos)

/*------LVDS----------------------------------------------------*/
#define LVD_LVDS_LVDSEN3_Pos				(7)
#define LVD_LVDS_LVDSEN3_Msk				(0x1 << LVD_LVDS_LVDSEN3_Pos)
#define LVD_LVDS_LVDSEN2_Pos				(6)
#define LVD_LVDS_LVDSEN2_Msk				(0x1 << LVD_LVDS_LVDSEN2_Pos)
#define LVD_LVDS_LVDSEN1_Pos				(5)
#define LVD_LVDS_LVDSEN1_Msk				(0x1 << LVD_LVDS_LVDSEN1_Pos)
#define LVD_LVDS_LVDSEN0_Pos				(4)
#define LVD_LVDS_LVDSEN0_Msk				(0x1 << LVD_LVDS_LVDSEN0_Pos)
#define LVD_LVDS_LVDSEGDR32_Pos			(2)
#define LVD_LVDS_LVDSEGDR32_Msk			(0x1 << LVD_LVDS_LVDSEGDR32_Pos)
#define LVD_LVDS_LVDSEGDR31_Pos			(1)
#define LVD_LVDS_LVDSEGDR31_Msk			(0x1 << LVD_LVDS_LVDSEGDR31_Pos)
#define LVD_LVDS_LVDSEGDR30_Pos			(0)
#define LVD_LVDS_LVDSEGDR30_Msk			(0x1 << LVD_LVDS_LVDSEGDR30_Pos)

/*-----------------------------------------------------------------
**System CLK  
------------------------------------------------------------------*/
/*------CKCON----------------------------------------------------*/
#define SYS_CKCON_U1M_Pos				   (4)
#define SYS_CKCON_U1M_Msk				   (0x1 << SYS_CKCON_U1M_Pos)
#define SYS_CKCON_U0M_Pos				   (3)
#define SYS_CKCON_U0M_Msk				   (0x1 << SYS_CKCON_U0M_Pos)
#define SYS_CKCON_T2M_Pos			     (2)
#define SYS_CKCON_T2M_Msk			     (0x1 << SYS_CKCON_T2M_Pos)
#define SYS_CKCON_T1M_Pos			     (1)
#define SYS_CKCON_T1M_Msk			     (0x1 << SYS_CKCON_T1M_Pos)
#define SYS_CKCON_T0M_Pos			     (0)
#define SYS_CKCON_T0M_Msk			     (0x1 << SYS_CKCON_T0M_Pos)
/*------XT_SCM----------------------------------------------------*/
#define SYS_XTSCM_SCMEN_Pos			   (7)
#define SYS_XTSCM_SCMEN_Msk			   (0x1 << SYS_XTSCM_SCMEN_Pos)
#define SYS_XTSCM_SCMIE_Pos			   (6)
#define SYS_XTSCM_SCMIE_Msk			   (0x1 << SYS_XTSCM_SCMIE_Pos)
#define SYS_XTSCM_SCMIF_Pos			   (1)
#define SYS_XTSCM_SCMIF_Msk			   (0x1 << SYS_XTSCM_SCMIF_Pos)
#define SYS_XTSCM_SCMSTA_Pos		   (0)
#define SYS_XTSCM_SCMSTA_Msk		   (0x1 << SYS_XTSCM_SCMSTA_Pos)
/*------PCGEN0----------------------------------------------------*/
#define SYS_PCGEN0_UART1EN_Pos	   (7)
#define SYS_PCGEN0_UART1EN_Msk	   (0x1 << SYS_PCGEN0_UART1EN_Pos)
#define SYS_PCGEN0_UART0EN_Pos	   (6)
#define SYS_PCGEN0_UART0EN_Msk	   (0x1 << SYS_PCGEN0_UART0EN_Pos)
#define SYS_PCGEN0_SPIEN_Pos		   (5)
#define SYS_PCGEN0_SPIEN_Msk		   (0x1 << SYS_PCGEN0_SPIEN_Pos)
#define SYS_PCGEN0_IICEN_Pos		   (4)
#define SYS_PCGEN0_IICEN_Msk		   (0x1 << SYS_PCGEN0_IICEN_Pos)
#define SYS_PCGEN0_WDTEN_Pos		   (3)
#define SYS_PCGEN0_WDTEN_Msk		   (0x1 << SYS_PCGEN0_WDTEN_Pos)
#define SYS_PCGEN0_TIMER5EN_Pos	   (2)
#define SYS_PCGEN0_TIMER5EN_Msk	   (0x1 << SYS_PCGEN0_TIMER5EN_Pos)
#define SYS_PCGEN0_TIMER2EN_Pos	   (1)
#define SYS_PCGEN0_TIMER2EN_Msk	   (0x1 << SYS_PCGEN0_TIMER2EN_Pos)
#define SYS_PCGEN0_TIMER01EN_Pos   (0)
#define SYS_PCGEN0_TIMER01EN_Msk   (0x1 << SYS_PCGEN0_TIMER01EN_Pos)

/*------PCGEN1----------------------------------------------------*/
#define SYS_PCGEN1_TOUCHEN_Pos	(6)
#define SYS_PCGEN1_TOUCHEN_Msk	(0x1 << SYS_PCGEN1_TOUCHEN_Pos)
#define SYS_PCGEN1_LEDEN_Pos	  (5)
#define SYS_PCGEN1_LEDEN_Msk	  (0x1 << SYS_PCGEN1_LEDEN_Pos)
#define SYS_PCGEN1_ADCEN_Pos	  (4)
#define SYS_PCGEN1_ADCEN_Msk	  (0x1 << SYS_PCGEN1_ADCEN_Pos)
#define SYS_PCGEN1_PWMEN_Pos	  (2)
#define SYS_PCGEN1_PWMEN_Msk	  (0x1 << SYS_PCGEN1_PWMEN_Pos)
#define SYS_PCGEN1_LVDEN_Pos	  (1)
#define SYS_PCGEN1_LVDEN_Msk	  (0x1 << SYS_PCGEN1_LVDEN_Pos)
#define SYS_PCGEN1_BRTEN_Pos	  (0)
#define SYS_PCGEN1_BRTEN_Msk	  (0x1 << SYS_PCGEN1_BRTEN_Pos)

/*------PCON------------------------------------------------------*/
#define SYS_PCON_STOP_Pos			(1)
#define SYS_PCON_STOP_Msk			(0x1 << SYS_PCON_STOP_Pos)
#define SYS_PCON_IDLE_Pos			(0)
#define SYS_PCON_IDLE_Msk			(0x1 << SYS_PCON_IDLE_Pos)

/*-----------------------------------------------------------------
**WDT
------------------------------------------------------------------*/
/*------WDCON-----------------------------------------------------*/
#define WDT_WDCON_WTS2_Pos			(6)
#define WDT_WDCON_WTS2_Msk			(0x1 << WDT_WDCON_WTS2_Pos)
#define WDT_WDCON_WTS1_Pos			(5)
#define WDT_WDCON_WTS1_Msk			(0x1 << WDT_WDCON_WTS1_Pos)
#define WDT_WDCON_WTS0_Pos			(4)
#define WDT_WDCON_WTS0_Msk			(0x1 << WDT_WDCON_WTS0_Pos)

/*-----------------------------------------------------------------
**Timer
------------------------------------------------------------------*/
/*------TMOD------------------------------------------------------*/
#define TMR_TMOD_GATE1_Pos			(7)
#define TMR_TMOD_GATE1_Msk			(0x1 << TMR_TMOD_GATE1_Pos)
#define TMR_TMOD_CT1_Pos				(6)
#define TMR_TMOD_CT1_Msk				(0x1 << TMR_TMOD_CT1_Pos)
#define TMR_TMOD_T1Mn_Pos				(4)
#define TMR_TMOD_T1Mn_Msk				(0x3 << TMR_TMOD_T1Mn_Pos)
#define TMR_TMOD_GATE0_Pos			(3)
#define TMR_TMOD_GATE0_Msk			(0x1 << TMR_TMOD_GATE0_Pos)
#define TMR_TMOD_CT0_Pos				(2)
#define TMR_TMOD_CT0_Msk				(0x1 << TMR_TMOD_CT0_Pos)
#define TMR_TMOD_T0Mn_Pos				(0)
#define TMR_TMOD_T0Mn_Msk				(0x3 << TMR_TMOD_T0Mn_Pos)
/*------TCON------------------------------------------------------*/
#define TMR_TCON_TF1_Pos				(7)
#define TMR_TCON_TF1_Msk				(0x1 << TMR_TCON_TF1_Pos)
#define TMR_TCON_TR1_Pos				(6)
#define TMR_TCON_TR1_Msk				(0x1 << TMR_TCON_TR1_Pos)
#define TMR_TCON_TF0_Pos				(5)
#define TMR_TCON_TF0_Msk				(0x1 << TMR_TCON_TF0_Pos)
#define TMR_TCON_TR0_Pos				(4)
#define TMR_TCON_TR0_Msk				(0x1 << TMR_TCON_TR0_Pos)
#define TMR_TCON_IE1_Pos				(3)
#define TMR_TCON_IE1_Msk				(0x1 << TMR_TCON_IE1_Pos)
#define TMR_TCON_IT1_Pos				(2)
#define TMR_TCON_IT1_Msk				(0x1 << TMR_TCON_IT1_Pos)
#define TMR_TCON_IE0_Pos				(1)
#define TMR_TCON_IE0_Msk				(0x1 << TMR_TCON_IE0_Pos)
#define TMR_TCON_IT0_Pos				(0)
#define TMR_TCON_IT0_Msk				(0x1 << TMR_TCON_IT0_Pos)

/*------T2CON-----------------------------------------------------*/
#define TMR_T2CON_T2PS_Pos				(7)
#define TMR_T2CON_T2PS_Msk				(0x1 << TMR_T2CON_T2PS_Pos)
#define TMR_T2CON_I3FR_Pos				(6)
#define TMR_T2CON_I3FR_Msk				(0x1 << TMR_T2CON_I3FR_Pos)
#define TMR_T2CON_CAPES_Pos				(5)
#define TMR_T2CON_CAPES_Msk				(0x1 << TMR_T2CON_CAPES_Pos)
#define TMR_T2CON_T2Rn_Pos				(3)
#define TMR_T2CON_T2Rn_Msk				(0x3 << TMR_T2CON_T2Rn_Pos)
#define TMR_T2CON_T2CM_Pos				(2)
#define TMR_T2CON_T2CM_Msk				(0x1 << TMR_T2CON_T2CM_Pos)
#define TMR_T2CON_T2In_Pos				(0)
#define TMR_T2CON_T2In_Msk				(0x3 << TMR_T2CON_T2In_Pos)

/*------CCEN------------------------------------------------------*/
#define TMR_CCEN_CMn1_Pos				(2)
#define TMR_CCEN_CMn1_Msk				(0x3 << TMR_CCEN_CMn1_Pos)
#define TMR_CCEN_CMn0_Pos				(0)
#define TMR_CCEN_CMn0_Msk				(0x3 << TMR_CCEN_CMn0_Pos)

/*------T5CON-----------------------------------------------------*/
#define TMR_T5CON_T5E_Pos				(7)
#define TMR_T5CON_T5E_Msk				(0x1 << TMR_T5CON_T5E_Pos)
#define TMR_T5CON_I5WUE_Pos			(6)
#define TMR_T5CON_I5WUE_Msk			(0x1 << TMR_T5CON_I5WUE_Pos)
#define TMR_T5CON_T5CKSn_Pos		(4)
#define TMR_T5CON_T5CKSn_Msk		(0x3 << TMR_T5CON_T5CKSn_Pos)
#define TMR_T5CON_T5PSCn_Pos		(0)
#define TMR_T5CON_T5PSCn_Msk		(0x7 << TMR_T5CON_T5PSCn_Pos)

/*-----------------------------------------------------------------
**PWM  
------------------------------------------------------------------*/
/*------PWMCON----------------------------------------------------*/
#define PWM_PWMCON_PWMRUN_Pos		  (6)
#define PWM_PWMCON_PWMRUN_Msk		  (0x1 << PWM_PWMCON_PWMRUN_Pos)
#define PWM_PWMCON_PWMMODEn_Pos		(4)
#define PWM_PWMCON_PWMMODEn_Msk		(0x3 << PWM_PWMCON_PWMMODEn_Pos)
#define PWM_PWMCON_GROUPEN_Pos		(3)
#define PWM_PWMCON_GROUPEN_Msk		(0x1 << PWM_PWMCON_GROUPEN_Pos)
/*------PWMDTE----------------------------------------------------*/
#define PWM_PWMDTE_PWM45DTE_Pos		(2)
#define PWM_PWMDTE_PWM45DTE_Msk		(0x1 << PWM_PWMDTE_PWM45DTE_Pos)
#define PWM_PWMDTE_PWM23DTE_Pos		(1)
#define PWM_PWMDTE_PWM23DTE_Msk		(0x1 << PWM_PWMDTE_PWM23DTE_Pos)
#define PWM_PWMDTE_PWM01DTE_Pos		(0)
#define PWM_PWMDTE_PWM01DTE_Msk		(0x1 << PWM_PWMDTE_PWM01DTE_Pos)

/*-----------------------------------------------------------------
**LED
------------------------------------------------------------------*/
/*------LEDCON----------------------------------------------------*/
#define LED_LEDCON_EN_Pos			    (7)
#define LED_LEDCON_EN_Msk			    (0x1 << LED_LEDCON_EN_Pos)
#define LED_LEDCON_DUTY_Pos			  (5)
#define LED_LEDCON_DUTY_Msk			  (0x3 << LED_LEDCON_DUTY_Pos)
#define LED_LEDCON_CCCA_Pos			  (4)
#define LED_LEDCON_CCCA_Msk			  (0x1 << LED_LEDCON_CCCA_Pos)
#define LED_LEDCON_FIXCLKEN_Pos		(2)
#define LED_LEDCON_FIXCLKEN_Msk		(0x1 << LED_LEDCON_FIXCLKEN_Pos)
/*------LEDCKS----------------------------------------------------*/
#define LED_LEDCKS_DTSELn_Pos			(4)
#define LED_LEDCKS_DTSELn_Msk			(0x3 << LED_LEDCKS_DTSELn_Pos)
#define LED_LEDCKS_CLKn_Pos			  (0)
#define LED_LEDCKS_CLKn_Msk			  (0x3 << LED_LEDCKS_CLKn_Pos)
/*------LEDDRV----------------------------------------------------*/
#define LED_LEDDRV_SDRCn_Pos			(0)
#define LED_LEDDRV_SDRCn_Msk			(0xF << LED_LEDDRV_SDRCn_Pos)
//dot matrix
/*------LEDCON1----------------------------------------------------*/
#define LED_LEDCON1_SSTART_Pos		(7)
#define LED_LEDCON1_SSTART_Msk		(0x1 << LED_LEDCON1_SSTART_Pos)
#define LED_LEDCON1_DUTY_Pos		  (4)
#define LED_LEDCON1_DUTY_Msk		  (0x7 << LED_LEDCON1_DUTY_Pos)
#define LED_LEDCON1_SMODE_Pos		  (3)
#define LED_LEDCON1_SMODE_Msk		  (0x1 << LED_LEDCON1_SMODE_Pos)
#define LED_LEDCON1_FIXCLKEN_Pos	(2)
#define LED_LEDCON1_FIXCLKEN_Msk	(0x1 << LED_LEDCON1_FIXCLKEN_Pos)
/*------LEDSTATUS----------------------------------------------------*/
#define LED_LEDSTATUS_LEDIE_Pos		(1)
#define LED_LEDSTATUS_LEDIE_Msk		(0x1 << LED_LEDSTATUS_LEDIE_Pos)
#define LED_LEDSTATUS_LEDIF_Pos		(0)
#define LED_LEDSTATUS_LEDIF_Msk		(0x1 << LED_LEDSTATUS_LEDIF_Pos)
/*-----------------------------------------------------------------
**SPI
------------------------------------------------------------------*/
/*------SPCR------------------------------------------------------*/
#define SPI_SPCR_SPEN_Pos			(6)
#define SPI_SPCR_SPEN_Msk			(0x1 << SPI_SPCR_SPEN_Pos)
#define SPI_SPCR_SPR2_Pos			(5)
#define SPI_SPCR_SPR2_Msk			(0x1 << SPI_SPCR_SPR2_Pos)
#define SPI_SPCR_MSTR_Pos			(4)
#define SPI_SPCR_MSTR_Msk			(0x1 << SPI_SPCR_MSTR_Pos)
#define SPI_SPCR_CPOL_Pos			(3)
#define SPI_SPCR_CPOL_Msk			(0x1 << SPI_SPCR_CPOL_Pos)
#define SPI_SPCR_CPHA_Pos			(2)
#define SPI_SPCR_CPHA_Msk			(0x1 << SPI_SPCR_CPHA_Pos)
#define SPI_SPCR_SPRn_Pos			(0)
#define SPI_SPCR_SPRn_Msk			(0x3 << SPI_SPCR_SPRn_Pos)

/*------SSCR------------------------------------------------------*/
#define SPI_SSCR_NSSO0_Pos			(0)
#define SPI_SSCR_NSSO0_Msk			(0x1 << SPI_SSCR_NSSO0_Pos)

/*------SPSR------------------------------------------------------*/
#define SPI_SPSR_SPISIF_Pos		(7)
#define SPI_SPSR_SPISIF_Msk		(0x1 << SPI_SPSR_SPISIF_Pos)
#define SPI_SPSR_WCOL_Pos			(6)
#define SPI_SPSR_WCOL_Msk			(0x1 << SPI_SPSR_WCOL_Pos)
#define SPI_SPSR_SSCEN_Pos		(0)
#define SPI_SPSR_SSCEN_Msk		(0x1 << SPI_SPSR_SSCEN_Pos)
/*-----------------------------------------------------------------
**I2C
------------------------------------------------------------------*/
/*------I2CMCR----------------------------------------------------*/
#define I2C_CON_IE_Pos			  (7)
#define I2C_CON_IE_Msk			  (0x1 << I2C_CON_IE_Pos)
#define I2C_CON_EN_Pos			  (6)
#define I2C_CON_EN_Msk			  (0x1 << I2C_CON_EN_Pos)
#define I2C_CON_STA_Pos			  (5)
#define I2C_CON_STA_Msk			  (0x1 << I2C_CON_STA_Pos)
#define I2C_CON_STO_Pos		    (4)
#define I2C_CON_STO_Msk		    (0x1 << I2C_CON_STO_Pos)
#define I2C_CON_SI_Pos			  (3)
#define I2C_CON_SI_Msk			  (0x1 << I2C_CON_SI_Pos)
#define I2C_CON_AA_Pos			  (2)
#define I2C_CON_AA_Msk			  (0x1 << I2C_CON_AA_Pos)
#define I2C_CON_XADRF_Pos			(1)
#define I2C_CON_XADRF_Msk			(0x1 << I2C_CON_XADRF_Pos)
#define I2C_CON_ADRF_Pos			(0)
#define I2C_CON_ADRF_Msk			(0x1 << I2C_CON_ADRF_Pos)
/*------I2CCLR----------------------------------------------------*/
#define I2C_CLR_IE_Pos		  (7)
#define I2C_CLR_IE_Msk		  (0x1 << I2C_CLR_IE_Pos)
#define I2C_CLR_EN_Pos		  (6)
#define I2C_CLR_EN_Msk		  (0x1 << I2C_CLR_EN_Pos)
#define I2C_CLR_STAC_Pos		(5)
#define I2C_CLR_STAC_Msk		(0x1 << I2C_CLR_STAC_Pos)
#define I2C_CLR_SIC_Pos		  (3)
#define I2C_CLR_SIC_Msk		  (0x1 << I2C_CLR_SIC_Pos)
#define I2C_CLR_AAC_Pos		  (2)
#define I2C_CLR_AAC_Msk		  (0x1 << I2C_CLR_AAC_Pos)
/*------I2CCLK----------------------------------------------------*/
#define I2C_CLK_Mn_Pos		  (4)
#define I2C_CLK_Mn_Msk		  (0x7 << I2C_CLK_Mn_Pos)
#define I2C_CLK_Nn_Pos		  (0)
#define I2C_CLK_Nn_Msk		  (0xF << I2C_CLK_Nn_Pos)
/*------I2CXAR----------------------------------------------------*/
#define I2C_XAR_RST_Pos		  (7)
#define I2C_XAR_RST_Msk		  (0x1 << I2C_XAR_RST_Pos)
#define I2C_XAR_GCF_Pos		  (6)
#define I2C_XAR_GCF_Msk		  (0x1 << I2C_XAR_GCF_Pos)
#define I2C_XAR_XADRn_Pos		(0)
#define I2C_XAR_XADRn_Msk		(0x7 << I2C_XAR_XADRn_Pos)
/*-----------------------------------------------------------------
**UART
------------------------------------------------------------------*/
/*------SCON0------------------------------------------------------*/
#define UART_SCON0_U0SMn_Pos			(6)
#define UART_SCON0_U0SMn_Msk			(0x3 << UART_SCON0_U0SMn_Pos)
#define UART_SCON0_U0SM2_Pos			(5)
#define UART_SCON0_U0SM2_Msk			(0x1 << UART_SCON0_U0SM2_Pos)
#define UART_SCON0_U0REN_Pos			(4)
#define UART_SCON0_U0REN_Msk			(0x1 << UART_SCON0_U0REN_Pos)
#define UART_SCON0_U0TB8_Pos			(3)
#define UART_SCON0_U0TB8_Msk			(0x1 << UART_SCON0_U0TB8_Pos)
#define UART_SCON0_U0RB8_Pos			(2)
#define UART_SCON0_U0RB8_Msk			(0x1 << UART_SCON0_U0RB8_Pos)
#define UART_SCON0_TI0_Pos				(1)
#define UART_SCON0_TI0_Msk				(0x1 << UART_SCON0_TI0_Pos)
#define UART_SCON0_RI0_Pos				(0)
#define UART_SCON0_RI0_Msk				(0x1 << UART_SCON0_RI0_Pos)
/*------SCON1------------------------------------------------------*/
#define UART_SCON1_U1SMn_Pos			(6)
#define UART_SCON1_U1SMn_Msk			(0x3 << UART_SCON1_U1SMn_Pos)
#define UART_SCON1_U1SM2_Pos			(5)
#define UART_SCON1_U1SM2_Msk			(0x1 << UART_SCON1_U1SM2_Pos)
#define UART_SCON1_U1REN_Pos			(4)
#define UART_SCON1_U1REN_Msk			(0x1 << UART_SCON1_U1REN_Pos)
#define UART_SCON1_U1TB8_Pos			(3)
#define UART_SCON1_U1TB8_Msk			(0x1 << UART_SCON1_U1TB8_Pos)
#define UART_SCON1_U1RB8_Pos			(2)
#define UART_SCON1_U1RB8_Msk			(0x1 << UART_SCON1_U1RB8_Pos)
#define UART_SCON1_TI1_Pos				(1)
#define UART_SCON1_TI1_Msk				(0x1 << UART_SCON1_TI1_Pos)
#define UART_SCON1_RI1_Pos				(0)
#define UART_SCON1_RI1_Msk				(0x1 << UART_SCON1_RI1_Pos)

/*-----------------------------------------------------------------
**ADC  
------------------------------------------------------------------*/
/*------ADCON0----------------------------------------------------*/
#define ADC_ADCON0_ADCKSn_Pos		(4)
#define ADC_ADCON0_ADCKSn_Msk		(0x7 << ADC_ADCON0_ADCKSn_Pos)
#define ADC_ADCON0_ADGO_Pos			(1)
#define ADC_ADCON0_ADGO_Msk			(0x1 << ADC_ADCON0_ADGO_Pos)
/*------ADCON1----------------------------------------------------*/
#define ADC_ADCON1_ADEN_Pos			(7)
#define ADC_ADCON1_ADEN_Msk			(0x1 << ADC_ADCON1_ADEN_Pos)
#define ADC_ADCON1_ADVSEL_Pos		(6)
#define ADC_ADCON1_ADVSEL_Msk		(0x1 << ADC_ADCON1_ADVSEL_Pos)
#define ADC_ADCON1_ADCHSn_Pos		(0)
#define ADC_ADCON1_ADCHSn_Msk		(0x3F << ADC_ADCON1_ADCHSn_Pos)
/*------ADCLDO----------------------------------------------------*/
#define ADC_ADCLDO_LDOEN_Pos		(7)
#define ADC_ADCLDO_LDOEN_Msk		(0x1 << ADC_ADCLDO_LDOEN_Pos)

/*-----------------------------------------------------------------
**FLASH
------------------------------------------------------------------*/
/*------MSTATUS---------------------------------------------------*/
#define FLASH_MSTATUS_MLOCKF_Pos		(7)
#define FLASH_MSTATUS_MLOCKF_Msk		(0x1 << FLASH_MSTATUS_MLOCKF_Pos)
#define FLASH_MSTATUS_ERROR_Pos		(6)
#define FLASH_MSTATUS_ERROR_Msk		(0x1 << FLASH_MSTATUS_ERROR_Pos)
#define FLASH_MSTATUS_RDINC_Pos	  (4)
#define FLASH_MSTATUS_RDINC_Msk	  (0x1 << FLASH_MSTATUS_RDINC_Pos)
#define FLASH_MSTATUS_START_Pos		(3)
#define FLASH_MSTATUS_START_Msk		(0x1 << FLASH_MSTATUS_START_Pos)

/*-----------------------------------------------------------------
**中断优先级模块编号 Priority Module Number
------------------------------------------------------------------*/
typedef enum  en_Priority_Module{
	IRQ_EXTINT0	 =0,
	IRQ_TMR0	   =1,
	IRQ_EXTINT1	 =2,
	IRQ_TMR1	   =3,
	IRQ_UART0	   =4,
	IRQ_TMR2	   =5,
	IRQ_UART1	   =6,		
	IRQ_EINT     =8,
	IRQ_TMR5	   =18,	
	IRQ_PWM		   =19,
	IRQ_ADC 	   =20,
	IRQ_I2C  	   =22,
	IRQ_SPI  	   =23,
	IRQ_LED		   =26,		
	IRQ_LVD	     =27,
	IRQ_TOUCH	   =28,
  IRQ_XTDET	   =31,		
}en_Priority_Module_t;

/*-----------------------------------------------------------------
**中断优先级 IRQPriority
------------------------------------------------------------------*/
#define  IRQ_PRIORITY_LOW		(0x00)
#define  IRQ_PRIORITY_HIGH		(0x01)	

/********************************************************************************
 ** \brief	 IRQ_SET_PRIORITY
 **			 设置中断优先级
 ** \param [in] IRQ_Module:en_Priority_Module_t
 ** \param [in] IRQPriority:IRQ_PRIORITY_LOW,IRQ_PRIORITY_HIGH
 ** \return  none
 ******************************************************************************/
#define  IRQ_SET_PRIORITY(IRQ_Module, IRQPriority)  do{\
														if(IRQ_Module <8)\
														{\
															IP &= ~(1<< IRQ_Module);\
															IP |=(IRQPriority<< IRQ_Module);\
														}\
														else if(IRQ_Module <16)\
														{\
															EIP1 &= ~(1<< (IRQ_Module-8));\
															EIP1 |= (IRQPriority<< (IRQ_Module-8));\
														}\
														else if(IRQ_Module <24)\
														{\
															EIP2 &= ~(1<< (IRQ_Module-16));\
															EIP2 |=(IRQPriority<< (IRQ_Module-16));\
														}\
														else if(IRQ_Module <32)\
														{\
															EIP3 &= ~(1<< (IRQ_Module-24));\
															EIP3 |=(IRQPriority<< (IRQ_Module-24));\														
														}\
													}while(0)

/********************************************************************************
 ** \brief	 IRQ_ALL_ENABLE
 **			 使能总中断
 ** \param [in] none
 ** \return  none
 ******************************************************************************/
#define  IRQ_ALL_ENABLE()		do{\
									EA =1;\
								  }while(0)
/********************************************************************************
 ** \brief	 IRQ_ALL_DISABLE
 **			 关闭总中断
 ** \param [in] none
 ** \return  none
 ******************************************************************************/
#define  IRQ_ALL_DISABLE()		do{\
									EA =0;\
									_nop_();\
								  }while(0)
								

/*---------中断向量表---------------------------------------------------------
 **   interrupt vector all 28
------------------------------------------------------------------------------*/
 #define         EXTINT0_VECTOR		0
 #define         TMR0_VECTOR		  1
 #define         EXTINT1_VECTOR	  2
 #define         TMR1_VECTOR   	  3
 #define         UART0_VECTOR     4
 #define         TMR2_VECTOR		  5
 #define         UART1_VECTOR     6							  
 #define         EINT_VECTOR	    7									  
 #define         XTDET_VECTOR		  12									  
 #define         TMR5_VECTOR		  17
 #define         PWM_VECTOR			  18	
 #define         ADC_VECTOR   	  19									
 #define         I2C_VECTOR			  21									
 #define         SPI_VECTOR			  22	
 #define         LED_VECTOR			  25									  
 #define         LVD_VECTOR			  26	
 #define         TOUCH_VECTOR		  27	
						  
							  
								  								  
/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/
//extern  uint32_t  SystemClock;
/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
#include "system.h"
#include "gpio.h"
#include "wdt.h"
#include "adc.h"
#include "pwm.h"
#include "extint.h"
#include "flash.h"
#include "i2c.h"
#include "spi.h"
#include "timer.h"
#include "uart.h"
#include "crc.h"
#include "led.h"

#endif /* _CMS80F752X_H_ */

