/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_uart.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_uart.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/
#define  UARTx_BUAD_USE_BRT      1
#define  UARTx_BUAD_USE_TMR1     2

#define  UARTx_BUAD_USE_SEL      UARTx_BUAD_USE_BRT

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

uint32_t Systemclock = 48000000;

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/
/******************************************************************************
 ** \brief	 UART0_Config
 ** \param [in] 
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
void UART0_Config(void)
{

#if ( UARTx_BUAD_USE_BRT == UARTx_BUAD_USE_SEL)		//ʹBRTΪUARTģĲʱӷ
	 uint16_t  BRTValue = 0;
	 uint32_t  BaudRateVlue = 9600;
	
	 SYS_EnablePeripheralClk0(SYS_CLK0_UART0_MSK);
	 SYS_EnablePeripheralClk1(SYS_CLK1_BRT_MSK);
	 /*
	 (1)UARTxģʽ
	 */
	 UART_ConfigRunMode(UART0,UART_MOD_ASY_8BIT, UART_BAUD_BRT);
	 UART_EnableReceive(UART0);
	 /*
	 (2)UARTxĲ
	 */		
  #ifdef USE_FORMULA			//ʹùʽ㶨ʱļֵ(ҪSystemclockֵ(main.c))USE_FORMULA  ѡOption->C51->Preporcessor Symbols->Defineж
	 BRTValue = UART_ConfigBaudRate(UART0, BaudRateVlue) ;
  #else 
	 BRTValue = 312; 				//ʹòοֲƼļֵ(BRT½),Ӧϵͳʱӣ48MHz
  #endif
 
	 UART_ConfigBRTPeriod(BRTValue);										 /*װֵ*/
	 UART_EnableBRT();										       				 /*ʹܶʱ*/
	 /*
	 (3)IO
	 */ 	 
	 GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_4);
	 GPIO_ENABLE_OUTPUT(P1TRIS,GPIO_PIN_4);
	 GPIO_SET_PS_MODE(PS_TXD0, GPIO_UART0TXD_MUX_P14);	 /*TXD0ѡP14*/
	 
	 GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_5);
	 GPIO_ENABLE_INPUT(P1TRIS,GPIO_PIN_5);
	 GPIO_SET_PS_MODE(PS_RXD0, GPIO_UART0RXD_MUX_P15);	 /*RXD0ѡP15*/
#elif ( UARTx_BUAD_USE_TMR1 == UARTx_BUAD_USE_SEL)		 //ʹTMR1ΪUARTģĲʱӷ

	 uint8_t  THxValue = 0;
	 uint32_t  BaudRateVlue = 9600;	 
	 	 
	 SYS_EnablePeripheralClk0(SYS_CLK0_UART0_MSK);
	 SYS_EnablePeripheralClk0(SYS_CLK0_TIMER01_MSK);
	/*
	 (1)UARTxģʽ
	 */
	 UART_ConfigRunMode(UART0,UART_MOD_ASY_8BIT, UART_BAUD_TMR1);
	 UART_EnableReceive(UART0);
	/*
	 (2)UARTxĲ
	 */
	 TMR_ConfigTimerClk(TMR1,TMR_CLK_DIV_4);				/*TM =1*/
	 TMR_ConfigRunMode(TMR1, TMR_MODE_TIMING, TMR_TIM_AUTO_8BIT); /*Ϊ8λװģʽ*/
	
  #ifdef USE_FORMULA			//ʹùʽ㶨ʱļֵ(ҪSystemclockֵ(main.c))USE_FORMULA  ѡOption->C51->Preporcessor Symbols->Defineж
	 THxValue = UART_ConfigBaudRate(UART0, BaudRateVlue) ;
  #else 
	 THxValue = 178; 				//ʹֲƼļֵ(UART½),Ӧϵͳʱӣ48MHz
  #endif
  
	 TMR_ConfigTimerPeriod(TMR1, THxValue, 0);			/*װֵ*/
	 TMR_Start(TMR1);											          /*ʹܶʱ*/
	
	 /*
	 (3)IO
	 */	 
	 GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_4);
	 GPIO_ENABLE_OUTPUT(P1TRIS,GPIO_PIN_4);
	 GPIO_SET_PS_MODE(PS_TXD0, GPIO_UART0TXD_MUX_P14);					  /*TXD0ѡP14*/
	 
	 GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_5);
	 GPIO_ENABLE_INPUT(P1TRIS,GPIO_PIN_5);
	 GPIO_SET_PS_MODE(PS_RXD0, GPIO_UART0RXD_MUX_P15);					  /*RXD0ѡP15*/

#endif
	 /*
	 (4)UARTж
	 */
	 UART_EnableInt(UART0);
	 IRQ_SET_PRIORITY(IRQ_UART0,IRQ_PRIORITY_LOW);

}



/******************************************************************************
 ** \brief	 putchar
 ** \param [in] data
 **            	
 ** \return  none
 ** \note   <stdio.h>Ҫĺ
 ******************************************************************************/
char putchar (char ch)
{
	SBUF0 = ch;
	while( !(SCON0 & (1<<1)));
	SCON0 &=~(1<<1);		
	return 0;
}

/******************************************************************************
 ** \brief	 putchar
 ** \param [in] none
 **            	
 ** \return  data
 ** \note   <stdio.h>Ҫĺ
 ******************************************************************************/
char getchar (void)
{
	while(!(SCON0 & (1<<0)));
	SCON0 &=~(1<<0);
	return  SBUF0;	
}
/********************************************************************************
 ** \brief	 puts 
 **
 ** \param [in]  bytes addr for sending
 **
 ** \return  <stdio.h>Ҫĺ
 ******************************************************************************/
int  puts( const char  * s)
{
	while(*(s ++))
		putchar(*s);
	return 0;
}






