/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_spi.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_spi.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/


/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/*****************************************************************************
 ** \brief	SPI_Transmit
 **			
** \param [in] SendData: ͵ֵ
 ** \return  16bit ȡֵ
 ** \note	
*****************************************************************************/
uint8_t  SPI_Transmit(uint8_t  Data)
{	
	SPDR = Data;
	while(!SPI_GetTransferIntFlag());
	return (SPDR);				
}
/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/
/******************************************************************************
 ** \brief	 SPI_Config
 ** \param [in] 
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
void SPI_Config(void)
{
	SYS_EnablePeripheralClk0(SYS_CLK0_SPI_MSK);
	/*
	(1)SPIʱ
	*/
	SPI_ConfigClk(SPI_CLK_DIV_512);									/*ʱ*/
	/*
	(2)SPIģʽ
	*/
	SPI_ConfigRunMode(SPI_CLK_CPOL_LOW, SPI_CLK_CPHA_0, SPI_NSS_SSCR_CONTROL);/*SPI ʱʱΪ͵ƽλѡCPHA = 0 */
																	/*SPI NSSxźSSCRеݿ*/																							
	/*
	(3)IOڸ
	*/
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_0);		/*SCLK*/
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_2);		/*MISO*/
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_1);		/*MOSI*/
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_3);		/*CS*/	
	
	GPIO_ENABLE_INPUT(P0TRIS,GPIO_PIN_1);
	GPIO_ENABLE_INPUT(P1TRIS,GPIO_PIN_0);
	GPIO_ENABLE_OUTPUT(P1TRIS,GPIO_PIN_2);
	GPIO_ENABLE_INPUT(P1TRIS,GPIO_PIN_3);
	
	GPIO_SET_PS_MODE(PS_SCLKOI,GPIO_SPISCLK_MUX_P10);
	GPIO_SET_PS_MODE(PS_MISO,GPIO_SPIMISO_MUX_P12);
	GPIO_SET_PS_MODE(PS_MOSI,GPIO_SPIMOSI_MUX_P01);
	GPIO_SET_PS_MODE(PS_NSS0OI,GPIO_SPINSS0_MUX_P13);
	
	/*
	(4)SPIorӻģʽ
	*/
	SPI_EnableSlaveMode();	
	
		/*
	(5)жϷʽ
	*/
	SPI_EnableIntFlag();
	/*
	(6)жȼ
	*/
	IRQ_SET_PRIORITY(IRQ_SPI, IRQ_PRIORITY_LOW);
	/*
	(7)ж
	*/	
	IRQ_ALL_ENABLE();	
	
	/*
	(8)SPI
	*/
	SPI_Start();
}









