/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_timer.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_timer.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/
/******************************************************************************
** \brief	 TMR5_Config
** \param [in] 
**            	
** \return  none
** \note  
******************************************************************************/
void TMR5_Config(void)
{
	SYS_EnablePeripheralClk0(SYS_CLK0_TIMER5_MSK);
	/*
	(1)设置Timer5唤醒模式
	*/
	TMR5_EnableWakeUp();
	/*
	(2)设置Timer5运行时钟
	*/
	TMR5_CLK_Select(TMR5_CLKSR_LSI); //选择内部LSI作为时钟源		
	TMR5_FRQ_Set(TMR5_FRQ_DIV1);		 //选择1分频
	/*
	(3)设置Timer5周期
	*/	
	TMR5_ConfigPeriod(59999);  	     // (59999+1)*TMR5clk,从0开始递增计数	
	/*
	(4)开启中断
	*/
	TMR5_INT_Enable();
	/*
	(5)设置Timer5中断优先级
	*/	
	IRQ_SET_PRIORITY(IRQ_TMR5,IRQ_PRIORITY_LOW);
	IRQ_ALL_ENABLE();	
	/*
	(6)开启Timer5
	*/
	TMR5_Start();
}




























