/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_eint.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_eint.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/******************************************************************************
 ** \brief	 EINTx_Config
 ** \param [in] 
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
void EINTx_Config(void)
{
	/*
	(1)设置EXTINT功能
	*/
	GPIO_EINTx_Trig(EINT00, GPIO_INT_FALLING);			  //扩展外部下降沿触发中断
	/*
	(2)设置EXTINT IO口
	*/	
	GPIO_SET_PS_MODE(PS_EINT0,GPIO_P06);						//选择P06为扩展中断A的输入口
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_6);			    //设置P06为GPIO模式
	GPIO_ENABLE_INPUT(P0TRIS, GPIO_PIN_6);				  //设置为输入模式	
	GPIO_ENABLE_UP(P0UP, GPIO_PIN_6);					      //开启P06上拉  					
	/*
	(3)设置EXTINT中断
	*/		
	GPIO_EINTx_Enable(EINT00);
	IRQ_SET_PRIORITY(IRQ_EINT, IRQ_PRIORITY_HIGH);
	IRQ_ALL_ENABLE();							 									//开启总中断
}
























