/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_pwm.c
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_pwm.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/


/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/******************************************************************************
** \brief	 PWM_Config (complementary, no dead time)
** \param [in] 
**            	
** \return  none
** \note  
******************************************************************************/
void PWM_Config(void)
{
	SYS_EnablePeripheralClk1(SYS_CLK1_PWM_MSK);
	//PWMģʽ
	PWM_ConfigRunMode(PWM_WFG_COMPLEMENTARY|PWM_OC_INDEPENDENT); //ģʽ+ģʽ
	//PWMʱ	
	PWM_ConfigChannelClk(PWM0, PWM_CLK_DIV_1);		
	PWM_ConfigChannelClk(PWM2, PWM_CLK_DIV_1);
	PWM_ConfigChannelClk(PWM4, PWM_CLK_DIV_1);
	//PWM Լռձ	
	PWM_ConfigChannelPeriod(PWM0, 0x12C0);
	PWM_ConfigChannelPeriod(PWM2, 0x12C0);
	PWM_ConfigChannelPeriod(PWM4, 0x12C0);

	PWM_ConfigChannelDuty(PWM0, 0x0960);
	PWM_ConfigChannelDuty(PWM2, 0x0960);
	PWM_ConfigChannelDuty(PWM4, 0x0960);


	//PWMļطʽΪԶ
	PWM_EnableAutoLoadMode(PWM_CH_0_MSK);
	PWM_EnableAutoLoadMode(PWM_CH_2_MSK);
	PWM_EnableAutoLoadMode(PWM_CH_4_MSK);
	//PWM
	PWM_DisableReverseOutput(PWM_CH_0_MSK|PWM_CH_1_MSK|PWM_CH_2_MSK|PWM_CH_3_MSK|PWM_CH_4_MSK|PWM_CH_5_MSK); //رշ
	//PWM
	PWM_EnableOutput(PWM_CH_0_MSK|PWM_CH_1_MSK|PWM_CH_2_MSK|PWM_CH_3_MSK|PWM_CH_4_MSK|PWM_CH_5_MSK);		//
	//PWM
	PWM_DisableDeadZone(PWM0);
	PWM_DisableDeadZone(PWM2);
	PWM_DisableDeadZone(PWM4);
	
	//PWMж
	PWM_EnableZeroInt(PWM_CH_0_MSK);				//PWMж
	PWM_AllIntEnable();							//PWMж
	IRQ_SET_PRIORITY(IRQ_PWM,IRQ_PRIORITY_HIGH);
	IRQ_ALL_ENABLE();								//ж

	//PWMIO
	P0DIG = 0x3F;  //P00~P05Ϊ
	GPIO_SET_PS_MODE(PS_PG0, GPIO_PWMCH0_MUX_P00);  //PWM0ѡP00
	GPIO_SET_PS_MODE(PS_PG1, GPIO_PWMCH1_MUX_P01);  //PWM1ѡP01
	GPIO_SET_PS_MODE(PS_PG2, GPIO_PWMCH2_MUX_P02);  //PWM2ѡP02
	GPIO_SET_PS_MODE(PS_PG3, GPIO_PWMCH3_MUX_P03);  //PWM3ѡP03
	GPIO_SET_PS_MODE(PS_PG4, GPIO_PWMCH4_MUX_P04);  //PWM4ѡP04
	GPIO_SET_PS_MODE(PS_PG5, GPIO_PWMCH5_MUX_P05);  //PWM5ѡP05

	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_0);
	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_1);
	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_2);
	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_3);
	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_4);
	GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_5);
	//PWM					
	PWM_Start(PWM_CH_0_MSK);
	PWM_Start(PWM_CH_2_MSK);
	PWM_Start(PWM_CH_4_MSK);
}


