/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_lvd.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_lvd.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/******************************************************************************
 ** \brief	 LVD_Config
 **   LVD中断模式配置，Config配置中LVD_mode选择INTERRUPT模式
 ** \param [in] none              	
 ** \return  none
 ** \note  
 ******************************************************************************/
void LVD_Config(void)
{
	SYS_EnablePeripheralClk1(SYS_CLK1_LVD_MSK);
	/*
	(1)设置LVD 监测电压
	*/
	SYS_ConfigLVD(SYS_LVD_4_0V);
	SYS_ConfigLVDINT_Edge(SYS_LVDINTEdge_Double);   //双沿触发LVD中断	
	/*
	(2)设置LVD中断
	*/	
	SYS_ConfigLVDFilt_CLK(SYS_LVDFiltFreq_16);      //滤波时钟为系统时钟16分频
	SYS_ConfigLVDFilt_Time(SYS_LVDFiltTime_1);      //1个滤波时钟
	/*
	(3)设置LVD中断
	*/
	SYS_EnableLVDInt();
	IRQ_SET_PRIORITY(IRQ_LVD,IRQ_PRIORITY_HIGH);
	IRQ_ALL_ENABLE();
	/*
	(4)开启LVD
	*/		
	SYS_EnableLVD();
}
























