/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_led.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_led.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/******************************************************************************
 ** \brief	 LED_Config
 ** \param [in] 
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
void LED_Config(void)
{	
	SYS_EnablePeripheralClk1(SYS_CLK1_LED_MSK);
	/*
	(1)设置LED模块运行模式
	*/
	LED_EnableLatticeMode();				//开启点阵模式
	LED_ConfigLatticeMode(LED_LATTICE_8X8,LED_SCAN_LOOP); //选择8x8点阵，循环扫描模式
	
	/*
	(2)设置时钟
	*/
	LED_ConfigLatticeClk(LED_CLK_32Tfix);		//Ffix  -> 8Mhz
	LED_ConfigLatticePeriod1(99);		//0.1ms	
	LED0SEL = 0x00;			/*选择使用周期1*/
	LED1SEL = 0x00;	
	LED2SEL = 0x00;	
	LED3SEL = 0x00;	
	LED4SEL = 0x00;	
	LED5SEL = 0x00;	
	LED6SEL = 0x00;	
	LED7SEL = 0x00;		
	
	/*
	(3)设置IO口
	*/
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_0);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_1);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_2);
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_3);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_4);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_5);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_6);	
	GPIO_ENABLE_DIGITAL(P0DIG, GPIO_PIN_7);
	GPIO_ENABLE_DIGITAL(P1DIG, GPIO_PIN_0);		

  LEDIOEN = 0xFF;      //使能LED0~7口功能
	LEDRESEQ = 0x8;      //使能LED8口功能	
	LEDSEGDR0 = 0x1F;		 //使能P04~P07 P10的管脚驱动	
	LEDSEGDR3 = 0x78;		 //使能P00~P03的管脚驱动	
	/*
	(4)设置电流
	*/		
	LEDDRV = 0x6;		    //22.1mA

	/*
	(5)设置数据
	*/
	LED0DATA = 0x00;
	LED1DATA = 0x00;
	LED2DATA = 0x00;
	LED3DATA = 0x00;
	LED4DATA = 0x00;	
	LED5DATA = 0x00;
	LED6DATA = 0x00;
	LED7DATA = 0x00;
	/*
	(7)开启LED点阵模式
	*/
	LED_StartLattice();
}

/******************************************************************************
 ** \brief	 LED_Display
 ** \param [in] Led : (1) 1~64 
 **					  (2) 0xff  ： ALL_LED 
 **				status: LED_ON(1) / LED_OFF(0)
 ** \return  none
 ** \note  
 ******************************************************************************/
void LED_Display(uint8_t led,uint8_t status)
{
	uint8_t ledcon, leddat;
	
	if((led<1) || ((led>64) && (led !=0xff)))
	{
		return;
	}
		
	if(led == 0xFF)		//选择全部
	{
		if(status)
		{
			LED0DATA = 0xff;
			LED1DATA = 0xff;
			LED2DATA = 0xff;
			LED3DATA = 0xff;
			LED4DATA = 0xff;	
			LED5DATA = 0xff;
			LED6DATA = 0xff;
			LED7DATA = 0xff;				
		}
		else
		{
			LED0DATA = 0x00;
			LED1DATA = 0x00;
			LED2DATA = 0x00;
			LED3DATA = 0x00;
			LED4DATA = 0x00;	
			LED5DATA = 0x00;
			LED6DATA = 0x00;
			LED7DATA = 0x00;		
		}
	}
	else
	{
		led = led -1;
		
		ledcon = led/8;
		leddat = led%8;
		
		switch(ledcon)
		{
			case 0:
				if(status)
					LED0DATA |= (1<<leddat);
				else
					LED0DATA &= ~(1<<leddat);			
			break;
				
			case 1:
				if(status)
					LED1DATA |= (1<<leddat);
				else
					LED1DATA &= ~(1<<leddat);			
			break;
			case 2:
				if(status)
					LED2DATA |= (1<<leddat);
				else
					LED2DATA &= ~(1<<leddat);			
			break;
			case 3:
				if(status)
					LED3DATA |= (1<<leddat);
				else
					LED3DATA &= ~(1<<leddat);			
			break;
			case 4:
				if(status)
					LED4DATA |= (1<<leddat);
				else
					LED4DATA &= ~(1<<leddat);			
			break;
			case 5:
				if(status)
					LED5DATA |= (1<<leddat);
				else
					LED5DATA &= ~(1<<leddat);			
			break;
			case 6:
				if(status)
					LED6DATA |= (1<<leddat);
				else
					LED6DATA &= ~(1<<leddat);			
			break;
			case 7:
				if(status)
					LED7DATA |= (1<<leddat);
				else
					LED7DATA &= ~(1<<leddat);			
			break;					
		}	
	}
}
















