/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_led.c
**
**  
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_led.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/
/*Bit7 bit6 bit5 bit4 bit3 bit2 bit1 bit0*/
/* a    b    c     d    e   f    g    dp  共阴*/
/* 7 	6	 5	   4    3   2    1    0   SEG*/

#define  SEG_A		0x1
#define  SEG_B		0x2
#define  SEG_C		0x4
#define  SEG_D		0x8
#define  SEG_E		0x10
#define  SEG_F		0x20
#define  SEG_G		0x40
#define  SEG_DP		0x80

#define  ALL_OFF	(0x00)
#define  ALL_ON		(SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G|SEG_DP)

#define  FOUNT_0	 (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E)
#define  FOUNT_1	 (SEG_B|SEG_C)
#define  FOUNT_2	 (SEG_A|SEG_B|SEG_D|SEG_E|SEG_G)
#define  FOUNT_3	 (SEG_A|SEG_B|SEG_C|SEG_D|SEG_G)
#define  FOUNT_4	 (SEG_B|SEG_C|SEG_F|SEG_G)
#define  FOUNT_5	 (SEG_A|SEG_C|SEG_D|SEG_F|SEG_G)
#define  FOUNT_6	 (SEG_A|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G)
#define  FOUNT_7	 (SEG_A|SEG_B|SEG_C)
#define  FOUNT_8	 (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G)
#define  FOUNT_9	 (SEG_A|SEG_B|SEG_C|SEG_D|SEG_F|SEG_G)
#define  FOUNT_a	 (SEG_A|SEG_B|SEG_C|SEG_E|SEG_F|SEG_G)
#define  FOUNT_b	 (SEG_C|SEG_D|SEG_E|SEG_F|SEG_G)
#define  FOUNT_c	 (SEG_D|SEG_E|SEG_G)
#define  FOUNT_d	 (SEG_B|SEG_C|SEG_D|SEG_E|SEG_G)
#define  FOUNT_e	 (SEG_A|SEG_D|SEG_E|SEG_F|SEG_G)
#define  FOUNT_f	 (SEG_A|SEG_E|SEG_F|SEG_G)

const uint8_t FontTable[18] ={
	FOUNT_0,FOUNT_1,FOUNT_2,FOUNT_3,FOUNT_4,FOUNT_5,
	FOUNT_6,FOUNT_7,FOUNT_8,FOUNT_9,FOUNT_a,FOUNT_b,
	FOUNT_c,FOUNT_d,FOUNT_e,FOUNT_f};



/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/******************************************************************************
 ** \brief	 LED_Config
 ** \param [in] 
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
void LED_Config(void)
{
	SYS_EnablePeripheralClk1(SYS_CLK1_LED_MSK);
	/*
	(1)设置LED模块运行模式
	*/
	LED_EnableMatrixMode();				//开启矩阵模式
	LED_ConfigMatrixMode(LED_DUTY_4,LED_COM_CATHODE);		//1/4duty,共阴模式
	
	LED_ConfigMatrixClk(LED_CLK_256Tfix);			 //select LED clock 32us(256*1/8MHz)
	LED_ConfigMatrixComTime(7);		    	       //COM有效时间设置
	LED_ConfigMatrixSegTime(250);	    	       //SEG有效时间设置
	/*
	(2)设置COM口
	*/
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_0);
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_1);
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_2);
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_3);		
	
	P0TRIS = 0x0F;		//开启输出
	LEDCOMEN = 0xF;		//使能COM0~COM3
		
	/*
	(3)设置SEG口
	*/	
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_4);     //SEG0	->a	
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_5);     //SEG1	->b	
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_6);     //SEG2	->c		
	GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_7);     //SEG3	->d	
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_0);     //SEG4	->e		
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_1);     //SEG5	->f	
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_2);     //SEG6	->g		
	GPIO_ENABLE_DIGITAL(P1DIG,GPIO_PIN_3);     //SEG7	->dp	 

	P0TRIS |= 0xF0;
	P1TRIS = 0x0F;
	LEDSEGEN0 = 0xFF;	//使能SEG0~SEG7	
	
	/*
	(4)设置SEG口电流
	*/		
	LEDSEGDR0 = 0xFF;		//使能SEG0~SEG7的管脚驱动
	LED_ConfigMatrixSegCurrent(LED_DRVC_12d2mA);		//12.2mA

	/*
	(5)设置COM口电流
	*/	
	LEDCOMDRV = 0x0f;			//COM0~3 220mA

	/*
	(6)设置SEG口数据
	*/
	LEDC0DATA0 = FontTable[1];			/*1*/
	LEDC1DATA0 = FontTable[2];			/*2*/
	LEDC2DATA0 = FontTable[3];			/*3*/
	LEDC3DATA0 = FontTable[4];			/*4*/

	/*
	(7)开启LED矩阵模式
	*/
	LED_StartMatrix();
}


















