/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file isr.c
**
** 
**
**	History:
**		
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "cms80f752xx.h"

/****************************************************************************/
/*	Local pre-processor symbols('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/
extern uint8_t *I2CS_RX_Address; 
/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/
volatile	uint32_t  I2C_Receive_Flag =0;			
volatile	uint32_t  I2C_Work_Flag =0;

volatile	uint32_t  I2C_Receive_Data =0;
 volatile	uint32_t  I2C_Send_Data =0;
volatile unsigned char buf[30];
volatile unsigned char *pbuf=buf;

volatile unsigned char sspcount =0;

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/


/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/


/******************************************************************************
 ** \brief	 INT0 interrupt service function
 **			
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void EXTINT0_IRQHandler(void)  interrupt EXTINT0_VECTOR
{
	
}
/******************************************************************************
 ** \brief	 Timer 0 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void Timer0_IRQHandler(void)  interrupt TMR0_VECTOR 
{

}
/******************************************************************************
 ** \brief	 INT0 interrupt service function
 **			
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void EXTINT1_IRQHandler(void)  interrupt EXTINT1_VECTOR
{

}
/******************************************************************************
 ** \brief	 Timer 1 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void Timer1_IRQHandler(void)  interrupt TMR1_VECTOR 
{

}
/******************************************************************************
 ** \brief	 UART 0 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void UART0_IRQHandler(void)  interrupt UART0_VECTOR 
{

}
/******************************************************************************
 ** \brief	 Timer 2 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void Timer2_IRQHandler(void)  interrupt TMR2_VECTOR 
{

}
/******************************************************************************
 ** \brief	 UART 1 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void UART1_IRQHandler(void)  interrupt UART1_VECTOR 
{

}
/******************************************************************************
 ** \brief	 EXT extend interrupt service function
 **	
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void EINT_IRQHandler(void)  interrupt EINT_VECTOR 
{

}

/******************************************************************************
 ** \brief	 oscilator detect interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void XTDET_IRQHandler(void)  interrupt XTDET_VECTOR 
{

}

/******************************************************************************
 ** \brief	 Timer 5 interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void Timer5_IRQHandler(void)  interrupt TMR5_VECTOR 
{

}
/******************************************************************************
 ** \brief	 PWM interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void PWM_IRQHandler(void)  interrupt PWM_VECTOR
{

}
/******************************************************************************
 ** \brief	 ADC interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void ADC_IRQHandler(void)  interrupt ADC_VECTOR 
{

}
/******************************************************************************
 ** \brief	I2C interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void I2C_IRQHandler(void)  interrupt I2C_VECTOR 
{
	if(I2C_GetIntFlag())
	{
		I2C_Receive_Flag = I2C_GetStatus();
		switch(I2C_Receive_Flag)
		{
/*----------------------------ģʽ-----------------------------------------*/
			case  I2C_SS_RECEIVE_ADDR_W:			/*ӻյ͵ĵַ+дظACK*/	
				
				I2C_Work_Flag = 0x01;				/*ӻѡвд*/	
				I2C_SendACK();						/*յ ظACK*/				 
				break;
			case  I2C_SS_RECEIVE_DAT_ACK:							/*ӻַƥյݣظACK*/	

				I2C_Work_Flag =0x02;
				I2C_Receive_Data =	I2C_GetData();		/*ȡ*/
							
				*pbuf++= I2C_Receive_Data;
				
					I2C_SendACK();						/*յ ظACK*/
				break;	
			case  I2C_SS_RECEIVE_DAT_NO_ACK:							/*ӻַƥյݣظ no ACK*/	
				
				I2C_Work_Flag = 0x05;					/*ӻյ*/		
				I2C_NotSendACK();
				break;
			case I2C_SS_RECEIVE_STOP_OR_RESTART:		/*յֹͣź*/
				
				pbuf = buf;
				I2C_Work_Flag = 0x04;	

			
				break;	
			
			case  I2C_SS_RECEIVE_ADDR_R_ACK:			/*ӻյ͵ĵַ+ظACK**/	
				
				I2C_Work_Flag = 0x03;					/*ӻն*/	
				/*-------------------*/
				//I2C_NotSendACK();			/*״̬>0XC8*/
				/*-------------------*/		
			
				I2C_Send_Data = buf[sspcount++];					
				I2C_SendData(I2C_Send_Data);
				
				break;			
			case  I2C_SS_SEND_DAT_NO_ACK:				/*ӻģʽ·ݺδյACK*/				
				I2C_Work_Flag = 0x07;
				sspcount=0;	
				pbuf = buf;
				break;

			case  I2C_SS_SEND_DAT_ACK:					/*ӻģʽ·ݺ󣬽յACK*/				
				I2C_Work_Flag = 0x06;				    		

				I2C_Send_Data = buf[sspcount++];					
				I2C_SendData(I2C_Send_Data);					
				break;	


			
			case  I2C_SS_SEND_LAST_DAT_NO_ACK:				/*ӻģʽ·һݺδյACK*/				
				I2C_Work_Flag = 0x08;				    		
				
				break;	
			
			case  I2C_SS_SEND_LAST_DAT_ACK:				/*ӻģʽ·һݺ󣬽յACK:*/				
				I2C_Work_Flag = 0x09;				    		
	
				I2C_Send_Data =5 ;					
				I2C_SendData(I2C_Send_Data);
			
				break;	

			case  I2C_SS_BORADCAST_RECEIVE_DAT_ACK:				/*ӻչ㲥еַյݣظACK*/	
				
				I2C_Receive_Data =	I2C_GetData();				/*ȡ*/			
				*pbuf++= I2C_Receive_Data;				  
					
				  I2C_Work_Flag = 0x0A;				    		
			
				break;	
			
			case  I2C_SS_BORADCAST_RECEIVE_DAT_NO_ACK:				/*ӻչ㲥еַյݣظACK*/				
				I2C_Work_Flag = 0x0B;				    		
			
				break;	
			
		}
		if(sspcount > 30)
		{
			sspcount=0;	
		}
		if(pbuf > (buf + 30))
		{
			pbuf = buf;
		}	
		I2C_ClearIntFlag();
	}
}
/******************************************************************************
 ** \brief	SPI interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void SPI_IRQHandler(void)  interrupt SPI_VECTOR 
{

}
/******************************************************************************
 ** \brief	 LED interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
******************************************************************************/
void LED_IRQHandler(void)  interrupt LED_VECTOR 
{

}
/******************************************************************************
 ** \brief	 LVD interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void LVD_IRQHandler(void)  interrupt LVD_VECTOR 
{

}
/******************************************************************************
 ** \brief	 TOUCH interrupt service function
 **
 ** \param [in]  none   
 **
 ** \return none
 ******************************************************************************/
void TOUCH_IRQHandler(void)  interrupt TOUCH_VECTOR 
{

}







