/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_i2c.c
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_i2c.h"
/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/
/*----slave ַ+Mask-----------------------------------------------------*/
#define Slave_Addr	   0x50//0x4c//0x98 
#define I2C_S_ADDRMask 0xfe

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/
uint8_t *I2CS_RX_Address;        /* I2C slave receive buffer address */

/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/


/********************************************************************************
 ** \brief	 I2C_Master_Mode
 **			
 ** \param [in] none
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
 void I2C_Init(void)
 {
	/*
	 (1)I2CͨѶʱ
	 */	 
	 SYS_EnablePeripheralClk0(SYS_CLK0_IIC_MSK);
	 I2C_ConfigClk(7,11);						/*Fapb =48M,ʱSCL = 3.125K, ʱΪ375Khz*/
	                                /*ʱ10ͨѶʱ*/
	/*
	(3)IO
	*/	 
	 GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_0);
	 GPIO_ENABLE_OD(P0OD,GPIO_PIN_0);
	 GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_0);
	 GPIO_ENABLE_UP(P0UP,GPIO_PIN_0);
   GPIO_SET_PS_MODE(PS_SCL, GPIO_IICSCL_MUX_P00);					/*SCLѡP00*/		
	 
	 GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_1);
	 GPIO_ENABLE_OD(P0OD,GPIO_PIN_1);
	 GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_1);
	 GPIO_ENABLE_UP(P0UP,GPIO_PIN_1);
 	 GPIO_SET_PS_MODE(PS_SDA, GPIO_IICSDA_MUX_P01);					/*SDAѡP01*/
	 
	 I2C_ConfigSlaveModeAddr(I2C_S_7BIT_ADDR,Slave_Addr,I2C_S_BROADCAST_EN);
	 
	 I2C_EnableInt();
	 I2C_SendACK();
	 I2C_EnableOutput();
	 EIE2|=0X40;
	/*
	(4)Timerжȼ
	*/	 
	 IRQ_SET_PRIORITY(IRQ_I2C,IRQ_PRIORITY_LOW);
	 IRQ_ALL_ENABLE();	
 }



