/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file demo_i2c.h
**
** History:
** 
*****************************************************************************/
#ifndef __DEMO_I2C_H_
#define __DEMO_I2C_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 I2C_Master_Mode
 **			
 ** \param [in] none
 **            	
 ** \return  none
 ** \note  
 *****************************************************************************/
 void I2C_Master_Mode(void);
 /*****************************************************************************
 ** \brief	 At24c256_read_str
 **			 ȡAt24c256
 ** \param [in] addr ʼַ
 **            	ch	 : ݱ()  
**				sizevalue: ȡݵĸ
 ** \return  0/1
 ** \note  	   unsigned char  array[10];			//һ10ֽڵ
 **	  At24c256_read_str(0x0010, Buffer, 5); //ӵַ0x0010ʼȡ5ֽڵݷŵarray
 *****************************************************************************/
int16_t At24c256_read_str(uint32_t addr,  uint32_t *ch, uint32_t sizevalue);
 
/*****************************************************************************
 ** \brief	 At24c256_read_byte
 **			 At24C256ж
 ** \param [in]  addr : ַ
 **            	
 ** \return  8λ
 ** \note   
 ****************************************************************************/
uint8_t  At24c256_read_byte(uint32_t addr);
/*****************************************************************************
 ** \brief	 At24c256_write_byte
 **			 дݵAt24C256
 ** \param [in] addr ַ
**				ch   : 
 **            	
 ** \return  -1ַΧ 0д
 ** \note  
 *****************************************************************************/ 
int16_t  At24c256_write_byte(uint32_t addr , uint32_t ch);


#ifdef __cplusplus
}
#endif

#endif /* __DEMO_I2C_H_ */

