/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file demo_i2c.c
**
**	History:
**  
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "demo_i2c.h"
/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/
/*----AT24C256ַ+д-----------------------------------------------------*/
#define  AT24C256_WRITE		0xA0 //0x98				/*Write Cmd*/
#define  AT24C256_READ    0xA1							/*Read  Cmd*/
#define  AT24C256_MAX		  0x7fff						/*address  max*/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/


/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/

/*****************************************************************************
 ** \brief	I2C_MasterSendStart
 **			طλ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void  I2C_MasterSendStart(void)
{
	I2C_SendStart();
}
/*****************************************************************************
 ** \brief	I2C_MasterWriteAddr
 **			дӻַ
 ** \param [in] SlaveAddr ӻַ+дλR/W
 ** \return  none
 ** \note	 дλڴӻַĵ0λ7λַ+R/W  
*****************************************************************************/
void  I2C_MasterWriteAddr(uint8_t SlaveAddr)
{
	I2C_SendData(SlaveAddr);	
}
/*****************************************************************************
 ** \brief	I2C_MasterWriteBuffer
 **			д
 ** \param [in] buffer
 ** \return  none
 ** \note	 дλڴӻַĵ0λ7λַ+R/W  
*****************************************************************************/
void  I2C_MasterWriteBuffer(uint8_t buffer)
{
	I2C_SendData(buffer);
}

/*****************************************************************************
 ** \brief	I2C_MasterSendStop
 **			طֹͣλ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void  I2C_MasterSendStop(void)
{
	I2C_SendStop();
}

/*****************************************************************************
 ** \brief	I2C_MasterSendRestart
 **			طλ
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void  I2C_MasterSendRestart(void)
{
	I2C_SendRestart();
}
/*****************************************************************************
 ** \brief	I2C_MasterReadBuffer
 **			ض
 ** \param [in] none
 ** \return  data
 ** \note	 
*****************************************************************************/
uint32_t I2C_MasterReadBuffer(void)
{
	return (I2C_GetData());
}

/*****************************************************************************
 ** \brief	I2C_MasterSendACK
 **			طACK
 ** \param [in] none
 ** \return  data
 ** \note	 
*****************************************************************************/
void  I2C_MasterSendACK(void)
{
	I2C_SendACK();
}
/*****************************************************************************
 ** \brief	I2C_MasterNotSendACK
 **			زACK
 ** \param [in] none
 ** \return  data
 ** \note	 
*****************************************************************************/
void  I2C_MasterNotSendACK(void)
{
	I2C_NotSendACK();
}
/*****************************************************************************
 ** \brief	I2C_Trigger
 **			I2C
 ** \param [in] none
 ** \return  data
 ** \note	 
*****************************************************************************/
void  I2C_Trigger(void)
{
	I2C_ClearIntFlag();
}

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/
/*****************************************************************************
 ** \brief	 At24c256_write_byte
 **			 дݵAt24C256
 ** \param [in] addr ַ
**				ch   : 
 **            	
 ** \return  -1ַΧ 0д
 ** \note  
 *****************************************************************************/
int16_t  At24c256_write_byte(uint32_t addr , uint32_t ch)
{
	int32_t i;
	if(addr >AT24C256_MAX)
		return -1;
	else
	{			
		I2C_MasterSendStart();			
		while(!(I2C_MS_START_OK ==I2C_GetStatus()));
		
		I2C_MasterWriteAddr(AT24C256_WRITE);			/*дӻַ+д*/	
		I2C_Trigger();
		while(!(I2C_MS_SEND_ADDR_W_ACK ==I2C_GetStatus()));		
		
		I2C_MasterWriteBuffer((addr>>8) & 0xff);		/*λROM ַ*/
		I2C_Trigger();			
		while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));	

		
		I2C_MasterWriteBuffer(addr & 0xff);				/*λROM ַ*/
		I2C_Trigger();	
		while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));		

		
		I2C_MasterWriteBuffer(ch);							/*д*/
		I2C_Trigger();	
		while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));	

		
		I2C_MasterSendStop();								/*ֹͣλ*/
		I2C_Trigger();	
		
		for(i=50000;i>0;i--);								/*ʱȷAT24C256д*/
		return 0;
	}
}

/********************************************************************************
 ** \brief	 At24c256_read_byte
 **			 At24C256ж
 ** \param [in]  addr : ַ
 **            	
 ** \return  8λ
 ** \note   
 ******************************************************************************/
uint8_t  At24c256_read_byte(uint32_t addr)
{
	unsigned char buffer;
	if(addr > AT24C256_MAX)
		return 1;
	

	I2C_MasterSendStart();	
	while(!(I2C_MS_START_OK ==I2C_GetStatus()));

	
	I2C_MasterWriteAddr(AT24C256_WRITE);			/*дӻַ+д*/
	I2C_Trigger();	
	while(!(I2C_MS_SEND_ADDR_W_ACK ==I2C_GetStatus()));

	
	I2C_MasterWriteBuffer((addr>>8) & 0xff);		/*λROM ַ*/
	I2C_Trigger();	
	while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));

	
	I2C_MasterWriteBuffer(addr & 0xff);				/*λROM ַ*/
	I2C_Trigger();	
	while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));	

	
	I2C_MasterSendRestart();	
	I2C_Trigger();	
	while(!(I2C_MS_RESTART_OK ==I2C_GetStatus()));	

	
	I2C_MasterWriteAddr(AT24C256_READ);					/*дӻַ+*/	
	I2C_Trigger();	
	while(!(I2C_MS_SEND_ADDR_R_ACK ==I2C_GetStatus()));	

	
	I2C_MasterNotSendACK();
	I2C_Trigger();	
	while(!(I2C_MS_READ_DAT_NO_ACK ==I2C_GetStatus()));	/*ȴݽ*/

	buffer=I2C_MasterReadBuffer();						/*ȡ*/
	
	I2C_MasterSendStop();								/*ֹͣλ*/		
	I2C_Trigger();
	
	return buffer;
}
/********************************************************************************
 ** \brief	 At24c256_read_str
 **			 ȡAt24c256
 ** \param [in] addr ʼַ
 **            	ch	 : ݱ()  
**				sizevalue: ȡݵĸ
 ** \return  0/1
 ** \note  	   unsigned char  array[10];			//һ10ֽڵ
 **	  At24c256_read_str(0x0010, Buffer, 5); //ӵַ0x0010ʼȡ5ֽڵݷŵarray
 ******************************************************************************/
int16_t At24c256_read_str(uint32_t addr,  uint32_t *ch, uint32_t sizevalue)
{
	int16_t i;
	if(addr > AT24C256_MAX)
		return 0;
	

	I2C_MasterSendStart();
	while(!(I2C_MS_START_OK ==I2C_GetStatus()));

	
	I2C_MasterWriteAddr(AT24C256_WRITE);			/*дӻַ+д*/
	I2C_Trigger();
	while(!(I2C_MS_SEND_ADDR_W_ACK ==I2C_GetStatus()));

	
	I2C_MasterWriteBuffer((addr>>8) & 0xff);		/*λROM ַ*/
	I2C_Trigger();
	while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));	
	
	
	I2C_MasterWriteBuffer(addr & 0xff);				/*λROM ַ*/
	I2C_Trigger();
	while(!(I2C_MS_SEND_DAT_ACK ==I2C_GetStatus()));	

	I2C_MasterSendRestart();	
	I2C_Trigger();
	while(!(I2C_MS_RESTART_OK ==I2C_GetStatus()));	

	
	I2C_MasterWriteAddr(AT24C256_READ);					/*дӻַ+*/	
	I2C_Trigger();
	while(!(I2C_MS_SEND_ADDR_R_ACK ==I2C_GetStatus()));	

	
	I2C_MasterSendACK();	
	I2C_Trigger();
	for(i=0;i<sizevalue-1;i++)
	{	
		while(!(I2C_MS_READ_DAT_ACK ==I2C_GetStatus()));	/*ȴݽ*/				
		*ch++ = I2C_MasterReadBuffer();						/**/
		I2C_Trigger();			
	}
	
	I2C_MasterNotSendACK();									/*ȡһ,ACK*/
	I2C_Trigger();
	while(!(I2C_MS_READ_DAT_NO_ACK ==I2C_GetStatus()));		/*ȴݽ*/
	*ch =I2C_MasterReadBuffer();									
	
	I2C_MasterSendStop();								/*ֹͣλ*/	
	I2C_Trigger();	
	return 1;
}


/********************************************************************************
 ** \brief	 I2C_Master_Mode
 **			
 ** \param [in] none
 **            	
 ** \return  none
 ** \note  
 ******************************************************************************/
 void I2C_Master_Mode(void)
 {
	/*
	 (1)I2CͨѶʱ
	 */	 
	 SYS_EnablePeripheralClk0(SYS_CLK0_IIC_MSK);
	 I2C_ConfigClk(7,11);						/*Fapb =48M,ʱSCL = 400K, ʱΪ48Mhz*/
	/*
	(3)IO
	*/ 
	 GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_0);
	 GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_0);
	 GPIO_ENABLE_OD(P0OD,GPIO_PIN_0);
	 GPIO_ENABLE_UP(P0UP,GPIO_PIN_0);
	 GPIO_SET_PS_MODE(PS_SCL, GPIO_IICSCL_MUX_P00);						/*SCLѡP00*/	
	 
	 GPIO_ENABLE_DIGITAL(P0DIG,GPIO_PIN_1);
	 GPIO_ENABLE_OUTPUT(P0TRIS,GPIO_PIN_1);
	 GPIO_ENABLE_OD(P0OD,GPIO_PIN_1);
	 GPIO_ENABLE_UP(P0UP,GPIO_PIN_1);
	 GPIO_SET_PS_MODE(PS_SDA, GPIO_IICSDA_MUX_P01); 					/*SDAѡP01*/	 
	 
	 I2C_EnableOutput();
 }



