/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file wdt.c
**
**  
**
**	History:
**
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "wdt.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/

/*****************************************************************************
 ** \brief	 WDT_ConfigOverflowTime
 **			设置WDT溢出时间
 ** \param [in] TsysCoefficient : (1)WDT_CLK_256 	
 **								  (2)WDT_CLK_512 	
 **								  (3)WDT_CLK_1024 	
 **								  (4)WDT_CLK_2048	
 **								  (5)WDT_CLK_4096  
 **								  (6)WDT_CLK_16384	
 **								  (7)WDT_CLK_32768  
 **								  (8)WDT_CLK_131072 
 ** \return none 
 ** \note	若Flsi =32.768KHz, 则     (1)WDT_CLK_256  , 溢出时间= Tsys * 256 = 7.8125ms
 **								  (2)WDT_CLK_512 	,   溢出时间= Tsys * 512 	 = 15.625ms
 **								  (3)WDT_CLK_1024 ,   溢出时间= Tsys * 1024   = 31.25ms
 **								  (4)WDT_CLK_2048	,   溢出时间= Tsys * 2048	 = 62.5ms
 **								  (5)WDT_CLK_4096  ,  溢出时间= Tsys * 4096   = 125ms
 **								  (6)WDT_CLK_16384	, 溢出时间= Tsys * 16384  = 0.5s
 **								  (7)WDT_CLK_32768  , 溢出时间= Tsys * 32768  = 1s 
 **								  (8)WDT_CLK_131072 , 溢出时间= Tsys * 131072 = 4s
 *****************************************************************************/
void  WDT_ConfigOverflowTime(uint8_t TsysCoefficient)
{
	uint8_t Temp=0;
	
	SYS_EnablePeripheralClk0(SYS_CLK0_WDT_MSK);  //操作WDT相关寄存器需打开时钟使能
	Temp = TsysCoefficient<<4;
	WDT_ConfigTim(Temp);
}









