/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file system.c
**
**  
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "system.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
****************************************************************************/
/*****************************************************************************
 ** \brief	 SYS_EnablePeripheralClk0
 **			 开启外设时钟
 ** \param [in] CLKSr:(0)SYS_CLK0_UART1_MSK		  UART1时钟使能位
 **               (1)SYS_CLK0_UART0_MSK		  UART0时钟使能位
 **               (2)SYS_CLK0_SPI_MSK			  SPI时钟使能位
 **               (3)SYS_CLK0_IIC_MSK			  IIC时钟使能位
 **               (4)SYS_CLK0_WDT_MSK			  WDT时钟使能位
 **               (5)SYS_CLK0_TIMER5_MSK	    TIMER5时钟使能位
 **               (6)SYS_CLK0_TIMER2_MSK		  TIMER2时钟使能位
 **               (7)SYS_CLK0_TIMER01_MSK		TIMER01时钟使能位
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnablePeripheralClk0(uint8_t Module)
{
	PCGEN0 |= Module;
}
/*****************************************************************************
 ** \brief	 SYS_EnablePeripheralClk1
 **			 开启外设时钟
 ** \param [in] CLKSr:(0)SYS_CLK1_DAC_MSK				DAC时钟使能位
 **               (1)SYS_CLK1_TOUCH_MSK			TOUCH时钟使能位
 **               (2)SYS_CLK1_LED_MSK		    LED时钟使能位
 **               (3)SYS_CLK1_ADC_MSK		    ADC时钟使能位
 **               (4)SYS_CLK1_PWM_MSK	      PWM时钟使能位
 **               (5)SYS_CLK1_LVD_MSK	      LVD时钟使能位
 **               (6)SYS_CLK1_BRT_MSK	      BRT波特率时钟使能位
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnablePeripheralClk1(uint8_t Module)
{
	PCGEN1 |= Module;
}
/*****************************************************************************
 ** \brief	 SYS_EnableSoftwareReset
 **			 使能软件复位System
 ** \param [in] none
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_EnableSoftwareReset(void)
{
	uint8_t Temp=0;
	
	Temp = RSTCF;
	Temp |= 0X80; 
	if(EA==1) //操作TA时序时不允许被打断，因而需要关闭中断
	{
		EA=0;		
		_nop_();
		TA = 0xAA;
		TA = 0x55;
		RSTCF = Temp; 	
		EA=1;
	}
	else
	{
		TA = 0xAA;
		TA = 0x55;
		RSTCF = Temp; 
	} 
}
/*****************************************************************************
 ** \brief	 SYS_DisableSoftwareReset
**			 关闭软件复位System(清软件复位)
 ** \param [in] none
 ** \return none
 ** \note
 *****************************************************************************/
void SYS_DisableSoftwareReset(void)
{
	uint8_t Temp=0;
	
	Temp = RSTCF;
	Temp &= 0X7F; 
	if(EA==1) //操作TA时序时不允许被打断，因而需要关闭中断
	{
		EA=0;		
		_nop_();
		TA = 0xAA;
		TA = 0x55;
		RSTCF = Temp; 	
		EA=1;
	}
	else
	{
		TA = 0xAA;
		TA = 0x55;
		RSTCF = Temp; 
	}  
}
/*****************************************************************************
 ** \brief	 SYS_GetWDTResetFlag
 **			 获取System复位的标志
 ** \param [in] FlagSt：SYS_RSTFLAG_POR，SYS_RSTFLAG_EXTR，SYS_RSTFLAG_WDTR
** \return 0：对应标志没有复位    1：对应标志有复位
 ** \note
 *****************************************************************************/
uint8_t SYS_GetResetFlag(SYS_RSTF_t FlagSt)
{
	return((RSTCF & FlagSt)? 1:0);
}
/*****************************************************************************
 ** \brief	 SYS_ClearWDTResetFlag
 **			 清除System复位的标志
 ** \param [in] FlagSt：SYS_RSTFLAG_POR，SYS_RSTFLAG_EXTR，SYS_RSTFLAG_WDTR
 ** \return   none
 ** \note
 *****************************************************************************/
void SYS_ClearResetFlag(SYS_RSTF_t FlagSt)
{
	uint8_t Temp=0;
	
	Temp = RSTCF;
	Temp &= ~FlagSt;
	TA = 0xAA;
	TA = 0x55;
	RSTCF = Temp;
}
/*****************************************************************************
 ** \brief	 SYS_EnterStop
 **			 进入休眠中STOP状态
 ** \param [in] none
 ** \return none
 ** \note	
 *****************************************************************************/
void SYS_EnterStop(void)
{
	_nop_();
	_nop_();
	PCON |= SYS_PCON_STOP_Msk;
	_nop_();
	_nop_();	
	_nop_();
	_nop_();
	_nop_();
	_nop_();
}
/*****************************************************************************
 ** \brief	 SYS_EnterIdle
 **			 进入休眠模式中Idle状态
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnterIdle(void)
{
	_nop_();
	_nop_();
	PCON |= SYS_PCON_IDLE_Msk;
	_nop_();
	_nop_();	
	_nop_();
	_nop_();
	_nop_();
	_nop_();
}

/*****************************************************************************
 ** \brief	 SYS_EnableSCM
 **			 使能停振监测功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnableSCM(void)
{
	XT_SCM |= SYS_XTSCM_SCMEN_Msk;
}
/*****************************************************************************
 ** \brief	 SYS_DisableSCM
 **			 关闭停振监测功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_DisableSCM(void)
{
	XT_SCM &= ~(SYS_XTSCM_SCMEN_Msk);
}

/*****************************************************************************
 ** \brief	 SYS_EnableSCMInt
 **			 使能停振监测中断功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_EnableSCMInt(void)
{
	XT_SCM |= SYS_XTSCM_SCMIE_Msk;	
}
/*****************************************************************************
 ** \brief	 SYS_DisableSCMInt
 **			 关闭停振监测中断功能
 ** \param [in] none
 ** \return none
 ** \note   
 *****************************************************************************/
void SYS_DisableSCMInt(void)
{
	XT_SCM &= ~(SYS_XTSCM_SCMIE_Msk);
}
/*****************************************************************************
 ** \brief	 SYS_GetSCMIntFlag
 **			 获取停振监测中断标志位
 ** \param [in] none
 ** \return  0:无中断 1：有中断
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetSCMIntFlag(void)
{
	return((XT_SCM & SYS_XTSCM_SCMIF_Msk)? 1:0);
}
/*****************************************************************************
 ** \brief	 SYS_GetSCMState
 **			 获取停振监测状态位位
 ** \param [in] none
 ** \return  0:停振恢复 1：停振
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetSCMState(void)
{
	return((XT_SCM & SYS_XTSCM_SCMSTA_Msk)? 1:0);
}
/*****************************************************************************
 ** \brief	 SYS_ClearSCMIntFlag
 **			 清除停振监测中断标志位
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ClearSCMIntFlag(void)
{
	XT_SCM &= ~(SYS_XTSCM_SCMIF_Msk);	
}

/*****************************************************************************
 ** \brief	 SYS_EnableLVD
 **			 开启电压监测功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_EnableLVD(void)
{
	PCGEN1 |= 0x02;
}
/*****************************************************************************
 ** \brief	 SYS_DisableLVD
 **			  关闭电压监测功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_DisableLVD(void)
{
	PCGEN1 &= 0xFD;	
}
/*****************************************************************************
  ** \brief	 SYS_ConfigLVD
 **			 配置系统电压监测电压
 ** \param [in] LVDValue :(1)SYS_LVD_2_5V		LVD电压监测点2.5V					
						(2)	SYS_LVD_2_7V		LVD电压监测点2.7V
						(3)	SYS_LVD_3_3V		LVD电压监测点3.3V
						(4)	SYS_LVD_3_0V		LVD电压监测点3.0V
						(5)	SYS_LVD_3_7V		LVD电压监测点3.7V
						(6)	SYS_LVD_4_0V		LVD电压监测点4.0V
						(7)	SYS_LVD_4_3V		LVD电压监测点4.3V
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVD(uint8_t LVDValue)
{
	LVDS = 0x50 | LVDValue;
}
/*****************************************************************************
 ** \brief	 SYS_EnableLVDInt
 **			 开启电压监测中断功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_EnableLVDInt(void)
{
	LVDCON |= LVD_LVDCON_LVDINTE_Msk;	
}
/*****************************************************************************
 ** \brief	 SYS_DisableLVDInt
 **			  关闭电压监测中断功能
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_DisableLVDInt(void)
{
	LVDCON &= ~(LVD_LVDCON_LVDINTE_Msk);	
}
/*****************************************************************************
  ** \brief	 SYS_ConfigLVD
 **			 配置LVD中断产生触发边沿
 ** \param [in] LVDEdg :(1)SYS_LVDINTEdge_Double	  LVD双沿产生中断
						(2) SYS_LVDINTEdge_Falling	LVD下降沿产生中断
						(3) SYS_LVDINTEdge_Rising	  LVD上升沿产生中断
						(4) SYS_LVDINTEdge_None		  LVD中断边沿检测功能关闭
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDINT_Edge(uint8_t LVDEdg)
{
	LVDEICFG &= ~LVD_LVDEICFG_INTEDGE_Msk;
	LVDEICFG |= LVDEdg;
}
/*****************************************************************************
 ** \brief	 SYS_GetLVDIntFlag
 **			 获取LVD中断标志位
 ** \param [in] none
 ** \return  0:无中断 1：有中断
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetLVDIntFlag(void)
{
	return((LVDCON & LVD_LVDCON_LVDINTF_Msk)? 1:0);
}

/*****************************************************************************
 ** \brief	 SYS_ClearLVDIntFlag
 **			 清除LVD中断标志位
 ** \param [in] none
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ClearLVDIntFlag(void)
{
	LVDCON	&= ~(LVD_LVDCON_LVDINTF_Msk);
}
/*****************************************************************************
 ** \brief	 SYS_GetLVDState
 **			 获取LVD电压监测输出状态
 ** \param [in] none
 ** \return  0:LVD电压监测输出0 1：LVD电压监测输出1
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetLVDState(void)
{
	return((LVDCON & LVD_LVDCON_LVDOUTB_Msk)? 1:0);
}
/*****************************************************************************
 ** \brief	 SYS_GetLVDFiltState
 **			 获取LVD电压监测滤波后的输出
 ** \param [in] none
 ** \return  0:LVD电压监测输出0 1：LVD电压监测输出1
 ** \note	 
*****************************************************************************/
uint8_t SYS_GetLVDFiltState(void)
{
	return((LVDCON & LVD_LVDCON_LVDOUTBFILT_Msk)? 1:0);
}

/*****************************************************************************
  ** \brief	 SYS_ConfigLVDFilt_Time
 **			 配置系统电压监测滤波时间
 ** \param [in] LVDFiltTime :(1)SYS_LVDFiltTime_4	  4个滤波时钟
						(2) SYS_LVDFiltTime_3	  3个滤波时钟
						(3) SYS_LVDFiltTime_2	  2个滤波时钟
						(4) SYS_LVDFiltTime_1		1个滤波时钟
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDFilt_Time(uint8_t LVDFiltTime)
{
	LVDEICFG &= ~LVD_LVDEICFG_LVDSNUS_Msk;
	LVDEICFG |= LVDFiltTime << LVD_LVDEICFG_LVDSNUS_Pos;
}

/*****************************************************************************
  ** \brief	 SYS_ConfigLVDFilt_CLK
 **			 配置系统电压监测滤波时钟
 ** \param [in] LVDFiltClk :(1)SYS_LVDFiltFreq_64	滤波时钟为系统时钟64分频
						(2) SYS_LVDFiltFreq_16	滤波时钟为系统时钟16分频
						(3) SYS_LVDFiltFreq_4	  滤波时钟为系统时钟4分频
						(4) SYS_LVDFiltFreq_1		滤波时钟为系统时钟1分频
 ** \return  none
 ** \note	 
*****************************************************************************/
void SYS_ConfigLVDFilt_CLK(uint8_t LVDFiltClk)
{
	LVDEICFG &= ~LVD_LVDEICFG_LVDSCKS_Msk;
	LVDEICFG |= LVDFiltClk << LVD_LVDEICFG_LVDSCKS_Pos;
}









