/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, No 2609-10, Taurus Plaza, TaoyuanRoad, NanshanDistrict, Shenzhen, China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file i2c.c
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "i2c.h"
/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/


/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/

/*****************************************************************************
 ** \brief	I2C_ConfigClk
 **			I2Cʱ
 ** \param [in] CLK_M: 0x00~0x7;
 **				CLK_N: 0x00~0xf;
 ** \return  none
 ** \note	ʱ= PCLK/2^M   SCLʱ= PCLK/2^MN+110
 ** \note	ʱ10ͨѶʱ
*****************************************************************************/
void I2C_ConfigClk(uint32_t CLK_M, uint32_t CLK_N)
{ 
	I2CCLK = ((0x7 & CLK_M) <<4) | (0xf & CLK_N);
}

/*****************************************************************************
 ** \brief	I2C_EnableOutput
 **			I2Cӿ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void	I2C_EnableOutput(void)
{
	I2CCON |= I2C_CON_EN_Msk;
}

/*****************************************************************************
 ** \brief	I2C_DisableOutput
 **			رI2Cӿ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_DisableOutput(void)
{           
	I2CCLR |= I2C_CLR_EN_Msk;
}
/*****************************************************************************
 ** \brief	I2C_EnableInt
 **			I2Cж
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_EnableInt(void)
{
	I2CCON |= I2C_CON_IE_Msk;
}
/*****************************************************************************
 ** \brief	I2C_DisableInt
 **			رI2Cж
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_DisableInt(void)
{
	I2CCLR |= (I2C_CLR_IE_Msk);
}

/*****************************************************************************
 ** \brief	I2C_GetIntFlag
 **			ȡжϱ־λ
 ** \param [in] none
 ** \return  0I2C״̬δı  1I2C״̬ı
 ** \note	
*****************************************************************************/
uint32_t I2C_GetIntFlag(void)
{
	return((I2CCON & I2C_CON_SI_Msk)? 1:0);
}

/*****************************************************************************
 ** \brief	I2C_ClearIntFlag
 **			I2Cжϱ־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearIntFlag(void)
{
	I2CCLR |= I2C_CLR_SIC_Msk;
}

/*****************************************************************************
 ** \brief	I2C_ClearStartFlag
 **			I2C־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearStartFlag(void)
{
	I2CCLR |= I2C_CLR_STAC_Msk;	
}
/*****************************************************************************
 ** \brief	I2C_ClearACKFlag
 **			I2CӦ־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearACKFlag(void)
{
	I2CCLR |= I2C_CLR_AAC_Msk;		
}

/*****************************************************************************
 ** \brief	I2C_GetStatus
 **			ȡI2C״̬
 ** \param [in] none
 ** \return  Status
 ** \note	
*****************************************************************************/
uint32_t I2C_GetStatus(void)
{
	return((I2CSTAT));
}

/*****************************************************************************
 ** \brief	I2C_ConfigSlaveAddr
 **			ôӻģʽַ
 ** \param [in] Slave: I2C_S_7BIT_ADDR,I2C_S_10BIT_ADDR
 **				addr: 7λַ 10λַ
 **				Broadcast: I2C_S_BROADCAST_EN I2C_S_BROADCAST_DIS
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ConfigSlaveModeAddr(uint32_t Slave, uint32_t Addr, uint32_t Broadcast)
{
	switch(Slave)
	{
		case I2C_S_7BIT_ADDR:
			I2CADR = (Addr<<1)| Broadcast;	
		break;	
		case I2C_S_10BIT_ADDR:
			I2CADR = (Addr<<1)| Broadcast;
			I2CXAR = (Addr>>8)*I2C_XAR_XADRn_Msk;	
		break;	
		default:
		break;
	}

}
/*****************************************************************************
 ** \brief	I2C_GetSlave10BitAddrFlag
 **			ȡI2C ӻ10λַ־λ
 ** \param [in] none
 ** \return 0:I2Cַƥ   1: 12C 10λַƥ
 ** \note	
*****************************************************************************/
uint32_t I2C_GetSlave10BitAddrFlag(void)
{
	return((I2CCON & I2C_CON_XADRF_Msk)? 1:0);
}
/*****************************************************************************
 ** \brief	I2C_GetSlave7BitAddrFlag
 **			ȡI2C ӻ7λַ־λ
 ** \param [in] none
 ** \return 0:I2Cַƥ   1: 12C 10λַƥ
 ** \note	
*****************************************************************************/
uint32_t I2C_GetSlave7BitAddrFlag(void)
{
	return((I2CCON & I2C_CON_ADRF_Msk)? 1:0);
}

/*****************************************************************************
 ** \brief	I2C_Reset
 **			λI2Cģ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_Reset(void)
{
	I2CXAR |= I2C_XAR_RST_Msk;
}

/*****************************************************************************
 ** \brief	I2C_SendData
 **			
 ** \param [in] I2CData
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendData(uint8_t I2CData)
{		
	I2CDAT = I2CData;
}
/*****************************************************************************
 ** \brief	I2C_SendACK
 **			Ӧλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendACK(void)
{
	I2CCON |= I2C_CON_AA_Msk;
}
/*****************************************************************************
 ** \brief	I2C_NotSendACK
 **			Ӧλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_NotSendACK(void)
{
	I2CCLR |= I2C_CLR_AAC_Msk;	
}
/*****************************************************************************
 ** \brief	I2C_SendStart
 **			ʼλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStart(void)
{
	I2CCON |= I2C_CON_STA_Msk;	
}
/*****************************************************************************
 ** \brief	I2C_SendRestart
 **			λ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendRestart(void)
{
	I2CCON |= I2C_CON_STA_Msk;	
}
/*****************************************************************************
 ** \brief	I2C_SendStop
 **			ֹͣλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStop(void)
{
	I2CCON |= I2C_CON_STO_Msk;	
}
/*****************************************************************************
 ** \brief	I2C_SendStopBeforeStart
 **			ȷһֹͣλŷһλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStopBeforeStart(void)
{
	I2CCON |= I2C_CON_STA_Msk | I2C_CON_STO_Msk;	
}

/*****************************************************************************
 ** \brief	I2C_GetData
 **			ȡ
 ** \param [in] none
 ** \return  Data
 ** \note	
*****************************************************************************/
uint32_t I2C_GetData(void)
{
	return (0xff & I2CDAT);
}
