/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/****************************************************************************/
/** \file adc.c
**
**  
**
**	History:
**	
*****************************************************************************/
/****************************************************************************/
/*	include files
*****************************************************************************/
#include "adc.h"

/****************************************************************************/
/*	Local pre-processor symbols/macros('#define')
*****************************************************************************/

/****************************************************************************/
/*	Global variable definitions(declared in header file with 'extern')
*****************************************************************************/

/****************************************************************************/
/*	Local type definitions('typedef')
*****************************************************************************/

/****************************************************************************/
/*	Local variable  definitions('static')
*****************************************************************************/

/****************************************************************************/
/*	Local function prototypes('static')
*****************************************************************************/

/****************************************************************************/
/*	Function implementation - global ('extern') and local('static')
*****************************************************************************/

/*****************************************************************************
 ** \brief	 ADC_Start			
 ** \param [in] none       
 ** \return  none
*****************************************************************************/
void  ADC_Start(void)
{
	ADCON1 |= ADC_ADCON1_ADEN_Msk;
}
/*****************************************************************************
 ** \brief	 ADC_Stop			
 ** \param [in] none         
 ** \return  none
*****************************************************************************/
void  ADC_Stop(void)
{
	ADCON1 &= ~(ADC_ADCON1_ADEN_Msk);
}

/*****************************************************************************
 ** \brief	 ADC_ConvertClock
 **			  ADCת
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigClock( uint8_t ConvertTime)
{
	uint8_t temp=0;
	
	temp = ADCON0;
	temp &= ~(ADC_ADCON0_ADCKSn_Msk);
	temp |= ConvertTime << ADC_ADCON0_ADCKSn_Pos;
	ADCON0 = temp;
	
}

/*****************************************************************************
 ** \brief	 ADC_ConvertClock
 **			  ADCĲοѹ
 ** \param [in] VrefDatADC_VREF_VDDREF, ADC_VREF_ADCLDO
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_ConfigVREF( uint8_t VrefDat)
{
	uint8_t temp=0;
	
	temp = ADCON1;
	temp &= ~(ADC_ADCON1_ADVSEL_Msk);
	temp |= VrefDat << ADC_ADCON1_ADVSEL_Pos;
	ADCON1 = temp;
	
}

/*****************************************************************************
 ** \brief	 ADC_ConfigRunMode
 **			  ADCģʽ
 ** \param [in] ADCClkDiv: ADC_CLK_DIV_1 ~ ADC_CLK_DIV_256
 **          	  VrefDat ADC_VREF_VDDREF, ADC_VREF_ADCLDO
 ** \return  none
 ** \note 	 
*****************************************************************************/
void  ADC_ConfigRunMode( uint8_t ADCClkDiv, uint8_t ADCVRef)
{
	ADCON0 &= ~(ADC_ADCON0_ADCKSn_Msk);
	ADCON0 |= 0x80 |(ADCClkDiv<< ADC_ADCON0_ADCKSn_Pos);
	
	ADCON1 &= ~(ADC_ADCON1_ADVSEL_Msk);
	ADCON1 |= ADCVRef << ADC_ADCON1_ADVSEL_Pos;
}

/*****************************************************************************
 ** \brief	 ADC_EnableChannel
 **			 ʹADCתͨ
 ** \param [in]  ADCChannel: ADC_CH_0 ..... ADC_CH_54
 ** \return  none
 ** \note 	
*****************************************************************************/
void  ADC_EnableChannel(uint16_t ADCChannel)
{	
	uint8_t temp=0;
	
	temp = ADCON1;
	temp &= ~ADC_ADCON1_ADCHSn_Msk;
	temp |= ADCChannel;
	ADCON1 = temp;
}

/*****************************************************************************
 ** \brief	 ADC_GetADCResult
 **			 ȡADCת
 ** \param [in]  none
 ** \return  12bits ADCֵ
 ** \note 
*****************************************************************************/
uint16_t  ADC_GetADCResult(void)
{
	return (0xfff & ((ADRESH<<8)| ADRESL));	
}

/*****************************************************************************
 ** \brief	 ADC_EnableInt
 **			 ADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_EnableInt(void)
{
	EIE2 |= IRQ_EIE2_ADCIE_Msk;
}
/*****************************************************************************
 ** \brief	 ADC_DisableInt
 **			 رADCתж
 ** \param [in]  none
 ** \return  none
 ** \note 
*****************************************************************************/
void ADC_DisableInt(void)
{
	EIE2 &= ~(IRQ_EIE2_ADCIE_Msk);
}
/*****************************************************************************
 ** \brief	 ADC_GetIntFlag
 **			 ȡADCתжϱ־λ
 ** \param [in]  none
 ** \return  0жϣ1ж
 ** \note 
*****************************************************************************/
uint8_t ADC_GetIntFlag(void)
{
	return ((EIF2 & IRQ_EIF2_ADCIF_Msk) ? 1:0);
}
/*****************************************************************************
 ** \brief	 ADC_ClearIntFlag
 **			 ADCתжϱ־λ
 ** \param [in] none
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_ClearIntFlag(void)
{
	EIF2 = 0xFF &(~(IRQ_EIF2_ADCIF_Msk));
}

/*****************************************************************************
 ** \brief	 ADC_LDOStart
 **			 ʹADCLDO
 ** \param [in] none:
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_LDOStart(void)
{
	ADCLDO |= ADC_ADCLDO_LDOEN_Msk;
}

/*****************************************************************************
 ** \brief	 ADC_LDOStop
 **			 رADCLDO
 ** \param [in] none:
 ** \return  none
 ** \note   
*****************************************************************************/
void ADC_LDOStop(void)
{
	ADCLDO &= ~ADC_ADCLDO_LDOEN_Msk;
}

