/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file WDT.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __WDT_H__
#define __WDT_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **WDT ʱӷƵ
/*---------------------------------------------------------------------------*/
#define WDT_CLK_256 			(0x00)		/*ʱ= Tsys * 256 	 (2^8  * Tlsi)*/
#define WDT_CLK_512 			(0x01)		/*ʱ= Tsys * 512 	 (2^9  * Tlsi)*/
#define WDT_CLK_1024 			(0x02)		/*ʱ= Tsys * 1024 	 (2^10 * Tlsi)*/
#define WDT_CLK_2048			(0x03)		/*ʱ= Tsys * 2048	 (2^11 * Tlsi)*/
#define WDT_CLK_4096  		(0x04)		/*ʱ= Tsys * 4096   (2^12 * Tlsi)*/
#define	WDT_CLK_16384			(0x05)		/*ʱ= Tsys * 16384	 (2^14 * Tlsi)*/
#define	WDT_CLK_32768 		(0x06)		/*ʱ= Tsys * 32768  (2^15 * Tlsi)*/
#define	WDT_CLK_131072		(0x07)		/*ʱ= Tsys * 131072 (2^17 * Tlsi)*/



/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 WDT_ClearWDT
 **			WDT
 ** \param [in] none
 **
 ** \return none 
 ** \note
 *****************************************************************************/
//CPU_WAITCLOCKѡ1TģʽʱEA=0nop,ѡTʱӡ
#define WDT_ClearWDT()   do{\
																	uint8_t temp = EA;\
																	PCGEN0 |= 0x08;\
														      EA = 0;\
														      _nop_();\
																	TA = 0xAA;\
																	TA = 0x55;\
														      WDKEY = 0X99;\
														      EA = temp;\
										   }while(0)
/*****************************************************************************
 ** \brief	 WDT_Start
 **			 WDT
 ** \param [in] none
 **
 ** \return none
 ** \note
 *****************************************************************************/
#define WDT_Start()   do{\
																	uint8_t temp = EA;\	
																	PCGEN0 |= 0x08;\	
														      EA = 0;\
														      _nop_();\
																	TA = 0xAA;\
																	TA = 0x55;\
														      WDKEY = 0x66;\
														      EA = temp;\
										   }while(0)	
/*****************************************************************************
 ** \brief	 WDT_Stop
 **			 رWDT
 ** \param [in] none
 **
 ** \return none
 ** \note
 *****************************************************************************/
#define WDT_Stop()   do{\
																	uint8_t temp = EA;\	
																	PCGEN0 |= 0x08;\																	
														      EA = 0;\
														      _nop_();\
																	TA = 0xAA;\
																	TA = 0x55;\
														      WDKEY = 0xAA;\
														      EA = temp;\
										   }while(0)
/*****************************************************************************
 ** \brief	 WDT_ConfigTim
 **			 WDCONĴ
 ** \param [in] ValWDCONĴҪõֵ
 **
 ** \return none
 ** \note
 *****************************************************************************/
#define WDT_ConfigTim(Val)   do{\
																	uint8_t temp = EA;\		
														      EA = 0;\
														      _nop_();\
																	TA = 0xAA;\
																	TA = 0x55;\
														      WDCON = Val;\
														      EA = temp;\
										   }while(0)												 
/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
  /*****************************************************************************
 ** \brief	 WDT_ConfigOverflowTime
 **			WDTʱ
 ** \param [in] TsysCoefficient : (1)WDT_CLK_256 	
 **								  (2)WDT_CLK_512 	
 **								  (3)WDT_CLK_1024 	
 **								  (4)WDT_CLK_2048	
 **								  (5)WDT_CLK_4096  
 **								  (6)WDT_CLK_16384	
 **								  (7)WDT_CLK_32768  
 **								  (8)WDT_CLK_131072 
 ** \return none 
 ** \note	Flsi =32.768KHz,      (1)WDT_CLK_256  , ʱ= Tsys * 256 = 7.8125ms
 **								  (2)WDT_CLK_512 	,   ʱ= Tsys * 512 	 = 15.625ms
 **								  (3)WDT_CLK_1024 ,   ʱ= Tsys * 1024   = 31.25ms
 **								  (4)WDT_CLK_2048	,   ʱ= Tsys * 2048	 = 62.5ms
 **								  (5)WDT_CLK_4096  ,  ʱ= Tsys * 4096   = 125ms
 **								  (6)WDT_CLK_16384	, ʱ= Tsys * 16384  = 0.5s
 **								  (7)WDT_CLK_32768  , ʱ= Tsys * 32768  = 1s 
 **								  (8)WDT_CLK_131072 , ʱ= Tsys * 131072 = 4s
 *****************************************************************************/
void  WDT_ConfigOverflowTime(uint8_t TsysCoefficient);



#endif /* __WDT_H__ */
