/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file led.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __LED_H__
#define __LED_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **LEDģʽ
 ---------------------------------------------------------------------------*/
/*-----ģʽ---------------------------------------------------------*/
#define LED_DUTY_4			(0x3)		/*1/4 DUTY*/
#define LED_DUTY_5			(0x2)		/*1/5 DUTY*/
#define LED_DUTY_6			(0x1)		/*1/6 DUTY*/
#define LED_DUTY_8			(0x0)		/*1/8 DUTY*/

#define LED_COM_CATHODE	(0x00)		/*ģʽ*/
#define LED_COM_ANODE		(0x01)		/*ģʽ*/
/*----------------------------------------------------------------------------
 **LED ʱѡ񣨾
 ---------------------------------------------------------------------------*/
#define LED_CLK_32Tfix  0			/*LEDʱ32*Tfix--4us*/
#define LED_CLK_64Tfix  1			/*LEDʱ64*Tfix--8us*/
#define LED_CLK_128Tfix 2			/*LEDʱ128*Tfix--16us*/
#define LED_CLK_256Tfix 3			/*LEDʱ256*Tfix--32us*/
/*----------------------------------------------------------------------------
 **LED 
 ---------------------------------------------------------------------------*/
#define LED_DRVC_0mA    0x00			/*LEDSEG0mA   */
#define LED_DRVC_4d9mA  0x01			/*LEDSEG4.9mA */
#define LED_DRVC_7d4mA  0x02			/*LEDSEG7.4mA */
#define LED_DRVC_12d2mA 0x03			/*LEDSEG12.2mA*/
#define LED_DRVC_14d7mA 0x04			/*LEDSEG14.7mA*/
#define LED_DRVC_19d5mA 0x05			/*LEDSEG19.5mA*/
#define LED_DRVC_22d1mA 0x06			/*LEDSEG22.1mA*/
#define LED_DRVC_26d9mA 0x07			/*LEDSEG26.9mA*/
#define LED_DRVC_31d8mA 0x09			/*LEDSEG31.8mA*/
#define LED_DRVC_34d3mA 0x0A			/*LEDSEG34.3mA*/
#define LED_DRVC_39d2mA 0x0B			/*LEDSEG39.2mA*/
#define LED_DRVC_41d6mA 0x0C			/*LEDSEG41.6mA*/
#define LED_DRVC_46d1mA 0x0D			/*LEDSEG46.1mA*/
#define LED_DRVC_49mA   0x0E			/*LEDSEG49mA  */
#define LED_DRVC_50mA   0x0F			/*LEDSEG50mA  */

/*----------------------------------------------------------------------------
 **LED ʱ䣨
 ---------------------------------------------------------------------------*/
#define LED_MatDTim_8Tfix    0x00			/*LEDʱ8Tfix--1us  */
#define LED_MatDTim_16Tfix   0x01			/*LEDʱ16Tfix--2us  */
#define LED_MatDTim_32Tfix   0x02			/*LEDʱ32Tfix--4us  */
#define LED_MatDTim_64Tfix   0x03			/*LEDʱ64Tfix--8us  */

/*-----ģʽ---------------------------------------------------------*/
#define LED_LATTICE_4X4		(0x01)		/*4*4*/
#define LED_LATTICE_5X5		(0x02)		/*5*5*/
#define LED_LATTICE_6X6		(0x03)		/*6*6*/
#define LED_LATTICE_6X7		(0x04)		/*6*7*/
#define LED_LATTICE_7X7		(0x05)		/*7*7*/
#define LED_LATTICE_7X8		(0x06)		/*7*8*/
#define LED_LATTICE_8X8		(0x07)		/*8*8*/

#define LED_SCAN_INTERRUPT	(0x00)	/*жɨģʽ*/
#define LED_SCAN_LOOP		    (0x01)	/*ѭɨģʽ*/
/*----------------------------------------------------------------------------
 **LED ʱѡ񣨵
 ---------------------------------------------------------------------------*/
#define LED_CLK_32Tfix  0			/*LEDʱ32Tfix--4us */
#define LED_CLK_64Tfix  1			/*LEDʱ64Tfix--8us */
#define LED_CLK_128Tfix 2			/*LEDʱ128Tfix--16us*/
#define LED_CLK_256Tfix 3			/*LEDʱ256Tfix--32us*/
/*----------------------------------------------------------------------------
 **LED ʱ䣨
 ---------------------------------------------------------------------------*/
#define LED_LatDTim_12Tfix   0x00			/*LEDʱ12Tfix--1.5us  */
#define LED_LatDTim_24Tfix   0x01			/*LEDʱ24Tfix--3us  */
#define LED_LatDTim_48Tfix   0x02			/*LEDʱ48Tfix--6us  */
#define LED_LatDTim_96Tfix   0x03			/*LEDʱ96Tfix--12us  */
/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/



/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/
/*****************************************************************************
 ** \brief	 LED_EnableMatrixMode
 **			 ʹLEDģʽ
 ** \param [in] none		
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableMatrixMode(void);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixMode
 **			 LEDģʽ
 ** \param [in] Duty:	(1) LED_DUTY_4
 **						(2)	LED_DUTY_5
 **						(3)	LED_DUTY_6
 **						(4)	LED_DUTY_8	  
 **				Common:	(1) LED_COM_CATHODE			ģʽ
 **						(2)	LED_COM_ANODE   		ģʽ			
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixMode(uint8_t Duty, uint8_t Common);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixClk
 **			 LEDģʽʱ
 ** \param [in] ClkDiv: LED_CLK_4us,LED_CLK_8us,LED_CLK_16us,LED_CLK_32us
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixClk(uint16_t ClkDiv);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixDeadTime
 **			 LEDģʽʱ
 ** \param [in] DTim:  LED_MatDTim_8Tfix,LED_MatDTim_16Tfix,
 **                       LED_MatDTim_32Tfix,LED_MatDTim_64Tfix
 ** \return  none
 ** \note Tfix=8MHz  
******************************************************************************/
void LED_ConfigMatrixDeadTime(uint16_t DTim);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixComTime
 **			 þģʽCOMЧʱ
 ** \param [in] Time  0x01~0xff
 ** \return  none
 ** \note   ֹó0x00
******************************************************************************/
void LED_ConfigMatrixComTime(uint8_t Time);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixComTime
 **			 þģʽSEGЧʱ
 ** \param [in] Time  0x01~0xff
 ** \return  none
 ** \note   ֹó0x00
******************************************************************************/
void LED_ConfigMatrixSegTime(uint8_t Time);
/*****************************************************************************
 ** \brief	 LED_ConfigMatrixSegCurrent
 **			 þģʽSEG
 ** \param [in] Time  LED_DRVC_0mA~LED_DRVC_50mA
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigMatrixSegCurrent(uint8_t LCurrent);
/*****************************************************************************
 ** \brief	 LED_StartMatrix
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StartMatrix(void);
/*****************************************************************************
 ** \brief	 LED_StopMatrix
 **			 ֹͣLED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StopMatrix(void);


/*****************************************************************************
 ** \brief	 LED_EnableLatticeMode
 **			 ʹLEDģʽ
 ** \param [in] none		
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableLatticeMode(void);
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeMode
 **			 LEDģʽ
 ** \param [in] Mode:	(1) LED_LATTICE_4X4			4*4
 **						(2)	LED_LATTICE_5X5			5*5
 **						(3)	LED_LATTICE_6X6			6*6
 **						(4)	LED_LATTICE_6X7			6*7
 **						(5)	LED_LATTICE_7X7			7*7
 **						(6)	LED_LATTICE_7X8			7*8
 **						(7)	LED_LATTICE_8X8 		8*8
 **				Scan:	(1) LED_SCAN_INTERRUPT		жɨģʽ
 **						(2)	LED_SCAN_LOOP   		ѭɨģʽ			
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticeMode(uint8_t Mode, uint8_t Scan);
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeClk
 **			 LEDģʽʱӷƵ
 ** \param [in] ClkDiv:LED_CLK_32Tfix,LED_CLK_64Tfix,LED_CLK_128Tfix,LED_CLK_256Tfix
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticeClk(uint16_t ClkDiv);
/*****************************************************************************
 ** \brief	 LED_ConfigLatticeDeadTime
 **			 LEDģʽʱ
 ** \param [in] DTim:  LED_LatDTim_12Tfix,LED_LatDTim_24Tfix,
 **                       LED_LatDTim_48Tfix,LED_LatDTim_96Tfix
 ** \return  none
 ** \note Tfix=8MHz  
******************************************************************************/
void LED_ConfigLatticeDeadTime(uint16_t DTim);
/*****************************************************************************
 ** \brief	 LED_ConfigLatticePeriod1
 **			 LEDģʽ1
 ** \param [in] Period: 0x00~0xff
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticePeriod1(uint8_t Period);
/*****************************************************************************
 ** \brief	 LED_ConfigLatticePeriod2
 **			 LEDģʽ2
 ** \param [in] Period: 0x00~0xff
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ConfigLatticePeriod2(uint8_t Period);
/*****************************************************************************
 ** \brief	 LED_StartLattice
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StartLattice(void);
/*****************************************************************************
 ** \brief	 LED_StopLattice
 **			 ֹͣLED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_StopLattice(void);
/*****************************************************************************
 ** \brief	 LED_RestartLattice
 **			 LED
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_RestartLattice(void);


/*****************************************************************************
 ** \brief	 LED_EnableInt
 **			 ʹLEDģʽж
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_EnableInt(void);
/*****************************************************************************
 ** \brief	 LED_DisableInt
 **			 رLEDģʽж
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_DisableInt(void);
/*****************************************************************************
 ** \brief	 LED_GetIntFlag
 **			 ȡLEDģʽжϱ־
 ** \param [in] none
 ** \return  0:ж  1:ж
 ** \note   
******************************************************************************/
uint8_t LED_GetIntFlag(void);
/*****************************************************************************
 ** \brief	 LED_ClearIntFlag
 **			 LEDģʽжϱ־
 ** \param [in] none
 ** \return  none
 ** \note   
******************************************************************************/
void LED_ClearIntFlag(void);



#endif /* __LED_H__ */
