/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file i2c.h
**
** History:
** 
*****************************************************************************/
#ifndef __I2C_H_
#define __I2C_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 ** I2C ӻģʽַ:
-----------------------------------------------------------------------------*/
#define		I2C_S_7BIT_ADDR		  (0x0UL)	
#define		I2C_S_10BIT_ADDR		(0x4UL)

#define		I2C_S_BROADCAST_EN		(0x01UL)		/*ʹܹ㲥еַʶ*/
#define		I2C_S_BROADCAST_DIS		(0x00UL)		/*ֹ㲥еַʶ*/

/*----------------------------------------------------------------------------
 ** I2C ״̬
-----------------------------------------------------------------------------*/
#define		I2C_STATUS_NOTHING				(0xF8UL)		/*ȷе״̬*/
/*----------------------------------------------------------------------------
** I2Cģʽµ״̬(MS: MASTER STATUS)
-----------------------------------------------------------------------------*/
#define		I2C_MS_BUS_ERROR				(0x00UL)		/*ߴֻģʽЧ*/
#define		I2C_MS_START_OK					(0x08UL)		/*λ*/
#define		I2C_MS_RESTART_OK				(0x10UL)		/*λ*/
#define		I2C_MS_SEND_ADDR_W_ACK			(0x18UL)		/*ַ+дλɣյACK*/
#define		I2C_MS_SEND_ADDR_W_NO_ACK		(0x20UL)		/*ַ+дλɣδյACK*/
#define		I2C_MS_SEND_DAT_ACK				(0x28UL)		/*ģʽݷɣյACK*/
#define		I2C_MS_SEND_DAT_NO_ACK			(0x30UL)		/*ģʽݷɣδյACK*/
#define		I2C_MS_TRANS_FAIL				(0x38UL)		/*ڵַݴʧ*/
#define		I2C_MS_SEND_ADDR_R_ACK			(0x40UL)		/*ַ+λɣյACK*/
#define		I2C_MS_SEND_ADDR_R_NO_ACK		(0x48UL)		/*ַ+λɣδյACK*/
#define		I2C_MS_READ_DAT_ACK				(0x50UL)		/*ģʽ½յݣظACK*/
#define		I2C_MS_READ_DAT_NO_ACK			(0x58UL)		/*ģʽ½յݣظACK*/
#define		I2C_MS_SEND_SECOND_ADDR_ACK		(0xE0UL)		/*ģʽ·ڶַյACK*/
#define		I2C_MS_SEND_SECOND_ADDR_NO_ACK	(0xE8UL)		/*ģʽ·ڶַδյACK*/

/*----------------------------------------------------------------------------
 ** I2C ӻģʽµ״̬(SS: SLAVE STATUS)
-----------------------------------------------------------------------------*/
#define		I2C_SS_RECEIVE_ADDR_W				(0x60UL)			/*ӻģʽ½յַ+дλظACK*/	
#define		I2C_SS_ARL_RECEIVE_ADDR_W			(0x68UL)			/*ٲʧܣյӻַ+дλظACK*/	
#define		I2C_SS_RECEIVE_BORADCAST_ACK		(0x70UL)			/*յ㲥еַظACK*/	
#define		I2C_SS_ARL_RECEIVE_BORADCAST_ACK	(0x78UL)		/*ٲʧܣյ㲥еַظACK*/	
#define		I2C_SS_RECEIVE_DAT_ACK				(0x80UL)			/*ӻַƥյݣظACK*/
#define		I2C_SS_RECEIVE_DAT_NO_ACK			(0x88UL)			/*ӻַƥյݣظACK*/
#define		I2C_SS_BORADCAST_RECEIVE_DAT_ACK	(0x90UL)		/*ӻչ㲥еַյݣظACK*/
#define		I2C_SS_BORADCAST_RECEIVE_DAT_NO_ACK	(0x98UL)		/*ӻչ㲥еַյݣظACK*/
#define		I2C_SS_RECEIVE_STOP_OR_RESTART		(0xA0UL)			/*ӻģʽ½յֹͣźŻź*/
#define		I2C_SS_RECEIVE_ADDR_R_ACK			(0xA8UL)			/*ӻģʽ½յַ+λظACK*/
#define		I2C_SS_ARL_RECEIVE_ADDR_R_ACK		(0xB0UL)			/*ٲʧܣյӻַ+λظACK*/
#define		I2C_SS_SEND_DAT_ACK					(0xB8UL)			/*ӻģʽ·ݺ󣬽յACK*/
#define		I2C_SS_SEND_DAT_NO_ACK				(0xC0UL)			/*ӻģʽ·ݺδյACK*/
#define		I2C_SS_SEND_LAST_DAT_ACK			(0xC8UL)		/*ӻģʽ·һݣյACK*/
#define		I2C_SS_SEND_LAST_DAT_NO_ACK			(0xD0UL)		/*ӻģʽ·һݣδյACK*/



/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/


/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/

/*****************************************************************************
 ** \brief	I2C_ConfigClk
 **			I2Cʱ
 ** \param [in] CLK_M: 0x00~0x7;
 **				CLK_N: 0x00~0xf;
 ** \return  none
 ** \note	ʱ= PCLK/2M   SCLʱ= PCLK/2MN+110
 ** \note	ʱ10ͨѶʱ
*****************************************************************************/
void	I2C_ConfigClk(uint32_t CLK_M, uint32_t CLK_N);

/*****************************************************************************
 ** \brief	I2C_EnableOutput
 **			I2Cӿ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void	I2C_EnableOutput(void);

/*****************************************************************************
 ** \brief	I2C_DisableOutput
 **			رI2Cӿ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_DisableOutput(void);

/*****************************************************************************
 ** \brief	I2C_EnableInt
 **			I2Cж
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_EnableInt(void);
/*****************************************************************************
 ** \brief	I2C_DisableInt
 **			رI2Cж
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_DisableInt(void);

/*****************************************************************************
 ** \brief	I2C_GetIntFlag
 **			ȡжϱ־λ
 ** \param [in] none
 ** \return  0I2C״̬δı  1I2C״̬ı
 ** \note	
*****************************************************************************/
uint32_t I2C_GetIntFlag(void);

/*****************************************************************************
 ** \brief	I2C_ClearIntFlag
 **			I2Cжϱ־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearIntFlag(void);

/*****************************************************************************
 ** \brief	I2C_ClearStartFlag
 **			I2C־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearStartFlag(void);
/*****************************************************************************
 ** \brief	I2C_ClearACKFlag
 **			I2CӦ־
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ClearACKFlag(void);

/*****************************************************************************
 ** \brief	I2C_GetStatus
 **			ȡI2C״̬
 ** \param [in] none
 ** \return  Status
 ** \note	
*****************************************************************************/
uint32_t I2C_GetStatus(void);

/*****************************************************************************
 ** \brief	I2C_ConfigSlaveAddr
 **			ôӻģʽַ
 ** \param [in] Slave: I2C_S_7BIT_ADDR, I2C_S_10BIT_ADDR
 **				addr: 7λַ 10λַ
 **				Broadcast: I2C_S_BROADCAST_EN I2C_S_BROADCAST_DIS
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_ConfigSlaveModeAddr(uint32_t Slave, uint32_t Addr, uint32_t Broadcast);
/*****************************************************************************
 ** \brief	I2C_GetSlave10BitAddrFlag
 **			ȡI2C ӻ10λַ־λ
 ** \param [in] none
 ** \return 0:I2Cַƥ   1: 12C 10λַƥ
 ** \note	
*****************************************************************************/
uint32_t I2C_GetSlave10BitAddrFlag(void);
/*****************************************************************************
 ** \brief	I2C_GetSlave7BitAddrFlag
 **			ȡI2C ӻ7λַ־λ
 ** \param [in] none
 ** \return 0:I2Cַƥ   1: 12C 10λַƥ
 ** \note	
*****************************************************************************/
uint32_t I2C_GetSlave7BitAddrFlag(void);

/*****************************************************************************
 ** \brief	I2C_Reset
 **			λI2Cģ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_Reset(void);

/*****************************************************************************
 ** \brief	I2C_SendData
 **			
 ** \param [in] I2CData
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendData(uint8_t I2CData);
/*****************************************************************************
 ** \brief	I2C_SendACK
 **			Ӧλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendACK(void);
/*****************************************************************************
 ** \brief	I2C_NotSendACK
 **			Ӧλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_NotSendACK(void);
/*****************************************************************************
 ** \brief	I2C_SendStart
 **			ʼλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStart(void);
/*****************************************************************************
 ** \brief	I2C_SendRestart
 **			λ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendRestart(void);
/*****************************************************************************
 ** \brief	I2C_SendStop
 **			ֹͣλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStop(void);
/*****************************************************************************
 ** \brief	I2C_SendStopBeforeStart
 **			ȷһֹͣλŷһλ
 ** \param [in] none
 ** \return  none
 ** \note	
*****************************************************************************/
void I2C_SendStopBeforeStart(void);

/*****************************************************************************
 ** \brief	I2C_GetData
 **			ȡ
 ** \param [in] none
 ** \return  Data
 ** \note	
*****************************************************************************/
uint32_t I2C_GetData(void);





#ifdef __cplusplus
}
#endif

#endif /* __I2C_H_ */

