/*******************************************************************************
* Copyright (C) 2019 China Micro Semiconductor Limited Company. All Rights Reserved.
*
* This software is owned and published by:
* CMS LLC, 21F, Building T1, Qianhai Financial Center, No.91 Guiwan 3rd Road, 
* Qianhai Shenzhen-Hong Kong Cooperation Zone, Shenzhen City , Guangdong Province , 
* P R China.
*
* BY DOWNLOADING, INSTALLING OR USING THIS SOFTWARE, YOU AGREE TO BE BOUND
* BY ALL THE TERMS AND CONDITIONS OF THIS AGREEMENT.
*
* This software contains source code for use with CMS
* components. This software is licensed by CMS to be adapted only
* for use in systems utilizing CMS components. CMS shall not be
* responsible for misuse or illegal use of this software for devices not
* supported herein. CMS is providing this software "AS IS" and will
* not be responsible for issues arising from incorrect user implementation
* of the software.
*
* This software may be replicated in part or whole for the licensed use,
* with the restriction that this Disclaimer and Copyright notice must be
* included with each copy of this software, whether used in part or whole,
* at all times.
*/

/*****************************************************************************/
/** \file gpio.h
**
** 
**
** History:
** 
*****************************************************************************/
#ifndef __GPIO_H__
#define __GPIO_H__
/*****************************************************************************/
/* Include files */
/*****************************************************************************/
#include "cms80f752xx.h"
/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define') */
/*****************************************************************************/
/*----------------------------------------------------------------------------
 **GPIO
 ---------------------------------------------------------------------------*/
#define  GPIO_PIN_0_MSK				(0x01)		/* GPIO Pin 0 mask */
#define  GPIO_PIN_1_MSK				(0x02)		/* GPIO Pin 1 mask */
#define  GPIO_PIN_2_MSK				(0x04)		/* GPIO Pin 2 mask */
#define  GPIO_PIN_3_MSK				(0x08)		/* GPIO Pin 3 mask */
#define  GPIO_PIN_4_MSK				(0x10)		/* GPIO Pin 4 mask */
#define  GPIO_PIN_5_MSK				(0x20)		/* GPIO Pin 5 mask */
#define  GPIO_PIN_6_MSK				(0x40)		/* GPIO Pin 6 mask */
#define  GPIO_PIN_7_MSK				(0x80)		/* GPIO Pin 7 mask */

#define  GPIO_PIN_0					(0x00)		/* GPIO Pin 0 number*/
#define  GPIO_PIN_1					(0x01)		/* GPIO Pin 1 number */
#define  GPIO_PIN_2					(0x02)		/* GPIO Pin 2 number */
#define  GPIO_PIN_3					(0x03)		/* GPIO Pin 3 number */
#define  GPIO_PIN_4					(0x04)		/* GPIO Pin 4 number */
#define  GPIO_PIN_5					(0x05)		/* GPIO Pin 5 number */
#define  GPIO_PIN_6					(0x06)		/* GPIO Pin 6 number */
#define  GPIO_PIN_7					(0x07)		/* GPIO Pin 7 number */

/***************************************************************
EINT0((PS_EINT0)), EINT1(PS_EINT1), EINT2(PS_EINT2), 
EINT3(PS_EINT3),UART1RXD(PS_RXD1)UART1TXD(PS_TXD1)
****************************************************************/
#define  GPIO0						(0x00)
#define  GPIO1						(0x01)
#define  GPIO2						(0x02)
#define  GPIO3						(0x03)
#define  GPIO4						(0x04)
#define  GPIO5						(0x05)

#define  GPIO_P00					(0x00)
#define  GPIO_P01					(0x01)
#define  GPIO_P02					(0x02)
#define  GPIO_P03					(0x03)
#define  GPIO_P04					(0x04)
#define  GPIO_P05					(0x05)
#define  GPIO_P06					(0x06)
#define  GPIO_P07					(0x07)

#define  GPIO_P10					(0x10)
#define  GPIO_P11					(0x11)
#define  GPIO_P12					(0x12)
#define  GPIO_P13					(0x13)
#define  GPIO_P14					(0x14)
#define  GPIO_P15					(0x15)
#define  GPIO_P16					(0x16)
#define  GPIO_P17					(0x17)

#define  GPIO_P20					(0x20)
#define  GPIO_P21					(0x21)
#define  GPIO_P22					(0x22)
#define  GPIO_P23					(0x23)
#define  GPIO_P24					(0x24)
#define  GPIO_P25					(0x25)
#define  GPIO_P26					(0x26)
#define  GPIO_P27					(0x27)

#define  GPIO_P50					(0x50)
#define  GPIO_P51					(0x51)
#define  GPIO_P52					(0x52)
#define  GPIO_P53					(0x53)
#define  GPIO_P54					(0x54)
#define  GPIO_P55					(0x55)

/*----------------------------------------------------------------------------
 ** IOŸģʽ
---------------------------------------------------------------------------*/
/*--Timer01ⲿʱͨ(PS_T0\(PS_T1))-----------------------------------------------*/
#define  GPIO_TMR01_MUX_P03	  (0x00)
#define  GPIO_TMR01_MUX_P13	  (0x01)
#define  GPIO_TMR01_MUX_P23	  (0x02)
/*--Timer01ſͨ(PS_T0G\(PS_T1G))-----------------------------------------------*/
#define  GPIO_TMR01GT_MUX_P02	(0x00)
#define  GPIO_TMR01GT_MUX_P12	(0x01)
#define  GPIO_TMR01GT_MUX_P22	(0x02)
/*--Timer2ⲿ¼ſͨ(PS_T2)-----------------------------------------------*/
#define  GPIO_TMR2EVTGT_MUX_P03	  (0x00)
#define  GPIO_TMR2EVTGT_MUX_P13	  (0x01)
#define  GPIO_TMR2EVTGT_MUX_P23	  (0x02)
/*--Timer2½Զͨ(PS_T2EX)-----------------------------------------------*/
#define  GPIO_TMR2AUTRLD_MUX_P02	(0x00)
#define  GPIO_TMR2AUTRLD_MUX_P12	(0x01)
#define  GPIO_TMR2AUTRLD_MUX_P22	(0x02)
/*--UART0ͨ(PS_RXD0)-----------------------------------------------*/
#define  GPIO_UART0RXD_MUX_P04	(0x00)
#define  GPIO_UART0RXD_MUX_P05	(0x01)
#define  GPIO_UART0RXD_MUX_P14	(0x02)
#define  GPIO_UART0RXD_MUX_P15	(0x03)
#define  GPIO_UART0RXD_MUX_P24	(0x04)
#define  GPIO_UART0RXD_MUX_P25	(0x05)
#define  GPIO_UART0RXD_MUX_P54	(0x06)
#define  GPIO_UART0RXD_MUX_P55	(0x07)
/*--UART0ͨ(PS_TXD0)-----------------------------------------------*/
#define  GPIO_UART0TXD_MUX_P04	(0x00)
#define  GPIO_UART0TXD_MUX_P05	(0x01)
#define  GPIO_UART0TXD_MUX_P14	(0x02)
#define  GPIO_UART0TXD_MUX_P15	(0x03)
#define  GPIO_UART0TXD_MUX_P24	(0x04)
#define  GPIO_UART0TXD_MUX_P25	(0x05)
#define  GPIO_UART0TXD_MUX_P54	(0x06)
#define  GPIO_UART0TXD_MUX_P55	(0x07)
/*--IIC SCLͨ(PS_SCL)-----------------------------------------------*/
#define  GPIO_IICSCL_MUX_P00	(0x00)
#define  GPIO_IICSCL_MUX_P10	(0x01)
#define  GPIO_IICSCL_MUX_P20	(0x02)
#define  GPIO_IICSCL_MUX_P50	(0x03)
/*--IIC SDAͨ(PS_SDA)-----------------------------------------------*/
#define  GPIO_IICSDA_MUX_P01	(0x00)
#define  GPIO_IICSDA_MUX_P11	(0x01)
#define  GPIO_IICSDA_MUX_P21	(0x02)
#define  GPIO_IICSDA_MUX_P51	(0x03)
/*--SPI SCLKͨ(PS_SCLKOI)-----------------------------------------------*/
#define  GPIO_SPISCLK_MUX_P00	(0x00)
#define  GPIO_SPISCLK_MUX_P10	(0x01)
#define  GPIO_SPISCLK_MUX_P20	(0x02)
#define  GPIO_SPISCLK_MUX_P50	(0x03)
/*--SPI MOSIͨ(PS_MOSI)-----------------------------------------------*/
#define  GPIO_SPIMOSI_MUX_P01	(0x00)
#define  GPIO_SPIMOSI_MUX_P11	(0x01)
#define  GPIO_SPIMOSI_MUX_P21	(0x02)
#define  GPIO_SPIMOSI_MUX_P51	(0x03)
/*--SPI MISOͨ(PS_MISO)-----------------------------------------------*/
#define  GPIO_SPIMISO_MUX_P02	(0x00)
#define  GPIO_SPIMISO_MUX_P12	(0x01)
#define  GPIO_SPIMISO_MUX_P22	(0x02)
#define  GPIO_SPIMISO_MUX_P52	(0x03)
/*--SPI NSS0ͨ(PS_NSS0OI)-----------------------------------------------*/
#define  GPIO_SPINSS0_MUX_P03	(0x00)
#define  GPIO_SPINSS0_MUX_P13	(0x01)
#define  GPIO_SPINSS0_MUX_P23	(0x02)
#define  GPIO_SPINSS0_MUX_P53	(0x03)
/*--SPI NSS1ͨ(PS_NSS1OI)-----------------------------------------------*/
#define  GPIO_SPINSS1_MUX_P04	(0x00)
#define  GPIO_SPINSS1_MUX_P14	(0x01)
#define  GPIO_SPINSS1_MUX_P24	(0x02)
#define  GPIO_SPINSS1_MUX_P54	(0x03)
/*--SPI NSS2ͨ(PS_NSS2OI)-----------------------------------------------*/
#define  GPIO_SPINSS2_MUX_P05	(0x00)
#define  GPIO_SPINSS2_MUX_P15	(0x01)
#define  GPIO_SPINSS2_MUX_P25	(0x02)
#define  GPIO_SPINSS2_MUX_P55	(0x03)
/*--SPI NSS3ͨ(PS_NSS3OI)-----------------------------------------------*/
#define  GPIO_SPINSS3_MUX_P06	(0x00)
#define  GPIO_SPINSS3_MUX_P16	(0x01)
#define  GPIO_SPINSS3_MUX_P26	(0x02)
/*--TIMER2Ƚͨ0˿(PS_CC0)-----------------------------------------------*/
#define  GPIO_TMR2CH0_MUX_P00	(0x00)
#define  GPIO_TMR2CH0_MUX_P20	(0x01)
/*--TIMER2Ƚͨ1˿(PS_CC1)-----------------------------------------------*/
#define  GPIO_TMR2CH1_MUX_P01	(0x00)
#define  GPIO_TMR2CH1_MUX_P21	(0x01)
/*--PWMͨ0˿(PS_PG0)-----------------------------------------------*/
#define  GPIO_PWMCH0_MUX_P00	(0x00)
#define  GPIO_PWMCH0_MUX_P10	(0x01)
#define  GPIO_PWMCH0_MUX_P20	(0x02)
#define  GPIO_PWMCH0_MUX_P50	(0x03)
/*--PWMͨ1˿(PS_PG1)-----------------------------------------------*/
#define  GPIO_PWMCH1_MUX_P01	(0x00)
#define  GPIO_PWMCH1_MUX_P11	(0x01)
#define  GPIO_PWMCH1_MUX_P21	(0x02)
#define  GPIO_PWMCH1_MUX_P51	(0x03)
/*--PWMͨ2˿(PS_PG2)-----------------------------------------------*/
#define  GPIO_PWMCH2_MUX_P02	(0x00)
#define  GPIO_PWMCH2_MUX_P12	(0x01)
#define  GPIO_PWMCH2_MUX_P22	(0x02)
#define  GPIO_PWMCH2_MUX_P52	(0x03)
/*--PWMͨ3˿(PS_PG3)-----------------------------------------------*/
#define  GPIO_PWMCH3_MUX_P03	(0x00)
#define  GPIO_PWMCH3_MUX_P13	(0x01)
#define  GPIO_PWMCH3_MUX_P23	(0x02)
#define  GPIO_PWMCH3_MUX_P53	(0x03)
/*--PWMͨ4˿(PS_PG4)-----------------------------------------------*/
#define  GPIO_PWMCH4_MUX_P04	(0x00)
#define  GPIO_PWMCH4_MUX_P14	(0x01)
#define  GPIO_PWMCH4_MUX_P24	(0x02)
#define  GPIO_PWMCH4_MUX_P54	(0x03)
/*--PWMͨ5˿(PS_PG5)-----------------------------------------------*/
#define  GPIO_PWMCH5_MUX_P05	(0x00)
#define  GPIO_PWMCH5_MUX_P15	(0x01)
#define  GPIO_PWMCH5_MUX_P25	(0x02)
#define  GPIO_PWMCH5_MUX_P55	(0x03)
/*--CLOCK OUTͨ(PS_CLO)-----------------------------------------------*/
#define  GPIO_CLKO_MUX_P07	(0x00)
#define  GPIO_CLKO_MUX_P17	(0x01)
#define  GPIO_CLKO_MUX_P10	(0x02)

/********************************************************************************
 ** \brief	 GPIO_SETBIT
 **			 λGPIOλ
 ** \param [in] Portx P0,P1,P2,P5 
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define	 GPIO_SETBIT(Portx, PinNum)	(Portx |= (1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_CLRBIT
 **			 GPIOλ
 ** \param [in] Portx P0,P1,P2,P5 
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define	 GPIO_CLRBIT(Portx, PinNum)	(Portx &= ~(1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_SET_PS_MODE
 **			 ö˿빦ܷ
 ** \param [in]  Ps_mode: PS_EINT0  PS_EINT1..... PS_CLO
 **				 gpio:	(1)GPIO_P00 .... GPIO_P55
 **						(2)GPIO_TMR01_MUX_P03....GPIO_CLKO_MUX_P10
 ** \return  none
********************************************************************************/
#define  GPIO_SET_PS_MODE(Ps_mode,gpio)		(Ps_mode = gpio)	

/********************************************************************************
 ** \brief	 GPIO_ENABLE_DIGITAL
 **			 ʹGPIOΪֹ
 ** \param [in] PortTRIS Ĵ P0DIG,P1DIG,P2DIG,P5DIG 
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define	 GPIO_ENABLE_DIGITAL(PortDIG, PinNum)	(PortDIG |= (1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_ENABLE_DIGITAL
 **			 ʹGPIOΪģ⹦
 ** \param [in] PortTRIS Ĵ P0DIG,P1DIG,P2DIG,P5DIG 
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define	 GPIO_ENABLE_ANALOG(PortANA, PinNum)	(PortANA &= ~(1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_ENABLE_OUTPUT
 **			 ʹGPIOΪģʽ
 ** \param [in] PortTRIS Ĵ P0TRIS,P1TRIS,P2TRIS,P5TRIS  
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define	 GPIO_ENABLE_OUTPUT(PortTRIS, PinNum)	(PortTRIS |= (1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_ENABLE_INPUT
 **			 ʹGPIOΪ̬ģʽ
 ** \param [in] PortTRIS Ĵ P0TRIS,P1TRIS,P2TRIS,P5TRIS 
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_ENABLE_INPUT(PortTRIS, PinNum)	(PortTRIS &= ~(1<<PinNum))

/********************************************************************************
 ** \brief	 GPIO_ENABLE_OD
 **			 GPIO©ܿ
 ** \param [in] PortOD  :©ܼĴ P0OD,P1OD,P2OD,P5OD
 **            PinNum GPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_ENABLE_OD(PortOD, PinNum)			(PortOD |= (1<<PinNum))
/********************************************************************************
 ** \brief	 GPIO_DISABLE_OD
 **			 GPIO©ܹر
 ** \param [in] PortOD  :©ܼĴP0OD,P1OD,P2OD,P5OD
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_DISABLE_OD(PortOD, PinNum)		(PortOD &= ~(1<<PinNum))
/********************************************************************************
 ** \brief	 GPIO_ENABLE_UP
 **			 GPIOܿ
 ** \param [in] PortUP  :ܼĴP0UP,P1UP,P2UP,P5UP
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_ENABLE_UP(PortUP, PinNum)			(PortUP |= (1<<PinNum))
/********************************************************************************
 ** \brief	 GPIO_DISABLE_UP
 **			 GPIOܹر
 ** \param [in] PortUP  :ܼĴP0UP,P1UP,P2UP,P5UP
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_DISABLE_UP(PortUP, PinNum)		(PortUP &= ~(1<<PinNum))
/********************************************************************************
 ** \brief	 GPIO_ENABLE_RD
 **			 GPIOܿ
 ** \param [in] PortRD  :ܼĴP0RD,P1RD,P2RD,P5RD
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_ENABLE_RD(PortRD, PinNum)			(PortRD |= (1<<PinNum))
/********************************************************************************
 ** \brief	 GPIO_DISABLE_RD
 **			 GPIOܹر
 ** \param [in] PortRD  :ܼĴP0RD,P1RD,P2RD,P5RD
 **            PinNumGPIO_PIN_0...GPIO_PIN_7
 ** \return  none
 ******************************************************************************/
#define  GPIO_DISABLE_RD(PortRD, PinNum)		(PortRD &= ~(1<<PinNum))

/*----------------------------------------------------------------------------
 **GPIO жϴģʽ
/*---------------------------------------------------------------------------*/
#define  GPIO_INT_NONE	    (0x00)			/*жϽֹ*/
#define  GPIO_INT_RISING	  (0x01)			/*شж*/
#define  GPIO_INT_FALLING	  (0x02)			/*½شж*/
#define  GPIO_INT_BOTH_EDGE	(0x03)			/*½ؾж*/

typedef enum
{
	EINT00 = 0,
	EINT01 = 1,
	EINT02 = 2,
	EINT03 = 3,
}EINTx_CH_t;

/*****************************************************************************/
/* Global type definitions ('typedef') */
/*****************************************************************************/


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source) */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source) */
/*****************************************************************************/

 /********************************************************************************
 ** \brief	 GPIO_EINTx_Enable
 **			 ʹչж
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03		 
 ** \return  none
 ** \note   
 ******************************************************************************/
void GPIO_EINTx_Enable(EINTx_CH_t EINTCH);
/********************************************************************************
 ** \brief	 GPIO_EINTx_Disable
 **			 رչж
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03	 
 ** \return  none
 ** \note   
 ******************************************************************************/
void GPIO_EINTx_Disable(EINTx_CH_t EINTCH);

 /******************************************************************************
 ** \brief	 GPIO_EINTx_GetFlag
 **			 ȡжϱ־
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03 
 ** \return  0жϲ
 **			 1жϲ
 ** \note  
 ******************************************************************************/
uint8_t  GPIO_EINTx_GetFlag(EINTx_CH_t EINTCH);
 /********************************************************************************
 ** \brief	 GPIO_EINTx_ClearFlag
 **			жϱ־λ
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03  		 
 ** \return  none
 ** \note  
 ******************************************************************************/
void GPIO_EINTx_ClearFlag(EINTx_CH_t EINTCH);

 /********************************************************************************
 ** \brief	 GPIO_ClearIntFlag
 **			жϱ־λ
 ** \param [in] EINTCH EINT00EINT01EINT02EINT03
 ** \param [in] TrigM: GPIO_INT_NONEGPIO_INT_RISING
 **                    GPIO_INT_FALLINGGPIO_INT_BOTH_EDGE	  		 
 ** \return  none
 ** \note  
 ******************************************************************************/
void GPIO_EINTx_Trig(EINTx_CH_t EINTCH, uint8_t TrigM);

#endif /* __GPIO_H__ */






